/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values.expressions;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Altstep;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Extfunction;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Function;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Testcase;
import org.eclipse.titan.designer.AST.TTCN3.types.Altstep_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.Function_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.Testcase_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.Altstep_Reference_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Function_Reference_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Testcase_Reference_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class RefersExpression
extends Expression_Value {
    private static final String OPERANDERROR = "Reference to a function, external function, altstep or testcase was expected.";
    private final Reference referred;
    private Assignment referredAssignment;

    public RefersExpression(Reference referred) {
        this.referred = referred;
        if (referred != null) {
            referred.setFullNameParent(this);
        }
    }

    @Override
    public Expression_Value.Operation_type getOperationType() {
        return Expression_Value.Operation_type.REFERS_OPERATION;
    }

    @Override
    public boolean checkExpressionSelfReference(CompilationTimeStamp timestamp, Assignment lhs) {
        return lhs == this.referredAssignment;
    }

    @Override
    public String createStringRepresentation() {
        if (this.referred == null) {
            return "<erroneous value>";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("refers(").append(this.referred.getDisplayName()).append(')');
        return builder.toString();
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.referred != null) {
            this.referred.setMyScope(scope);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.referred == child) {
            return builder.append(".<operand>");
        }
        return builder;
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        if (this.referredAssignment == null) {
            this.evaluateValue(timestamp, expectedValue, null);
        }
        if (this.referredAssignment == null) {
            return IType.Type_type.TYPE_UNDEFINED;
        }
        switch (this.referredAssignment.getAssignmentType()) {
            case A_FUNCTION: 
            case A_FUNCTION_RTEMP: 
            case A_FUNCTION_RVAL: 
            case A_EXT_FUNCTION: 
            case A_EXT_FUNCTION_RTEMP: 
            case A_EXT_FUNCTION_RVAL: {
                return IType.Type_type.TYPE_FUNCTION;
            }
            case A_ALTSTEP: {
                return IType.Type_type.TYPE_ALTSTEP;
            }
            case A_TESTCASE: {
                return IType.Type_type.TYPE_TESTCASE;
            }
        }
        return IType.Type_type.TYPE_UNDEFINED;
    }

    @Override
    public boolean isUnfoldable(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        return false;
    }

    private void checkExpressionOperands(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.referred == null) {
            return;
        }
        this.referredAssignment = this.referred.getRefdAssignment(timestamp, false);
        if (this.referredAssignment == null) {
            return;
        }
        switch (this.referredAssignment.getAssignmentType()) {
            case A_FUNCTION: 
            case A_FUNCTION_RTEMP: 
            case A_FUNCTION_RVAL: 
            case A_EXT_FUNCTION: 
            case A_EXT_FUNCTION_RTEMP: 
            case A_EXT_FUNCTION_RVAL: 
            case A_ALTSTEP: 
            case A_TESTCASE: {
                break;
            }
            default: {
                this.location.reportSemanticError(OPERANDERROR);
                this.setIsErroneous(true);
            }
        }
    }

    @Override
    public IValue evaluateValue(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return this.lastValue;
        }
        this.isErroneous = false;
        this.lastTimeChecked = timestamp;
        this.lastValue = this;
        if (this.referred == null) {
            return this.lastValue;
        }
        this.checkExpressionOperands(timestamp, expectedValue, referenceChain);
        if (this.getIsErroneous(timestamp) || this.referredAssignment == null) {
            return this.lastValue;
        }
        if (this.isUnfoldable(timestamp, referenceChain)) {
            return this.lastValue;
        }
        switch (this.referredAssignment.getAssignmentType()) {
            case A_FUNCTION: 
            case A_FUNCTION_RTEMP: 
            case A_FUNCTION_RVAL: {
                this.lastValue = new Function_Reference_Value((Def_Function)this.referredAssignment);
                this.lastValue.copyGeneralProperties(this);
                break;
            }
            case A_EXT_FUNCTION: 
            case A_EXT_FUNCTION_RTEMP: 
            case A_EXT_FUNCTION_RVAL: {
                this.lastValue = new Function_Reference_Value((Def_Extfunction)this.referredAssignment);
                this.lastValue.copyGeneralProperties(this);
                break;
            }
            case A_ALTSTEP: {
                this.lastValue = new Altstep_Reference_Value((Def_Altstep)this.referredAssignment);
                this.lastValue.copyGeneralProperties(this);
                break;
            }
            case A_TESTCASE: {
                this.lastValue = new Testcase_Reference_Value((Def_Testcase)this.referredAssignment);
                this.lastValue.copyGeneralProperties(this);
                break;
            }
            default: {
                this.setIsErroneous(true);
            }
        }
        return this.lastValue;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.referred != null) {
            this.referred.updateSyntax(reparser, false);
            reparser.updateLocation(this.referred.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.referred == null) {
            return;
        }
        this.referred.findReferences(referenceFinder, foundIdentifiers);
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        return this.referred == null || this.referred.accept(v);
    }

    @Override
    public void generateCodeExpressionExpression(JavaGenData aData, ExpressionStruct expression) {
        IType governor = this.myGovernor;
        if (governor == null) {
            governor = this.getExpressionGovernor(CompilationTimeStamp.getBaseTimestamp(), Expected_Value_type.EXPECTED_TEMPLATE);
        }
        if (governor == null) {
            governor = this.myLastSetGovernor;
        }
        if (governor == null || this.referredAssignment == null) {
            ErrorReporter.INTERNAL_ERROR((String)("FATAL ERROR while generating code for expression `" + this.getFullName() + "''"));
            return;
        }
        IType lastGovernor = governor.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
        String moduleName = this.referredAssignment.getMyScope().getModuleScopeGen().getName();
        String functionName = this.referredAssignment.getIdentifier().getName();
        expression.expression.append(MessageFormat.format("new {0}(new {0}.function_pointer() '{'\n", governor.getGenNameValue(aData, expression.expression)));
        expression.expression.append("@Override\n");
        expression.expression.append("public String getModuleName() {\n");
        expression.expression.append(MessageFormat.format("return \"{0}\";\n", moduleName));
        expression.expression.append("}\n");
        expression.expression.append("@Override\n");
        expression.expression.append("public String getDefinitionName() {\n");
        expression.expression.append(MessageFormat.format("return \"{0}\";\n", functionName));
        expression.expression.append("}\n");
        if (lastGovernor.getTypetype().equals((Object)IType.Type_type.TYPE_FUNCTION)) {
            expression.expression.append("@Override\n");
            expression.expression.append("public ");
            Function_Type functionType = (Function_Type)lastGovernor;
            Type returnType = functionType.getReturnType();
            StringBuilder actualParList = functionType.getFormalParameters().generateCodeActualParlist("");
            if (returnType == null) {
                expression.expression.append("void");
            } else if (functionType.returnsTemplate()) {
                expression.expression.append(returnType.getGenNameTemplate(aData, expression.expression));
            } else {
                expression.expression.append(returnType.getGenNameValue(aData, expression.expression));
            }
            expression.expression.append(" invoke(");
            functionType.getFormalParameters().generateCode(aData, expression.expression);
            expression.expression.append(") {\n");
            if (returnType != null) {
                expression.expression.append("return ");
            }
            expression.expression.append(this.referredAssignment.getGenNameFromScope(aData, expression.expression, ""));
            expression.expression.append('(');
            expression.expression.append((CharSequence)actualParList);
            expression.expression.append(");\n");
            expression.expression.append("}\n");
            if (functionType.isStartable(CompilationTimeStamp.getBaseTimestamp())) {
                aData.addBuiltinTypeImport("TitanComponent");
                expression.expression.append("@Override\n");
                expression.expression.append("public void start(final TitanComponent component_reference");
                if (functionType.getFormalParameters().getNofParameters() > 0) {
                    expression.expression.append(", ");
                    functionType.getFormalParameters().generateCode(aData, expression.expression);
                }
                expression.expression.append(") {\n");
                expression.expression.append(MessageFormat.format("{0}.start_{1}(component_reference", moduleName, functionName));
                if (actualParList != null && actualParList.length() > 0) {
                    expression.expression.append(MessageFormat.format(", {0}", actualParList));
                }
                expression.expression.append(");\n");
                expression.expression.append("}\n");
            }
        } else if (lastGovernor.getTypetype().equals((Object)IType.Type_type.TYPE_ALTSTEP)) {
            aData.addBuiltinTypeImport("Default_Base");
            aData.addBuiltinTypeImport("TitanAlt_Status");
            Altstep_Type altstepType = (Altstep_Type)lastGovernor;
            String altstepName = this.referredAssignment.getIdentifier().getName();
            String altstepGenName = this.referredAssignment.getGenNameFromScope(aData, expression.expression, "");
            StringBuilder actualParList = altstepType.getFormalParameters().generateCodeActualParlist("");
            expression.expression.append("@Override\n");
            expression.expression.append("public void invoke_standalone(");
            altstepType.getFormalParameters().generateCode(aData, expression.expression);
            expression.expression.append(") {\n");
            expression.expression.append(MessageFormat.format("{0}({1});\n", altstepGenName, actualParList));
            expression.expression.append("}\n");
            expression.expression.append("@Override\n");
            expression.expression.append("public Default_Base activate(");
            altstepType.getFormalParameters().generateCode(aData, expression.expression);
            expression.expression.append(") {\n");
            expression.expression.append(MessageFormat.format("return activate_{0}({1});\n", altstepName, actualParList));
            expression.expression.append("}\n");
            expression.expression.append("@Override\n");
            expression.expression.append("public TitanAlt_Status invoke(");
            altstepType.getFormalParameters().generateCode(aData, expression.expression);
            expression.expression.append(") {\n");
            expression.expression.append(MessageFormat.format("return {0}_instance({1});\n", altstepName, actualParList));
            expression.expression.append("}\n");
        } else if (lastGovernor.getTypetype().equals((Object)IType.Type_type.TYPE_TESTCASE)) {
            aData.addBuiltinTypeImport("TitanVerdictType");
            aData.addBuiltinTypeImport("TitanFloat");
            expression.expression.append("@Override\n");
            expression.expression.append("public ");
            Testcase_Type testcaseType = (Testcase_Type)lastGovernor;
            expression.expression.append("TitanVerdictType");
            expression.expression.append(" execute(");
            if (testcaseType.getFormalParameters().getNofParameters() > 0) {
                testcaseType.getFormalParameters().generateCode(aData, expression.expression);
                expression.expression.append(", ");
            }
            expression.expression.append("final boolean has_timer, final TitanFloat timer_value");
            expression.expression.append(") {\n");
            expression.expression.append("return testcase_");
            expression.expression.append(this.referredAssignment.getIdentifier().getName());
            expression.expression.append('(');
            if (testcaseType.getFormalParameters().getNofParameters() > 0) {
                expression.expression.append((CharSequence)testcaseType.getFormalParameters().generateCodeActualParlist(""));
                expression.expression.append(", ");
            }
            expression.expression.append("has_timer, timer_value");
            expression.expression.append(");\n");
            expression.expression.append("}\n");
        }
        expression.expression.append("})\n");
    }
}

