/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.views.msc.ui.core;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.titan.log.viewer.views.msc.ui.core.BaseMessage;
import org.eclipse.titan.log.viewer.views.msc.ui.core.MSCNode;
import org.eclipse.titan.log.viewer.views.msc.ui.core.RectangleDrawer;
import org.eclipse.titan.log.viewer.views.msc.ui.view.IGC;
import org.eclipse.titan.log.viewer.views.msc.util.MSCConstants;

public class Enqueued
extends BaseMessage {
    public Enqueued() {
        super(0);
    }

    @Override
    public int getX() {
        return MSCConstants.COLUMN_WIDTH * this.getEndLifeline().getIndex() + 3 * MSCConstants.COLUMN_WIDTH / 8;
    }

    @Override
    public int getY() {
        return MSCConstants.ROW_HEIGHT * this.eventOccurrence + 10;
    }

    @Override
    public int getWidth() {
        return MSCConstants.COLUMN_WIDTH / 4 + 1;
    }

    @Override
    public int getHeight() {
        return MSCConstants.ROW_HEIGHT - 20 + 1;
    }

    @Override
    public void draw(IGC context) {
        Rectangle rectangle = new Rectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        context.setLineStyle(context.getLineSolidStyle());
        RectangleDrawer.drawShadow(context, rectangle, RectangleDrawer.getColor("COLOR_GREY"), 1);
        RectangleDrawer.drawBox(context, rectangle, this.getBackgroundColor(), RectangleDrawer.getColor("COLOR_LIGHT_GREY"), 1);
        RectangleDrawer.drawBorder(context, rectangle, RectangleDrawer.getColor("COLOR_BLACK"), 1);
    }

    private Color getBackgroundColor() {
        return RectangleDrawer.getColor(MSCConstants.SILENT_EVENT_COLORS.get("PORTEVENT"));
    }

    @Override
    public MSCNode.Type getType() {
        return MSCNode.Type.ENQUEUED;
    }

    @Override
    public void drawSymbol(IGC context, int xLeft, int xRight, int yTop, int yBottom, int direction) {
        this.drawSymbol(context, xLeft, yBottom, direction);
    }

    @Override
    public void drawSymbol(IGC context, int x, int y, int direction) {
    }
}

