/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.graph.gui.dialogs;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titanium.graph.visualization.GraphHandler;
import org.eclipse.titanium.swt.SWTResourceManager;

public class ExportImagePreferencesDialog
extends Dialog {
    protected GraphHandler.ImageExportType result = GraphHandler.ImageExportType.EXPORT_SEEN_GRAPH;
    protected Shell shlExportGraph;
    private Combo mode;

    public ExportImagePreferencesDialog(Shell parent) {
        super(parent);
        this.setText("Export Graph");
    }

    public GraphHandler.ImageExportType open() {
        this.createContents();
        this.shlExportGraph.open();
        Display display = this.getParent().getDisplay();
        while (!this.shlExportGraph.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    private void createContents() {
        this.shlExportGraph = new Shell(this.getParent(), 34848);
        this.shlExportGraph.setImage(SWTResourceManager.getImage("resources/icons/sample.gif"));
        this.shlExportGraph.setLayout((Layout)new GridLayout(1, false));
        this.shlExportGraph.setText("Export Preferences");
        Composite selectWhatToSave = new Composite((Composite)this.shlExportGraph, 0);
        selectWhatToSave.setLayout((Layout)new FillLayout());
        Label lblPartToExport = new Label(selectWhatToSave, 0);
        lblPartToExport.setText("Part to export:");
        this.mode = new Combo(selectWhatToSave, 8);
        this.mode.setItems(new String[]{"Whole graph", "Only the seen part", "The satellite view"});
        this.mode.select(0);
        Button btnOk = new Button((Composite)this.shlExportGraph, 8);
        btnOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                switch (ExportImagePreferencesDialog.this.mode.getSelectionIndex()) {
                    case 0: {
                        ExportImagePreferencesDialog.this.result = GraphHandler.ImageExportType.EXPORT_WHOLE_GRAPH;
                        break;
                    }
                    case 1: {
                        ExportImagePreferencesDialog.this.result = GraphHandler.ImageExportType.EXPORT_SEEN_GRAPH;
                        break;
                    }
                    case 2: {
                        ExportImagePreferencesDialog.this.result = GraphHandler.ImageExportType.EXPORT_SATELLITE;
                        break;
                    }
                    default: {
                        ErrorReporter.logError((String)("unexpected selection index " + ExportImagePreferencesDialog.this.mode.getSelectionIndex()));
                        ExportImagePreferencesDialog.this.result = GraphHandler.ImageExportType.EXPORT_SEEN_GRAPH;
                    }
                }
                if (!ExportImagePreferencesDialog.this.shlExportGraph.isDisposed()) {
                    ExportImagePreferencesDialog.this.shlExportGraph.close();
                }
            }
        });
        btnOk.setText("OK");
        btnOk.setFocus();
        this.shlExportGraph.pack();
    }
}

