/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.markers.spotters.implementation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.TTCN3.definitions.ImportModule;
import org.eclipse.titan.designer.AST.TTCN3.definitions.TTCN3Module;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.titanium.markers.spotters.BaseCodeSmellSpotter;
import org.eclipse.titanium.markers.spotters.BaseProjectCodeSmellSpotter;
import org.eclipse.titanium.markers.spotters.implementation.CycleCheck;
import org.eclipse.titanium.markers.types.CodeSmellType;

public class CircularImportation
extends BaseProjectCodeSmellSpotter {
    public CircularImportation() {
        super(CodeSmellType.CIRCULAR_IMPORTATION);
    }

    @Override
    public void process(IProject project, BaseCodeSmellSpotter.Problems problems) {
        ProjectSourceParser projectSourceParser = GlobalParser.getProjectSourceParser((IProject)project);
        Set knownModuleNames = projectSourceParser.getKnownModuleNames();
        ArrayList<Module> modules = new ArrayList<Module>();
        for (String moduleName : new TreeSet(knownModuleNames)) {
            modules.add(projectSourceParser.getModuleByName(moduleName));
        }
        Collections.sort(modules, new Comparator<Module>(){

            @Override
            public int compare(Module o1, Module o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        CycleCheck check = new CycleCheck(modules);
        for (List<Module> cycle : check.cycles) {
            Module importer;
            StringBuilder sb = new StringBuilder("Importation cycle detected: ");
            for (Module module : cycle) {
                sb.append(module.getName());
                sb.append(" -> ");
            }
            sb.append(cycle.get(0).getName());
            String errMsg = sb.toString();
            Iterator<Module> it = cycle.iterator();
            Module imported = it.next();
            while (it.hasNext()) {
                importer = it.next();
                if (importer instanceof TTCN3Module) {
                    for (ImportModule im : ((TTCN3Module)importer).getImports()) {
                        if (!im.getName().equals(imported.getName())) continue;
                        problems.report(im.getLocation(), errMsg);
                    }
                }
                imported = importer;
            }
            importer = cycle.get(0);
            if (!(importer instanceof TTCN3Module)) continue;
            for (ImportModule im : ((TTCN3Module)importer).getImports()) {
                if (!im.getName().equals(imported.getName())) continue;
                problems.report(im.getLocation(), errMsg);
            }
        }
    }
}

