/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.markers.spotters.implementation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.TTCN3.attributes.WithAttributesPath;
import org.eclipse.titan.designer.AST.TTCN3.statements.SelectCase;
import org.eclipse.titan.designer.AST.TTCN3.statements.SelectCase_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.SelectCases;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateInstance;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateInstances;
import org.eclipse.titan.designer.AST.TTCN3.types.CompField;
import org.eclipse.titan.designer.AST.TTCN3.types.CompFieldMap;
import org.eclipse.titan.designer.AST.TTCN3.types.Referenced_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Choice_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.Boolean_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.IsChoosenExpression;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titanium.markers.spotters.BaseCodeSmellSpotter;
import org.eclipse.titanium.markers.spotters.BaseModuleCodeSmellSpotter;
import org.eclipse.titanium.markers.types.CodeSmellType;

public class SelectUnion
extends BaseModuleCodeSmellSpotter {
    private static final String ERR_MSG = "Suspected a select, which can be transformed into a select union statement.";
    private final CompilationTimeStamp timestamp = CompilationTimeStamp.getBaseTimestamp();

    public SelectUnion() {
        super(CodeSmellType.SELECT_UNION);
    }

    @Override
    protected void process(IVisitableNode node, BaseCodeSmellSpotter.Problems problems) {
        if (!(node instanceof SelectCase_Statement)) {
            return;
        }
        SelectCase_Statement s = (SelectCase_Statement)node;
        Value v = s.getExpression();
        if (v == null || v.getIsErroneous(this.timestamp)) {
            return;
        }
        SelectCases scs = s.getSelectCases();
        if (scs == null || scs.getSelectCaseArray() == null) {
            return;
        }
        if (!(v instanceof Boolean_Value) || !((Boolean_Value)v).getValue()) {
            return;
        }
        CaseVisitor caseVisitor = new CaseVisitor();
        scs.accept((ASTVisitor)caseVisitor);
        if (caseVisitor.isErronous()) {
            return;
        }
        ArrayList<Identifier> foundIds = new ArrayList<Identifier>();
        for (Reference ref : caseVisitor.getReferenceList()) {
            List reflist = ref.getSubreferences();
            if (reflist.isEmpty()) continue;
            foundIds.add(((ISubReference)reflist.get(reflist.size() - 1)).getId());
        }
        if (foundIds.isEmpty()) {
            return;
        }
        if (caseVisitor.getUnionType() == null) {
            return;
        }
        UnionItemVisitor unionVisitor = new UnionItemVisitor();
        caseVisitor.getUnionType().accept((ASTVisitor)unionVisitor);
        List<Identifier> unionItems = unionVisitor.getItemsFound();
        if (unionItems.isEmpty()) {
            return;
        }
        for (Identifier item : unionItems) {
            foundIds.remove(item);
        }
        if (foundIds.isEmpty()) {
            problems.report(s.getLocation(), ERR_MSG);
        }
    }

    @Override
    public List<Class<? extends IVisitableNode>> getStartNode() {
        ArrayList<Class<? extends IVisitableNode>> ret = new ArrayList<Class<? extends IVisitableNode>>(1);
        ret.add(SelectCase_Statement.class);
        return ret;
    }

    private final class UnionItemVisitor
    extends ASTVisitor {
        private final List<Identifier> itemsFound = new ArrayList<Identifier>();

        private UnionItemVisitor() {
        }

        public List<Identifier> getItemsFound() {
            return this.itemsFound;
        }

        public int visit(IVisitableNode node) {
            if (node instanceof TTCN3_Choice_Type) {
                return 3;
            }
            if (node instanceof WithAttributesPath) {
                return 3;
            }
            if (node instanceof CompFieldMap) {
                CompFieldMap cm = (CompFieldMap)node;
                Map map = cm.getComponentFieldMap(SelectUnion.this.timestamp);
                for (Map.Entry entry : map.entrySet()) {
                    this.itemsFound.add(((CompField)entry.getValue()).getIdentifier());
                }
                return 3;
            }
            return 1;
        }
    }

    private static final class IsChoosenItemVisitor
    extends ASTVisitor {
        private Reference reference;

        private IsChoosenItemVisitor() {
        }

        public Reference getReference() {
            return this.reference;
        }

        public int visit(IVisitableNode node) {
            if (node instanceof IsChoosenExpression) {
                return 3;
            }
            if (node instanceof Reference) {
                this.reference = (Reference)node;
                return 1;
            }
            return 1;
        }
    }

    private final class CaseVisitor
    extends ASTVisitor {
        private boolean errorDuringVisiting = false;
        private final List<Reference> references = new ArrayList<Reference>();
        private IType unionType = null;

        private CaseVisitor() {
        }

        public boolean isErronous() {
            return this.errorDuringVisiting;
        }

        public List<Reference> getReferenceList() {
            return this.references;
        }

        public IType getUnionType() {
            return this.unionType;
        }

        public int visit(IVisitableNode node) {
            if (node instanceof SelectCases) {
                return 3;
            }
            if (node instanceof SelectCase) {
                return 3;
            }
            if (node instanceof TemplateInstances) {
                return 3;
            }
            if (node instanceof TemplateInstance) {
                TemplateInstance ti = (TemplateInstance)node;
                IValue val = ti.getTemplateBody().getValue();
                if (val == null || val.getIsErroneous(SelectUnion.this.timestamp) || !(val instanceof IsChoosenExpression)) {
                    this.errorDuringVisiting = true;
                    return 2;
                }
                IsChoosenExpression expr = (IsChoosenExpression)val;
                IsChoosenItemVisitor itemVisitor = new IsChoosenItemVisitor();
                expr.accept((ASTVisitor)itemVisitor);
                if (itemVisitor.getReference() == null) {
                    this.errorDuringVisiting = true;
                    return 2;
                }
                if (!this.references.isEmpty() && !itemVisitor.getReference().getRefdAssignment(SelectUnion.this.timestamp, false).equals(this.references.get(0).getRefdAssignment(SelectUnion.this.timestamp, false))) {
                    this.errorDuringVisiting = true;
                    return 2;
                }
                if (this.unionType == null) {
                    IType itype = itemVisitor.getReference().checkVariableReference(SelectUnion.this.timestamp);
                    if (itype instanceof Referenced_Type) {
                        itype = itype.getTypeRefdLast(SelectUnion.this.timestamp);
                    }
                    if (itype != null) {
                        this.unionType = itype.getParentType();
                    }
                }
                this.references.add(itemVisitor.getReference());
                return 1;
            }
            return 1;
        }
    }
}

