/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.ASN1.values;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.values.Bitstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Named_Bits
extends Value {
    private final List<Identifier> identifierList = new ArrayList<Identifier>();
    private final Map<String, Identifier> identifierMap = new HashMap<String, Identifier>();
    private Bitstring_Value realValue;

    @Override
    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder("{");
        boolean first = true;
        for (Map.Entry<String, Identifier> entry : this.identifierMap.entrySet()) {
            if (!first) {
                builder.append(' ');
            }
            builder.append(entry.getValue().getDisplayName());
            first = false;
        }
        builder.append('}');
        return builder.toString();
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        if (null == this.lastTimeChecked || this.lastTimeChecked.isLess(timestamp)) {
            return IType.Type_type.TYPE_UNDEFINED;
        }
        if (null == this.realValue || this.realValue.getIsErroneous(timestamp)) {
            return IType.Type_type.TYPE_UNDEFINED;
        }
        return this.realValue.getExpressionReturntype(timestamp, expectedValue);
    }

    public int getNofIds() {
        return this.identifierMap.size();
    }

    public Identifier getIdByIndex(int i) {
        return this.identifierList.get(i);
    }

    public void addId(Identifier id) {
        if (this.identifierMap.containsKey(id.getName())) {
            id.getLocation().reportSyntacticError(MessageFormat.format("Duplicate named bit `{0}''", id.getDisplayName()));
        } else {
            this.identifierMap.put(id.getName(), id);
            this.identifierList.add(id);
        }
    }

    public boolean hasId(Identifier id) {
        return this.identifierMap.containsKey(id.getName());
    }

    public void setRealValue(Bitstring_Value realValue) {
        this.realValue = realValue;
    }

    @Override
    public IValue getReferencedSubValue(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, IReferenceChain refChain) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (this.getIsErroneous(timestamp) || subreferences.size() <= actualSubReference) {
            return this;
        }
        IValue result = this.getValueRefdLast(timestamp, refChain);
        if (null != result && result != this) {
            return result.getReferencedSubValue(timestamp, reference, actualSubReference, refChain);
        }
        IType type = this.myGovernor.getTypeRefdLast(timestamp);
        if (type.getIsErroneous(timestamp)) {
            return null;
        }
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid array element reference: type `{0}'' can not be indexed", type.getTypename()));
                return null;
            }
            case fieldSubReference: {
                this.location.reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((FieldSubReference)subreference).getId().getDisplayName(), type.getTypename()));
                return null;
            }
            case parameterisedSubReference: {
                subreference.getLocation().reportSemanticError("Invalid reference: internal parameterisation is not supported");
                return null;
            }
        }
        subreference.getLocation().reportSemanticError("Unsupported subreference kind.");
        return null;
    }

    @Override
    public IValue.Value_type getValuetype() {
        return IValue.Value_type.NAMED_BITS;
    }

    @Override
    public boolean isUnfoldable(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (null == this.realValue || this.realValue.getIsErroneous(timestamp)) {
            return true;
        }
        return this.realValue.isUnfoldable(timestamp, expectedValue, referenceChain);
    }

    @Override
    public IValue getValueRefdLast(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (null == this.realValue || this.realValue.getIsErroneous(timestamp)) {
            return this;
        }
        return this.realValue.getValueRefdLast(timestamp, expectedValue, referenceChain);
    }

    @Override
    public boolean checkEquality(CompilationTimeStamp timestamp, IValue other) {
        if (null == this.realValue) {
            return false;
        }
        return this.realValue.checkEquality(timestamp, other);
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.identifierList != null) {
            for (Identifier id : this.identifierList) {
                if (id.accept(v)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public StringBuilder generateCodeInit(JavaGenData aData, StringBuilder source, String name) {
        if (this.realValue != null) {
            return this.realValue.generateCodeInit(aData, source, name);
        }
        ErrorReporter.INTERNAL_ERROR((String)("named bits encountered in code generation of " + this.getFullName()));
        source.append("/* fatal error named bits encountered */");
        return source;
    }

    @Override
    public void reArrangeInitCode(JavaGenData aData, StringBuilder source, Module usageModule) {
        if (this.realValue != null) {
            this.realValue.reArrangeInitCode(aData, source, usageModule);
        }
    }

    @Override
    public void generateCodeExpression(JavaGenData aData, ExpressionStruct expression, boolean forceObject) {
        if (this.realValue != null) {
            this.realValue.generateCodeExpression(aData, expression, true);
            return;
        }
        ErrorReporter.INTERNAL_ERROR((String)("named bits encountered in code generation of " + this.getFullName()));
        expression.expression.append("/* fatal error named bits encountered */");
    }
}

