/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.StatementBlock;
import org.eclipse.titan.designer.AST.TTCN3.statements.Stop_Component_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.Stop_Port_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.Stop_Timer_Statement;
import org.eclipse.titan.designer.AST.TTCN3.values.Referenced_Value;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Unknown_Stop_Statement
extends Statement {
    private static final String UNEXPECTEDREFERENCE = "Port, timer or component reference was expected as the operand of stop operation instead of `{0}''";
    private static final String FULLNAMEPART = ".reference";
    private static final String STATEMENT_NAME = "stop";
    private final Reference reference;
    private Statement realStatement;
    private int statementIndex;

    public Unknown_Stop_Statement(Reference reference) {
        this.reference = reference;
        if (reference != null) {
            reference.setFullNameParent(this);
        }
    }

    @Override
    public Statement.Statement_type getType() {
        return Statement.Statement_type.S_STOP_UNKNOWN;
    }

    @Override
    public String getStatementName() {
        return STATEMENT_NAME;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.reference == child) {
            return builder.append(FULLNAMEPART);
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.reference != null) {
            this.reference.setMyScope(scope);
        }
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        if (this.reference != null) {
            this.reference.setCodeSection(codeSection);
        }
    }

    @Override
    public void setMyStatementBlock(StatementBlock statementBlock, int index) {
        super.setMyStatementBlock(statementBlock, index);
        this.statementIndex = index;
    }

    @Override
    public boolean isTerminating(CompilationTimeStamp timestamp) {
        if (this.realStatement != null) {
            return this.realStatement.isTerminating(timestamp);
        }
        return false;
    }

    @Override
    public boolean hasReceivingStatement() {
        if (this.realStatement != null) {
            return this.realStatement.hasReceivingStatement();
        }
        return false;
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        Assignment assignment = this.reference.getRefdAssignment(timestamp, true);
        if (assignment == null) {
            return;
        }
        switch (assignment.getAssignmentType()) {
            case A_PORT: 
            case A_PAR_PORT: {
                if (this.realStatement == null || !Statement.Statement_type.S_STOP_PORT.equals((Object)this.realStatement.getType())) {
                    this.realStatement = new Stop_Port_Statement(this.reference);
                    this.realStatement.setFullNameParent(this);
                    this.realStatement.setLocation(this.location);
                    this.realStatement.setMyStatementBlock(this.getMyStatementBlock(), this.statementIndex);
                }
                this.realStatement.check(timestamp);
                break;
            }
            case A_TIMER: 
            case A_PAR_TIMER: {
                if (this.realStatement == null || !Statement.Statement_type.S_STOP_TIMER.equals((Object)this.realStatement.getType())) {
                    this.realStatement = new Stop_Timer_Statement(this.reference);
                    this.realStatement.setFullNameParent(this);
                    this.realStatement.setLocation(this.location);
                    this.realStatement.setMyStatementBlock(this.getMyStatementBlock(), this.statementIndex);
                }
                this.realStatement.check(timestamp);
                break;
            }
            case A_CONST: 
            case A_EXT_CONST: 
            case A_MODULEPAR: 
            case A_VAR: 
            case A_FUNCTION_RVAL: 
            case A_EXT_FUNCTION_RVAL: 
            case A_PAR_VAL: 
            case A_PAR_VAL_IN: 
            case A_PAR_VAL_OUT: 
            case A_PAR_VAL_INOUT: {
                if (this.realStatement == null || !Statement.Statement_type.S_STOP_COMPONENT.equals((Object)this.realStatement.getType())) {
                    this.realStatement = new Stop_Component_Statement(new Referenced_Value(this.reference));
                    this.realStatement.setMyScope(this.reference.getMyScope());
                    this.realStatement.setFullNameParent(this);
                    this.realStatement.setLocation(this.location);
                    this.realStatement.setMyStatementBlock(this.getMyStatementBlock(), this.statementIndex);
                }
                this.realStatement.check(timestamp);
                break;
            }
            default: {
                this.reference.getLocation().reportSemanticError(MessageFormat.format(UNEXPECTEDREFERENCE, assignment.getDescription()));
            }
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.reference != null) {
            this.reference.updateSyntax(reparser, false);
            reparser.updateLocation(this.reference.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.realStatement != null) {
            this.realStatement.findReferences(referenceFinder, foundIdentifiers);
        } else if (this.reference != null) {
            this.reference.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.realStatement != null) {
            return this.realStatement.accept(v);
        }
        return this.reference == null || this.reference.accept(v);
    }

    @Override
    public void generateCode(JavaGenData aData, StringBuilder source) {
        if (this.realStatement != null) {
            this.realStatement.generateCode(aData, source);
        }
    }
}

