/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.templates;

import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.templates.All_From_Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.ListOfTemplates;
import org.eclipse.titan.designer.AST.TTCN3.templates.PermutationMatch_Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TTCN3Template;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public abstract class CompositeTemplate
extends TTCN3Template {
    private static final String FULLNAMEPART = ".list_item(";
    protected final ListOfTemplates templates;

    public CompositeTemplate(ListOfTemplates templates) {
        this.templates = templates;
        int size = templates.getNofTemplates();
        for (int i = 0; i < size; ++i) {
            templates.getTemplateByIndex(i).setFullNameParent(this);
        }
    }

    public TTCN3Template getTemplateByIndex(int index) {
        return this.templates.getTemplateByIndex(index);
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        this.templates.setMyScope(scope);
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        super.setCodeSection(codeSection);
        int size = this.templates.getNofTemplates();
        for (int i = 0; i < size; ++i) {
            this.templates.getTemplateByIndex(i).setCodeSection(codeSection);
        }
        if (this.lengthRestriction != null) {
            this.lengthRestriction.setCodeSection(codeSection);
        }
    }

    public int getNofTemplates() {
        return this.templates.getNofTemplates();
    }

    public int getNofTemplatesNotAnyornone(CompilationTimeStamp timestamp) {
        int result = 0;
        int size = this.templates.getNofTemplates();
        block5: for (int i = 0; i < size; ++i) {
            TTCN3Template template = this.templates.getTemplateByIndex(i);
            switch (template.getTemplatetype()) {
                case ANY_OR_OMIT: {
                    continue block5;
                }
                case PERMUTATION_MATCH: {
                    result += ((PermutationMatch_Template)template).getNofTemplatesNotAnyornone(timestamp);
                    continue block5;
                }
                case ALL_FROM: {
                    result += ((All_From_Template)template).getNofTemplatesNotAnyornone(timestamp);
                    continue block5;
                }
                default: {
                    ++result;
                }
            }
        }
        return result;
    }

    public boolean templateContainsAnyornone() {
        int size = this.templates.getNofTemplates();
        block4: for (int i = 0; i < size; ++i) {
            TTCN3Template template = this.templates.getTemplateByIndex(i);
            switch (template.getTemplatetype()) {
                case ANY_OR_OMIT: {
                    return true;
                }
                case PERMUTATION_MATCH: {
                    if (!((PermutationMatch_Template)template).templateContainsAnyornone()) continue block4;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean containsAnyornoneOrPermutation(CompilationTimeStamp timestamp) {
        int size = this.templates.getNofTemplates();
        for (int i = 0; i < size; ++i) {
            TTCN3Template template = this.templates.getTemplateByIndex(i);
            switch (template.getTemplatetype()) {
                case ANY_OR_OMIT: 
                case PERMUTATION_MATCH: {
                    return true;
                }
                case ALL_FROM: {
                    return ((All_From_Template)template).containsAnyornoneOrPermutation(timestamp);
                }
            }
        }
        return false;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        int size = this.templates.getNofTemplates();
        for (int i = 0; i < size; ++i) {
            if (this.templates.getTemplateByIndex(i) != child) continue;
            return builder.append(FULLNAMEPART).append(String.valueOf(i)).append(")");
        }
        return builder;
    }

    protected abstract String getNameForStringRep();

    @Override
    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getNameForStringRep()).append("( ");
        int size = this.templates.getNofTemplates();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            TTCN3Template template = this.templates.getTemplateByIndex(i);
            builder.append(template.createStringRepresentation());
        }
        builder.append(" )");
        if (this.lengthRestriction != null) {
            builder.append(this.lengthRestriction.createStringRepresentation());
        }
        if (this.isIfpresent) {
            builder.append("ifpresent");
        }
        return builder.toString();
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (referenceChain.add(this)) {
            int size = this.templates.getNofTemplates();
            for (int i = 0; i < size; ++i) {
                TTCN3Template template = this.templates.getTemplateByIndex(i);
                if (template == null) continue;
                referenceChain.markState();
                template.checkRecursions(timestamp, referenceChain);
                referenceChain.previousState();
            }
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.lengthRestriction != null) {
            this.lengthRestriction.updateSyntax(reparser, false);
            reparser.updateLocation(this.lengthRestriction.getLocation());
        }
        if (this.baseTemplate instanceof IIncrementallyUpdateable) {
            ((IIncrementallyUpdateable)((Object)this.baseTemplate)).updateSyntax(reparser, false);
            reparser.updateLocation(this.baseTemplate.getLocation());
        } else if (this.baseTemplate != null) {
            throw new ReParseException();
        }
        this.templates.updateSyntax(reparser, false);
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        super.findReferences(referenceFinder, foundIdentifiers);
        if (this.templates == null) {
            return;
        }
        this.templates.findReferences(referenceFinder, foundIdentifiers);
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        return this.templates == null || this.templates.accept(v);
    }

    @Override
    public void setMyDefinition(Definition definition) {
        int size = this.templates.getNofTemplates();
        for (int i = 0; i < size; ++i) {
            this.templates.getTemplateByIndex(i).setMyDefinition(definition);
        }
    }
}

