/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.core.makefile;

public final class UserStruct
implements Comparable<UserStruct> {
    private String directory;
    private String originalSourceLocation;
    private String originalHeaderLocation;
    private String fileName;
    private String filePrefix;
    private String headerName;
    private String sourceName;
    private boolean hasHHSuffix;
    private boolean hasCCSuffix;

    public StringBuilder headerName() {
        if (this.getHeaderName() == null) {
            return new StringBuilder();
        }
        StringBuilder result = new StringBuilder();
        if (this.getDirectory() != null) {
            result.append(this.getDirectory()).append('/');
        }
        result.append(this.getHeaderName());
        return result;
    }

    public StringBuilder sourceName() {
        if (this.getSourceName() == null) {
            return new StringBuilder();
        }
        StringBuilder result = new StringBuilder();
        if (this.getDirectory() != null) {
            result.append(this.getDirectory()).append('/');
        }
        result.append(this.getSourceName());
        return result;
    }

    public StringBuilder objectName() {
        if (this.getSourceName() == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        if (this.getDirectory() != null) {
            result.append(this.getDirectory()).append('/');
        }
        result.append(this.getFilePrefix()).append(".o");
        return result;
    }

    public StringBuilder specialName(String extension) {
        if (this.getSourceName() == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        if (this.getDirectory() != null) {
            result.append(this.getDirectory()).append('/');
        }
        result.append(this.getFilePrefix());
        if (extension != null) {
            result.append('.').append(extension);
        }
        return result;
    }

    @Override
    public int compareTo(UserStruct other) {
        return this.getFileName().compareTo(other.getFileName());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof UserStruct) {
            return this.getFileName().equals(((UserStruct)obj).getFileName());
        }
        return false;
    }

    public int hashCode() {
        return this.getFileName().hashCode();
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public String getOriginalSourceLocation() {
        return this.originalSourceLocation;
    }

    public void setOriginalSourceLocation(String originalSourceLocation) {
        this.originalSourceLocation = originalSourceLocation;
    }

    public String getOriginalHeaderLocation() {
        return this.originalHeaderLocation;
    }

    public void setOriginalHeaderLocation(String originalHeaderLocation) {
        this.originalHeaderLocation = originalHeaderLocation;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFilePrefix() {
        return this.filePrefix;
    }

    public void setFilePrefix(String filePrefix) {
        this.filePrefix = filePrefix;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public void setHeaderName(String headerName) {
        this.headerName = headerName;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public boolean isHasHHSuffix() {
        return this.hasHHSuffix;
    }

    public void setHasHHSuffix(boolean hasHHSuffix) {
        this.hasHHSuffix = hasHHSuffix;
    }

    public boolean isHasCCSuffix() {
        return this.hasCCSuffix;
    }

    public void setHasCCSuffix(boolean hasCCSuffix) {
        this.hasCCSuffix = hasCCSuffix;
    }
}

