/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.configeditor.pages.logging;

import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.titan.common.parsers.cfg.indices.LoggingSectionHandler;

public class ParamDialog
extends TitleAreaDialog {
    static final Pattern NAME_PATTERN = Pattern.compile("[A-Za-z][0-9A-Za-z_]*");
    static final Pattern VALUE_PATTERN = Pattern.compile("^\"[^\"]*\"$");
    private final boolean isAddition;
    private Text name;
    private Text value;
    private String nameField;
    private String valueField;
    private final LoggingSectionHandler.LogParamEntry logentry;
    private final LoggingSectionHandler.PluginSpecificParam param;

    public ParamDialog(Shell parentShell, LoggingSectionHandler.LogParamEntry logentry, LoggingSectionHandler.PluginSpecificParam param) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x8000);
        this.isAddition = param == null;
        this.logentry = logentry;
        this.param = param;
    }

    public String getName() {
        return this.nameField;
    }

    public String getValue() {
        return this.valueField;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        if (this.isAddition) {
            this.setTitle("Add a new parameter");
            this.getButton(0).setEnabled(false);
        } else {
            this.setTitle("Edit a parameter");
        }
        if (!this.isAddition) {
            if (this.param.getParamName() != null) {
                this.name.setText(this.param.getParamName());
            }
            if (this.param.getValue().getText() != null) {
                this.value.setText(this.param.getValue().getText());
            }
        }
        this.setMessage("Please enter the parameter name and the value", 1);
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        area.setLayout((Layout)layout);
        area.setLayoutData((Object)new GridData(1808));
        Label label1 = new Label(area, 0);
        label1.setText("Name");
        this.name = new Text(area, 2052);
        this.name.setLayoutData((Object)new GridData(768));
        this.name.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ParamDialog.this.nameField = ParamDialog.this.name.getText();
                ParamDialog.this.validate();
            }
        });
        Label label2 = new Label(area, 0);
        label2.setText("Value");
        this.value = new Text(area, 2052);
        this.value.setLayoutData((Object)new GridData(768));
        this.value.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ParamDialog.this.valueField = ParamDialog.this.value.getText();
                if (ParamDialog.this.valueField == null) {
                    ParamDialog.this.valueField = "";
                }
                ParamDialog.this.validate();
            }
        });
        return area;
    }

    private void validate() {
        List params;
        if (this.nameField == null || !NAME_PATTERN.matcher(this.nameField).matches()) {
            this.getButton(0).setEnabled(false);
            this.setErrorMessage("The name of the parameter must be a valid identifier.");
            return;
        }
        if (this.valueField == null || !VALUE_PATTERN.matcher(this.valueField).matches()) {
            this.getButton(0).setEnabled(false);
            this.setErrorMessage("The value of the parameter must be a valid string.");
            return;
        }
        if (this.nameField.length() > 0 && this.isAddition && (params = this.logentry.getPluginSpecificParam()) != null) {
            for (LoggingSectionHandler.PluginSpecificParam p : params) {
                if (!this.nameField.equals(p.getParamName())) continue;
                this.getButton(0).setEnabled(false);
                this.setErrorMessage("A parameter with this name already exists!");
                return;
            }
        }
        this.getButton(0).setEnabled(this.nameField.length() > 0 && this.valueField != null && this.valueField.length() > 0);
        this.setErrorMessage(null);
    }
}

