/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.parsers;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.MarkerHandler;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.TTCN3.definitions.TTCN3Module;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.OutOfMemoryCheck;
import org.eclipse.titan.designer.consoles.TITANDebugConsole;
import org.eclipse.titan.designer.core.LoadBalancingUtilities;
import org.eclipse.titan.designer.core.ProjectBasedBuilder;
import org.eclipse.titan.designer.core.TITANNature;
import org.eclipse.titan.designer.editors.EditorTracker;
import org.eclipse.titan.designer.editors.ISemanticTITANEditor;
import org.eclipse.titan.designer.extensions.ExtensionHandler;
import org.eclipse.titan.designer.graphics.ImageCache;
import org.eclipse.titan.designer.license.LicenseValidator;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ParserMarkerSupport;
import org.eclipse.titan.designer.parsers.ProjectSourceSemanticAnalyzer;
import org.eclipse.titan.designer.parsers.ProjectSourceSyntacticAnalyzer;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3Analyzer;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;
import org.eclipse.titan.designer.properties.IPropertyChangeListener;
import org.eclipse.titan.designer.properties.PropertyNotificationManager;
import org.eclipse.titan.designer.properties.data.ProjectConfigurationsPropertyData;
import org.eclipse.titan.designer.properties.data.ProjectFileHandler;
import org.eclipse.ui.progress.IProgressConstants;

public final class ProjectSourceParser {
    public static final String REQUIREDPROJECTNOTACCESSIBLE = "The project {0} is not accessible but is required to analyze the project {1}";
    public static final String REQUIREDPROJECTNOTTITANPROJECT = "The project {0} is not a TITAN project but is required to analyze the project {1}";
    private static final String SOURCE_ANALYSING = "Analysing the source code of project ";
    private final IProject project;
    private final ProjectSourceSyntacticAnalyzer syntacticAnalyzer;
    private final ProjectSourceSemanticAnalyzer semanticAnalyzer;
    private final AtomicInteger fullAnalyzersRunning = new AtomicInteger();
    private volatile WorkspaceJob lastFullAnalyzes = null;
    private volatile WorkspaceJob lastExtension = null;
    private volatile boolean analyzesRunning = false;
    private final AtomicInteger syntaxAnalyzersRunning = new AtomicInteger();
    private volatile WorkspaceJob lastSyntaxAnalyzes = null;
    private CompilationTimeStamp lastTimeChecked;
    private static IPropertyChangeListener listener = new IPropertyChangeListener(){

        @Override
        public void propertyChanged(IResource resource) {
            ProjectSourceParser projectSourceParser = GlobalParser.getProjectSourceParser(resource.getProject());
            if (resource instanceof IFile) {
                projectSourceParser.reportOutdating((IFile)resource);
            } else if (resource instanceof IFolder) {
                projectSourceParser.reportOutdating((IFolder)resource);
            }
            projectSourceParser.analyzeAll();
        }
    };

    public ProjectSourceParser(IProject project) {
        this.project = project;
        this.syntacticAnalyzer = new ProjectSourceSyntacticAnalyzer(project, this);
        this.semanticAnalyzer = new ProjectSourceSemanticAnalyzer();
    }

    ProjectSourceSyntacticAnalyzer getSyntacticAnalyzer() {
        return this.syntacticAnalyzer;
    }

    public ProjectSourceSemanticAnalyzer getSemanticAnalyzer() {
        return this.semanticAnalyzer;
    }

    public CompilationTimeStamp getLastTimeChecked() {
        return this.lastTimeChecked;
    }

    void setLastTimeChecked(CompilationTimeStamp lastTimeChecked) {
        this.lastTimeChecked = lastTimeChecked;
    }

    public boolean isOutdated(IFile file) {
        return this.syntacticAnalyzer.isOutdated(file) || this.semanticAnalyzer.isOutdated(file);
    }

    public Module getModuleByName(String name) {
        if (name == null) {
            return null;
        }
        return this.internalGetModuleByName(name, null, false);
    }

    public IFile getTTCN3IncludeFileByName(String name) {
        if (name == null) {
            return null;
        }
        return this.internalTTCN3IncludeFileByName(name, null);
    }

    private IFile internalTTCN3IncludeFileByName(String name, List<IProject> visitedprojects) {
        IFile tempFile = this.syntacticAnalyzer.internalGetTTCN3IncludeFileByName(name);
        if (tempFile != null) {
            return tempFile;
        }
        List<IProject> visited = visitedprojects;
        if (visited == null) {
            visited = new ArrayList<IProject>();
        }
        visited.add(this.project);
        for (IProject tempProject : ProjectBasedBuilder.getProjectBasedBuilder(this.project).getReferencedProjects()) {
            if (visited.contains(tempProject) || (tempFile = GlobalParser.getProjectSourceParser(tempProject).internalTTCN3IncludeFileByName(name, visited)) == null) continue;
            return tempFile;
        }
        return null;
    }

    public Collection<Module> getModules() {
        return this.semanticAnalyzer.internalGetModules();
    }

    private Module internalGetModuleByName(String name, List<IProject> visitedprojects, boolean uptodateOnly) {
        Module tempModule = this.semanticAnalyzer.internalGetModuleByName(name, uptodateOnly);
        if (tempModule != null) {
            return tempModule;
        }
        List<IProject> visited = visitedprojects;
        if (visited == null) {
            visited = new ArrayList<IProject>();
        }
        visited.add(this.project);
        for (IProject tempProject : ProjectBasedBuilder.getProjectBasedBuilder(this.project).getReferencedProjects()) {
            if (visited.contains(tempProject) || (tempModule = GlobalParser.getProjectSourceParser(tempProject).internalGetModuleByName(name, visited, uptodateOnly)) == null) continue;
            return tempModule;
        }
        return null;
    }

    public Set<String> getKnownModuleNames() {
        return this.internalGetKnownModuleNames(new ArrayList<IProject>());
    }

    private Set<String> internalGetKnownModuleNames(List<IProject> visitedprojects) {
        HashSet<String> temp = new HashSet<String>();
        if (visitedprojects.contains(this.project)) {
            return temp;
        }
        temp.addAll(this.semanticAnalyzer.internalGetKnownModuleNames());
        visitedprojects.add(this.project);
        for (IProject tempProject : ProjectBasedBuilder.getProjectBasedBuilder(this.project).getReferencedProjects()) {
            temp.addAll(GlobalParser.getProjectSourceParser(tempProject).internalGetKnownModuleNames(visitedprojects));
        }
        return temp;
    }

    public String containedModuleName(IFile file) {
        Module module = this.semanticAnalyzer.getModulebyFile(file);
        if (module != null) {
            return module.getName();
        }
        return null;
    }

    public Module containedModule(IFile file) {
        return this.semanticAnalyzer.getModulebyFile(file);
    }

    public WorkspaceJob reportOutdating(final IFile outdatedFile) {
        WorkspaceJob op = new WorkspaceJob("Reporting outdate for: " + outdatedFile.getName()){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                ProjectSourceParser.this.syntacticAnalyzer.reportOutdating(outdatedFile);
                ProjectSourceParser.this.semanticAnalyzer.reportSemanticOutdating(outdatedFile);
                return Status.OK_STATUS;
            }
        };
        op.setPriority(20);
        IPreferencesService preferenceService = Platform.getPreferencesService();
        if (preferenceService.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", true, null)) {
            op.setSystem(false);
            op.setUser(true);
        } else {
            op.setSystem(true);
            op.setUser(false);
        }
        op.setRule((ISchedulingRule)outdatedFile);
        op.setProperty(IProgressConstants.ICON_PROPERTY, (Object)ImageCache.getImageDescriptor("titan.gif"));
        op.schedule();
        return op;
    }

    public WorkspaceJob reportSyntacticOutdatingOnly(final IFile outdatedFile) {
        WorkspaceJob op = new WorkspaceJob("Reporting outdate for: " + outdatedFile.getName()){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                ProjectSourceParser.this.syntacticAnalyzer.reportSyntacticOutdatingOnly(outdatedFile);
                return Status.OK_STATUS;
            }
        };
        op.setPriority(20);
        IPreferencesService preferenceService = Platform.getPreferencesService();
        if (preferenceService.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", true, null)) {
            op.setSystem(false);
            op.setUser(true);
        } else {
            op.setSystem(true);
            op.setUser(false);
        }
        op.setRule((ISchedulingRule)outdatedFile);
        op.setProperty(IProgressConstants.ICON_PROPERTY, (Object)ImageCache.getImageDescriptor("titan.gif"));
        op.schedule();
        return op;
    }

    public WorkspaceJob reportOutdating(final List<IFile> outdatedFiles) {
        WorkspaceJob op = new WorkspaceJob("Reporting outdate for " + outdatedFiles.size() + " files"){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                for (IFile file : outdatedFiles) {
                    ProjectSourceParser.this.syntacticAnalyzer.reportOutdating(file);
                }
                return Status.OK_STATUS;
            }
        };
        op.setPriority(20);
        IPreferencesService preferenceService = Platform.getPreferencesService();
        if (preferenceService.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", true, null)) {
            op.setSystem(false);
            op.setUser(true);
        } else {
            op.setSystem(true);
            op.setUser(false);
        }
        op.setRule(this.getSchedulingRule());
        op.setProperty(IProgressConstants.ICON_PROPERTY, (Object)ImageCache.getImageDescriptor("titan.gif"));
        op.schedule();
        return op;
    }

    public WorkspaceJob reportSemanticOutdating(final List<IFile> outdatedFiles) {
        WorkspaceJob op = new WorkspaceJob("Reporting semantic outdate for " + outdatedFiles.size() + " files"){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                for (IFile outdatedFile : outdatedFiles) {
                    ProjectSourceParser.this.semanticAnalyzer.reportSemanticOutdating(outdatedFile);
                }
                return Status.OK_STATUS;
            }
        };
        op.setPriority(20);
        IPreferencesService preferenceService = Platform.getPreferencesService();
        if (preferenceService.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", true, null)) {
            op.setSystem(false);
            op.setUser(true);
        } else {
            op.setSystem(true);
            op.setUser(false);
        }
        op.setRule(this.getSchedulingRule());
        op.setProperty(IProgressConstants.ICON_PROPERTY, (Object)ImageCache.getImageDescriptor("titan.gif"));
        op.schedule();
        return op;
    }

    public WorkspaceJob clearSemanticInformation() {
        WorkspaceJob op = new WorkspaceJob("Clearing all semantic information"){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                ProjectSourceParser.this.semanticAnalyzer.clearSemanticInformation();
                return Status.OK_STATUS;
            }
        };
        op.setPriority(20);
        IPreferencesService preferenceService = Platform.getPreferencesService();
        if (preferenceService.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", true, null)) {
            op.setSystem(false);
            op.setUser(true);
        } else {
            op.setSystem(true);
            op.setUser(false);
        }
        op.setRule(this.getSchedulingRule());
        op.setProperty(IProgressConstants.ICON_PROPERTY, (Object)ImageCache.getImageDescriptor("titan.gif"));
        op.schedule();
        return op;
    }

    public WorkspaceJob reportOutdating(final IFolder outdatedFolder) {
        WorkspaceJob op = new WorkspaceJob("Reporting outdate for: " + outdatedFolder.getName()){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                ProjectSourceParser.this.syntacticAnalyzer.reportOutdating(outdatedFolder);
                return Status.OK_STATUS;
            }
        };
        op.setPriority(20);
        IPreferencesService preferenceService = Platform.getPreferencesService();
        if (preferenceService.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", true, null)) {
            op.setSystem(false);
            op.setUser(true);
        } else {
            op.setSystem(true);
            op.setUser(false);
        }
        op.setRule((ISchedulingRule)outdatedFolder);
        op.setProperty(IProgressConstants.ICON_PROPERTY, (Object)ImageCache.getImageDescriptor("titan.gif"));
        op.schedule();
        return op;
    }

    public WorkspaceJob updateSyntax(final IFile file, final TTCN3ReparseUpdater reparser) {
        WorkspaceJob op = new WorkspaceJob("Updating the syntax incrementally for: " + file.getName()){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                double parserStart = System.nanoTime();
                ProjectSourceParser.this.syntacticAnalyzer.updateSyntax(file, reparser);
                IPreferenceStore store = Activator.getDefault().getPreferenceStore();
                if (store.getBoolean("org.eclipse.titan.designer.displayDebugInformation")) {
                    TITANDebugConsole.println("Refreshing the syntax took " + ((double)System.nanoTime() - parserStart) * 1.0E-9 + " secs");
                }
                TTCN3Module actualModule = (TTCN3Module)GlobalParser.getProjectSourceParser(file.getProject()).containedModule(file);
                TTCN3Analyzer.md5_parser(file, reparser.getCode(), actualModule);
                return Status.OK_STATUS;
            }
        };
        op.setPriority(20);
        IPreferencesService preferenceService = Platform.getPreferencesService();
        if (preferenceService.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", true, null)) {
            op.setSystem(false);
            op.setUser(true);
        } else {
            op.setSystem(true);
            op.setUser(false);
        }
        op.setRule((ISchedulingRule)file);
        op.setProperty(IProgressConstants.ICON_PROPERTY, (Object)ImageCache.getImageDescriptor("titan.gif"));
        op.schedule();
        return op;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IStatus internalDoAnalyzeWithReferences(SubMonitor monitor) {
        Location location;
        MarkerHandler.markMarkersForRemoval("org.eclipse.titan.designer.ontheflySemanticMarker", (IResource)this.project);
        if (!ProjectSourceParser.checkConfigurationRequirements(this.project, "org.eclipse.titan.designer.ontheflySemanticMarker")) {
            MarkerHandler.removeMarkedMarkers("org.eclipse.titan.designer.ontheflySemanticMarker", (IResource)this.project);
            return Status.OK_STATUS;
        }
        MarkerHandler.removeMarkedMarkers("org.eclipse.titan.designer.ontheflySemanticMarker", (IResource)this.project);
        if (OutOfMemoryCheck.isOutOfMemoryAlreadyReported()) {
            return Status.CANCEL_STATUS;
        }
        List<IProject> tobeAnalyzed = ProjectBasedBuilder.getProjectBasedBuilder(this.project).getAllReachableProjects();
        LinkedList<IProject> temporalList = new LinkedList<IProject>();
        temporalList.addLast(this.project);
        tobeAnalyzed.remove(this.project);
        while (!temporalList.isEmpty()) {
            IProject[] tempProjects;
            IProject tempProject = (IProject)temporalList.removeFirst();
            if (tobeAnalyzed.contains(tempProject)) continue;
            tobeAnalyzed.add(tempProject);
            for (IProject tempProject2 : tempProjects = ProjectBasedBuilder.getProjectBasedBuilder(tempProject).getReferencingProjects()) {
                if (GlobalParser.getProjectSourceParser((IProject)tempProject2).analyzesRunning) continue;
                if (tempProject2.isAccessible()) {
                    temporalList.addLast(tempProject2);
                    continue;
                }
                location = new Location((IResource)this.project);
                location.reportExternalProblem(MessageFormat.format("The project {0} is not accessible but requires to analyze the project {1}", tempProject2.getName(), tempProject.getName()), 2, "org.eclipse.titan.designer.ontheflySemanticMarker");
            }
        }
        ArrayList<IProject> additionalRequired = new ArrayList<IProject>();
        for (IProject project : tobeAnalyzed) {
            List<IProject> temp = ProjectBasedBuilder.getProjectBasedBuilder(project).getAllReachableProjects();
            for (IProject temp2 : temp) {
                if (tobeAnalyzed.contains(temp2) || additionalRequired.contains(temp2) || GlobalParser.getProjectSourceParser(temp2).getLastTimeChecked() != null) continue;
                if (temp2.isAccessible()) {
                    additionalRequired.add(temp2);
                    continue;
                }
                location = new Location((IResource)project);
                location.reportExternalProblem(MessageFormat.format(REQUIREDPROJECTNOTACCESSIBLE, temp2.getName(), project.getName()), 2, "org.eclipse.titan.designer.ontheflySemanticMarker");
            }
        }
        tobeAnalyzed.addAll(additionalRequired);
        CompilationTimeStamp compilationCounter = CompilationTimeStamp.getNewCompilationCounter();
        final SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(tobeAnalyzed.size() * 2));
        progress.setTaskName("Analysis of projects");
        IPreferencesService preferenceService = Platform.getPreferencesService();
        boolean reportDebugInformation = preferenceService.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", true, null);
        if (reportDebugInformation) {
            TITANDebugConsole.println("On-the-fly analyzation of project " + this.project.getName() + " started");
        }
        try {
            final ConcurrentLinkedQueue tobeSemanticallyAnalyzed = new ConcurrentLinkedQueue();
            int availableProcessors = Runtime.getRuntime().availableProcessors();
            IPreferencesService prefs = Platform.getPreferencesService();
            int processingUnitsToUse = prefs.getInt("org.eclipse.titan.designer", "org.eclipse.titan.designer.processingUnitsToUse", availableProcessors, null);
            boolean limitAllThreadCreation = prefs.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.limitAllThreadCreation", false, null);
            ThreadFactory threadFactory = new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = new Thread(r);
                    t.setPriority(LoadBalancingUtilities.getThreadPriority());
                    return t;
                }
            };
            ExecutorService executor = limitAllThreadCreation ? Executors.newFixedThreadPool(processingUnitsToUse, threadFactory) : Executors.newCachedThreadPool(threadFactory);
            final CountDownLatch latch = new CountDownLatch(tobeAnalyzed.size());
            for (final IProject tempProject : tobeAnalyzed) {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (progress.isCanceled()) {
                            latch.countDown();
                            throw new OperationCanceledException();
                        }
                        progress.subTask("Analyzing project " + tempProject.getName());
                        GlobalParser.getProjectSourceParser(tempProject).analyzesRunning = true;
                        try {
                            if (tempProject.isAccessible()) {
                                if (TITANNature.hasTITANNature(tempProject)) {
                                    GlobalParser.getProjectSourceParser(tempProject).syntacticAnalyzer.internalDoAnalyzeSyntactically((IProgressMonitor)progress.newChild(1));
                                    tobeSemanticallyAnalyzed.add(tempProject);
                                } else {
                                    Location location = new Location((IResource)ProjectSourceParser.this.project, 0, 0, 0);
                                    location.reportExternalProblem(MessageFormat.format(ProjectSourceParser.REQUIREDPROJECTNOTTITANPROJECT, tempProject.getName(), ProjectSourceParser.this.project.getName()), 2, "org.eclipse.titan.designer.ontheflySemanticMarker");
                                    progress.worked(1);
                                }
                            } else {
                                Location location = new Location((IResource)ProjectSourceParser.this.project);
                                location.reportExternalProblem(MessageFormat.format(ProjectSourceParser.REQUIREDPROJECTNOTACCESSIBLE, tempProject.getName(), ProjectSourceParser.this.project.getName()), 2, "org.eclipse.titan.designer.ontheflySemanticMarker");
                                progress.worked(1);
                            }
                        }
                        catch (Exception e) {
                            ErrorReporter.logExceptionStackTrace((Exception)e);
                        }
                        finally {
                            latch.countDown();
                        }
                    }
                });
            }
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                ErrorReporter.logExceptionStackTrace((Exception)e);
            }
            executor.shutdown();
            try {
                executor.awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                ErrorReporter.logExceptionStackTrace((Exception)e);
            }
            executor.shutdownNow();
            ProjectSourceSemanticAnalyzer.analyzeMultipleProjectsSemantically(new ArrayList<IProject>(tobeSemanticallyAnalyzed), (IProgressMonitor)progress.newChild(tobeAnalyzed.size()), compilationCounter);
        }
        catch (Throwable throwable) {
            for (int i = 0; i < tobeAnalyzed.size(); ++i) {
                GlobalParser.getProjectSourceParser((IProject)tobeAnalyzed.get((int)i)).analyzesRunning = false;
            }
            throw throwable;
        }
        for (int i = 0; i < tobeAnalyzed.size(); ++i) {
            GlobalParser.getProjectSourceParser((IProject)tobeAnalyzed.get((int)i)).analyzesRunning = false;
        }
        progress.done();
        this.lastTimeChecked = compilationCounter;
        return Status.OK_STATUS;
    }

    public WorkspaceJob analyzeAllOnlySyntactically() {
        IPreferencesService prefs = Platform.getPreferencesService();
        if (!prefs.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.useOnTheFlyParsing", true, null)) {
            return null;
        }
        WorkspaceJob op = new WorkspaceJob(SOURCE_ANALYSING + this.project.getName()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IStatus runInWorkspace(IProgressMonitor monitor) {
                IStatus result = Status.OK_STATUS;
                if (!ProjectSourceParser.this.project.isAccessible() || !TITANNature.hasTITANNature(ProjectSourceParser.this.project)) {
                    ProjectSourceParser.this.syntaxAnalyzersRunning.decrementAndGet();
                    return Status.CANCEL_STATUS;
                }
                if (!LicenseValidator.check()) {
                    ProjectSourceParser.this.syntaxAnalyzersRunning.decrementAndGet();
                    return Status.CANCEL_STATUS;
                }
                if (monitor.isCanceled()) {
                    ProjectSourceParser.this.syntaxAnalyzersRunning.decrementAndGet();
                    return Status.CANCEL_STATUS;
                }
                int priority = this.getThread().getPriority();
                try {
                    this.getThread().setPriority(1);
                    long absoluteStart = System.nanoTime();
                    IPreferencesService preferenceService = Platform.getPreferencesService();
                    String compilerOption = preferenceService.getString("org.eclipse.titan.designer", "org.eclipse.titan.designer.compilerMarkersAfterAnalyzation", "Become outdated", null);
                    if ("Are removed".equals(compilerOption)) {
                        ParserMarkerSupport.removeAllCompilerMarkers((IResource)ProjectSourceParser.this.project);
                    } else if ("Become outdated".equals(compilerOption)) {
                        for (IFile file : EditorTracker.keyset()) {
                            if (file.getProject() != ProjectSourceParser.this.project) continue;
                            ISemanticTITANEditor editor = EditorTracker.getEditor(file).get(0);
                            MarkerHandler.deprecateMarkers(editor, ParserMarkerSupport.getAllCompilerMarkers((IResource)ProjectSourceParser.this.project));
                        }
                    }
                    ProjectSourceParser.this.syntacticAnalyzer.internalDoAnalyzeSyntactically2(monitor);
                    boolean reportDebugInformation = preferenceService.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", true, null);
                    if (reportDebugInformation) {
                        TITANDebugConsole.println("The whole syntax only analysis block took " + (double)(System.nanoTime() - absoluteStart) * 1.0E-9 + " seconds to complete");
                    }
                }
                catch (Exception e) {
                    ErrorReporter.logExceptionStackTrace((Exception)e);
                }
                finally {
                    ProjectSourceParser.this.syntaxAnalyzersRunning.decrementAndGet();
                    this.getThread().setPriority(priority);
                }
                return result;
            }
        };
        op.setPriority(30);
        IPreferencesService preferenceService = Platform.getPreferencesService();
        if (preferenceService.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", true, null)) {
            op.setSystem(false);
            op.setUser(true);
        } else {
            op.setSystem(true);
            op.setUser(false);
        }
        op.setProperty(IProgressConstants.ICON_PROPERTY, (Object)ImageCache.getImageDescriptor("titan.gif"));
        op.setRule(this.getSchedulingRule());
        if (this.syntaxAnalyzersRunning.get() > 0 && this.lastSyntaxAnalyzes != null && this.lastSyntaxAnalyzes.getState() != 4) {
            this.lastSyntaxAnalyzes.cancel();
        }
        op.schedule();
        this.lastSyntaxAnalyzes = op;
        this.syntaxAnalyzersRunning.incrementAndGet();
        return op;
    }

    public WorkspaceJob analyzeAll() {
        return this.analyzeAll(true, false);
    }

    public WorkspaceJob analyzeAll(boolean allowQuickExit) {
        return this.analyzeAll(allowQuickExit, false);
    }

    public WorkspaceJob analyzeAll(boolean allowQuickExit, boolean waitToFinish) {
        boolean alreadyRunning;
        IPreferencesService prefs = Platform.getPreferencesService();
        if (!prefs.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.useOnTheFlyParsing", true, null)) {
            return null;
        }
        WorkspaceJob configAnalyzes = GlobalParser.getConfigSourceParser(this.project).doSyntaticalAnalyze();
        WorkspaceJob analyzes = new WorkspaceJob(SOURCE_ANALYSING + this.project.getName()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IStatus runInWorkspace(IProgressMonitor monitor) {
                IStatus result = Status.OK_STATUS;
                if (!ProjectSourceParser.this.project.isAccessible() || !TITANNature.hasTITANNature(ProjectSourceParser.this.project)) {
                    return Status.CANCEL_STATUS;
                }
                if (!LicenseValidator.check()) {
                    return Status.CANCEL_STATUS;
                }
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                int priority = this.getThread().getPriority();
                try {
                    this.getThread().setPriority(1);
                    long absoluteStart = System.nanoTime();
                    IPreferencesService preferenceService = Platform.getPreferencesService();
                    String compilerOption = preferenceService.getString("org.eclipse.titan.designer", "org.eclipse.titan.designer.compilerMarkersAfterAnalyzation", "Become outdated", null);
                    if ("Are removed".equals(compilerOption)) {
                        ParserMarkerSupport.removeAllCompilerMarkers((IResource)ProjectSourceParser.this.project);
                    } else if ("Become outdated".equals(compilerOption)) {
                        for (IFile file : EditorTracker.keyset()) {
                            List<ISemanticTITANEditor> editors;
                            if (file.getProject() != ProjectSourceParser.this.project || (editors = EditorTracker.getEditor(file)) == null || editors.isEmpty()) continue;
                            ISemanticTITANEditor editor = editors.get(0);
                            MarkerHandler.deprecateMarkers(editor, ParserMarkerSupport.getAllCompilerMarkers((IResource)ProjectSourceParser.this.project));
                        }
                    }
                    result = ProjectSourceParser.this.internalDoAnalyzeWithReferences(SubMonitor.convert((IProgressMonitor)monitor));
                    boolean reportDebugInformation = preferenceService.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", true, null);
                    if (reportDebugInformation) {
                        TITANDebugConsole.println("The whole analysis block took " + (double)(System.nanoTime() - absoluteStart) * 1.0E-9 + " seconds to complete");
                    }
                }
                catch (Exception e) {
                    ErrorReporter.logExceptionStackTrace((Exception)e);
                }
                finally {
                    this.getThread().setPriority(priority);
                }
                return result;
            }
        };
        analyzes.setPriority(30);
        IPreferencesService preferenceService = Platform.getPreferencesService();
        if (preferenceService.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", true, null)) {
            analyzes.setSystem(false);
            analyzes.setUser(true);
        } else {
            analyzes.setSystem(true);
            analyzes.setUser(false);
        }
        analyzes.setProperty(IProgressConstants.ICON_PROPERTY, (Object)ImageCache.getImageDescriptor("titan.gif"));
        ISchedulingRule rule = this.getSchedulingRule();
        analyzes.setRule(rule);
        boolean bl = alreadyRunning = this.fullAnalyzersRunning.get() > 0;
        if (alreadyRunning) {
            if (this.lastFullAnalyzes != null && this.lastFullAnalyzes.getState() != 4) {
                this.lastFullAnalyzes.cancel();
            }
            this.lastFullAnalyzes = analyzes;
        }
        analyzes.schedule();
        if (waitToFinish) {
            try {
                analyzes.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.fullAnalyzersRunning.incrementAndGet();
        final WorkspaceJob temp = analyzes;
        final WorkspaceJob temp2 = configAnalyzes;
        WorkspaceJob extensions = new WorkspaceJob("Executing Titan extensions on project " + this.project.getName()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IStatus runInWorkspace(IProgressMonitor monitor) {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                int priortity = this.getThread().getPriority();
                try {
                    this.getThread().setPriority(1);
                    progress.setTaskName("Executing Titan extensions on project " + ProjectSourceParser.this.project.getName());
                    progress.subTask("Waiting for semantic analysis");
                    try {
                        temp.join();
                        if (temp2 != null) {
                            temp2.join();
                        }
                    }
                    catch (Exception e) {
                        ErrorReporter.logExceptionStackTrace((Exception)e);
                    }
                    progress.subTask("Executing extensions");
                    if (Status.OK_STATUS.equals(temp.getResult())) {
                        ExtensionHandler.INSTANCE.executeContributors((IProgressMonitor)progress.newChild(100), ProjectSourceParser.this.project);
                    }
                }
                finally {
                    progress.done();
                    ProjectSourceParser.this.fullAnalyzersRunning.decrementAndGet();
                    this.getThread().setPriority(priortity);
                }
                return Status.OK_STATUS;
            }
        };
        if (preferenceService.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", true, null)) {
            extensions.setSystem(false);
            extensions.setUser(true);
        } else {
            extensions.setSystem(true);
            extensions.setUser(false);
        }
        extensions.setRule(rule);
        if (alreadyRunning) {
            if (this.lastExtension != null && this.lastExtension.getState() != 4) {
                this.lastExtension.cancel();
            }
            this.lastExtension = extensions;
        }
        extensions.schedule();
        return extensions;
    }

    private ISchedulingRule getSchedulingRule() {
        LinkedList<IProject> temporalList = new LinkedList<IProject>();
        List<IProject> projectTobeLocked = ProjectBasedBuilder.getProjectBasedBuilder(this.project).getAllReachableProjects();
        IProject[] iterator = projectTobeLocked.iterator();
        while (iterator.hasNext()) {
            IProject temp = iterator.next();
            if (GlobalParser.getProjectSourceParser(temp).getLastTimeChecked() == null) continue;
            iterator.remove();
        }
        temporalList.addLast(this.project);
        projectTobeLocked.remove(this.project);
        while (!temporalList.isEmpty()) {
            IProject[] tempProjects;
            IProject tempProject = (IProject)temporalList.getFirst();
            temporalList.removeFirst();
            if (projectTobeLocked.contains(tempProject)) continue;
            projectTobeLocked.add(tempProject);
            for (IProject tempProject2 : tempProjects = ProjectBasedBuilder.getProjectBasedBuilder(tempProject).getReferencingProjects()) {
                if (GlobalParser.getProjectSourceParser((IProject)tempProject2).analyzesRunning) continue;
                temporalList.addLast(tempProject2);
            }
        }
        ArrayList<IProject> additionalRequired = new ArrayList<IProject>();
        for (IProject project : projectTobeLocked) {
            List<IProject> temp = ProjectBasedBuilder.getProjectBasedBuilder(project).getAllReachableProjects();
            for (IProject temp2 : temp) {
                if (projectTobeLocked.contains(temp2) || additionalRequired.contains(temp2)) continue;
                additionalRequired.add(temp2);
            }
        }
        projectTobeLocked.addAll(additionalRequired);
        IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
        ISchedulingRule combinedRule = null;
        for (IProject project : projectTobeLocked) {
            combinedRule = MultiRule.combine((ISchedulingRule)ruleFactory.createRule((IResource)project), combinedRule);
        }
        return combinedRule;
    }

    public static boolean checkConfigurationRequirements(IProject project, String markerType) {
        IProject[] referencedProjects;
        try {
            referencedProjects = project.getReferencedProjects();
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            return false;
        }
        List<ProjectConfigurationsPropertyData.ConfigurationRequirement> requirements = ProjectConfigurationsPropertyData.getConfigurationRequirements(project);
        block2: for (ProjectConfigurationsPropertyData.ConfigurationRequirement temp : requirements) {
            if (temp.getConfiguration() == null || "".equals(temp.getConfiguration())) continue;
            for (IProject referencedProject : referencedProjects) {
                String name = referencedProject.getName();
                if (!name.equals(temp.getProjectName())) continue;
                String tempActiveConfiguration = ProjectFileHandler.getActiveConfigurationName(referencedProject);
                if (temp.getConfiguration().equals(tempActiveConfiguration)) continue block2;
                Location location = new Location((IResource)project);
                location.reportExternalProblem("In order to build project `" + project.getName() + "' project `" + name + "' must be using the `" + temp.getConfiguration() + "' configuration, but right now it is using `" + tempActiveConfiguration + "'", 2, markerType);
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makefileCreatingAnalyzeAll() {
        if (this.lastTimeChecked != null) {
            return;
        }
        IPreferencesService prefs = Platform.getPreferencesService();
        if (!prefs.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.useOnTheFlyParsing", true, null)) {
            return;
        }
        this.fullAnalyzersRunning.incrementAndGet();
        ISchedulingRule rule = this.getSchedulingRule();
        Job.getJobManager().beginRule(rule, (IProgressMonitor)new NullProgressMonitor());
        try {
            this.internalDoAnalyzeWithReferences(null);
        }
        catch (Exception e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
        finally {
            Job.getJobManager().endRule(rule);
            this.fullAnalyzersRunning.decrementAndGet();
        }
    }

    static {
        PropertyNotificationManager.addListener(listener);
    }
}

