/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.renderer;

import com.github.weisj.jsvg.attributes.FillRule;
import com.github.weisj.jsvg.attributes.PaintOrder;
import com.github.weisj.jsvg.attributes.ViewBox;
import com.github.weisj.jsvg.attributes.font.FontResolver;
import com.github.weisj.jsvg.attributes.font.MeasurableFontSpec;
import com.github.weisj.jsvg.attributes.font.SVGFont;
import com.github.weisj.jsvg.attributes.paint.PredefinedPaints;
import com.github.weisj.jsvg.attributes.paint.SVGPaint;
import com.github.weisj.jsvg.attributes.stroke.StrokeResolver;
import com.github.weisj.jsvg.geometry.size.MeasureContext;
import com.github.weisj.jsvg.nodes.prototype.Mutator;
import com.github.weisj.jsvg.renderer.ContextElementAttributes;
import com.github.weisj.jsvg.renderer.FontRenderContext;
import com.github.weisj.jsvg.renderer.Output;
import com.github.weisj.jsvg.renderer.PaintContext;
import com.github.weisj.jsvg.renderer.StrokeContext;
import com.github.weisj.jsvg.renderer.awt.PlatformSupport;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RenderContext {
    @NotNull
    private final PlatformSupport awtSupport;
    @NotNull
    private final MeasureContext measureContext;
    @NotNull
    private final PaintContext paintContext;
    @NotNull
    private final FontRenderContext fontRenderContext;
    @NotNull
    private final MeasurableFontSpec fontSpec;
    @Nullable
    private final ContextElementAttributes contextElementAttributes;
    @NotNull
    private final AffineTransform rootTransform;
    @NotNull
    private final AffineTransform userSpaceTransform;

    @NotNull
    public static RenderContext createInitial(@NotNull PlatformSupport awtSupport, @NotNull MeasureContext measureContext) {
        return new RenderContext(awtSupport, new AffineTransform(), new AffineTransform(), PaintContext.createDefault(), measureContext, FontRenderContext.createDefault(), MeasurableFontSpec.createDefault(), null);
    }

    RenderContext(@NotNull PlatformSupport platformSupport, @NotNull AffineTransform rootTransform, @NotNull AffineTransform userSpaceTransform, @NotNull PaintContext paintContext, @NotNull MeasureContext measureContext, @NotNull FontRenderContext fontRenderContext, @NotNull MeasurableFontSpec fontSpec, @Nullable ContextElementAttributes contextElementAttributes) {
        this.awtSupport = platformSupport;
        this.rootTransform = rootTransform;
        this.userSpaceTransform = userSpaceTransform;
        this.paintContext = paintContext;
        this.measureContext = measureContext;
        this.fontRenderContext = fontRenderContext;
        this.fontSpec = fontSpec;
        this.contextElementAttributes = contextElementAttributes;
    }

    @NotNull
    RenderContext derive(@Nullable Mutator<PaintContext> context, @Nullable Mutator<MeasurableFontSpec> attributeFontSpec, @Nullable ViewBox viewBox, @Nullable FontRenderContext frc, @Nullable ContextElementAttributes contextAttributes, EstablishRootMeasure establishRootMeasure) {
        return this.deriveImpl(context, attributeFontSpec, viewBox, frc, contextAttributes, null, establishRootMeasure);
    }

    @NotNull
    private RenderContext deriveImpl(@Nullable Mutator<PaintContext> context, @Nullable Mutator<MeasurableFontSpec> attributeFontSpec, @Nullable ViewBox viewBox, @Nullable FontRenderContext frc, @Nullable ContextElementAttributes contextAttributes, @Nullable AffineTransform rootTransform, EstablishRootMeasure establishRootMeasure) {
        if (context == null && viewBox == null && attributeFontSpec == null && frc == null) {
            return this;
        }
        PaintContext newPaintContext = this.paintContext;
        MeasurableFontSpec newFontSpec = this.fontSpec;
        if (context != null) {
            newPaintContext = context.mutate(this.paintContext);
        }
        if (attributeFontSpec != null) {
            newFontSpec = attributeFontSpec.mutate(newFontSpec);
        }
        ContextElementAttributes newContextAttributes = this.contextElementAttributes;
        if (contextAttributes != null) {
            newContextAttributes = contextAttributes;
        }
        float em = newFontSpec.effectiveSize(this.measureContext);
        float ex = SVGFont.exFromEm(em);
        MeasureContext newMeasureContext = this.measureContext.derive(viewBox, em, ex);
        if (establishRootMeasure == EstablishRootMeasure.Yes) {
            newMeasureContext = newMeasureContext.deriveRoot(em);
        }
        FontRenderContext effectiveFrc = this.fontRenderContext.derive(frc);
        AffineTransform newRootTransform = rootTransform != null ? rootTransform : this.rootTransform;
        return new RenderContext(this.awtSupport, newRootTransform, new AffineTransform(this.userSpaceTransform), newPaintContext, newMeasureContext, effectiveFrc, newFontSpec, newContextAttributes);
    }

    @NotNull
    public RenderContext deriveForChildGraphics() {
        return this.derive(t -> t, null, null, null, null, EstablishRootMeasure.No);
    }

    @NotNull
    public RenderContext deriveForSurface() {
        return this.deriveImpl(t -> t, null, null, null, null, new AffineTransform(this.rootTransform), EstablishRootMeasure.No);
    }

    @NotNull
    public StrokeContext strokeContext() {
        assert (this.paintContext.strokeContext != null);
        return this.paintContext.strokeContext;
    }

    @Nullable
    ContextElementAttributes contextElementAttributes() {
        return this.contextElementAttributes;
    }

    @NotNull
    public AffineTransform rootTransform() {
        return this.rootTransform;
    }

    @NotNull
    public AffineTransform userSpaceTransform() {
        return this.userSpaceTransform;
    }

    public void setRootTransform(@NotNull AffineTransform rootTransform) {
        this.rootTransform.setTransform(rootTransform);
        this.userSpaceTransform.setToIdentity();
    }

    public void setRootTransform(@NotNull AffineTransform rootTransform, @NotNull AffineTransform userSpaceTransform) {
        this.rootTransform.setTransform(rootTransform);
        this.userSpaceTransform.setTransform(userSpaceTransform);
    }

    public void translate(@NotNull Output output, @NotNull Point2D dp) {
        this.translate(output, dp.getX(), dp.getY());
    }

    public void translate(@NotNull Output output, double dx, double dy) {
        output.translate(dx, dy);
        this.userSpaceTransform.translate(dx, dy);
    }

    public void scale(@NotNull Output output, double sx, double sy) {
        output.scale(sx, sy);
        this.userSpaceTransform.scale(sx, sy);
    }

    public void rotate(@NotNull Output output, double angle) {
        output.rotate(angle);
        this.userSpaceTransform.rotate(angle);
    }

    public void transform(@NotNull Output output, @NotNull AffineTransform at) {
        output.applyTransform(at);
        this.userSpaceTransform.concatenate(at);
    }

    @NotNull
    public PlatformSupport platformSupport() {
        return this.awtSupport;
    }

    @NotNull
    public MeasureContext measureContext() {
        return this.measureContext;
    }

    @NotNull
    public FontRenderContext fontRenderContext() {
        return this.fontRenderContext;
    }

    @NotNull
    public FillRule fillRule() {
        FillRule fillRule = this.paintContext.fillRule;
        return fillRule != null ? fillRule : FillRule.Nonzero;
    }

    @NotNull
    public SVGPaint strokePaint() {
        return this.resolvePaint(this.paintContext.strokePaint);
    }

    @NotNull
    public SVGPaint fillPaint() {
        return this.resolvePaint(this.paintContext.fillPaint);
    }

    @NotNull
    public PaintOrder paintOrder() {
        PaintOrder paintOrder = this.paintContext.paintOrder;
        return paintOrder != null ? paintOrder : PaintOrder.NORMAL;
    }

    @NotNull
    private SVGPaint resolvePaint(@Nullable SVGPaint p) {
        if (p == PredefinedPaints.DEFAULT_PAINT || p == PredefinedPaints.CURRENT_COLOR) {
            return this.coerceNonNull(this.paintContext.color);
        }
        if (p == PredefinedPaints.CONTEXT_STROKE) {
            if (this.contextElementAttributes == null) {
                return PredefinedPaints.NONE;
            }
            return this.contextElementAttributes.strokePaint;
        }
        if (p == PredefinedPaints.CONTEXT_FILL) {
            if (this.contextElementAttributes == null) {
                return PredefinedPaints.NONE;
            }
            return this.contextElementAttributes.fillPaint;
        }
        return this.coerceNonNull(p);
    }

    @NotNull
    private SVGPaint coerceNonNull(@Nullable SVGPaint p) {
        return p != null ? p : PredefinedPaints.DEFAULT_PAINT;
    }

    public float rawOpacity() {
        return this.paintContext.opacity.get(this.measureContext);
    }

    public float fillOpacity() {
        assert (this.paintContext.fillOpacity != null);
        return this.paintContext.fillOpacity.get(this.measureContext) * this.paintContext.opacity.get(this.measureContext);
    }

    public float strokeOpacity() {
        assert (this.paintContext.strokeOpacity != null);
        return this.paintContext.strokeOpacity.get(this.measureContext) * this.paintContext.opacity.get(this.measureContext);
    }

    @NotNull
    public Stroke stroke(float pathLengthFactor) {
        return StrokeResolver.resolve(pathLengthFactor, this.measureContext, this.strokeContext());
    }

    @NotNull
    public SVGFont font() {
        return FontResolver.resolve(this.fontSpec, this.measureContext);
    }

    public String toString() {
        return "RenderContext{\n  measureContext=" + this.measureContext + ",\n paintContext=" + this.paintContext + ",\n fontSpec=" + this.fontSpec + ",\n awtSupport=" + this.awtSupport + ",\n contextElementAttributes=" + this.contextElementAttributes + ",\n baseTransform=" + this.rootTransform + ",\n userSpaceTransform=" + this.userSpaceTransform + "\n}";
    }

    public static enum EstablishRootMeasure {
        Yes,
        No;

    }
}

