/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.userstorage.tests;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.userstorage.IBlob;
import org.eclipse.userstorage.IStorage;
import org.eclipse.userstorage.StorageFactory;
import org.eclipse.userstorage.internal.Session;
import org.eclipse.userstorage.internal.Storage;
import org.eclipse.userstorage.internal.StorageService;
import org.eclipse.userstorage.internal.StorageServiceRegistry;
import org.eclipse.userstorage.internal.util.IOUtil;
import org.eclipse.userstorage.spi.Credentials;
import org.eclipse.userstorage.spi.ICredentialsProvider;
import org.eclipse.userstorage.spi.StorageCache;
import org.eclipse.userstorage.tests.AbstractTest;
import org.eclipse.userstorage.tests.util.ClientFixture;
import org.eclipse.userstorage.tests.util.FixedCredentialsProvider;
import org.eclipse.userstorage.tests.util.ServerFixture;
import org.eclipse.userstorage.tests.util.USSServer;
import org.eclipse.userstorage.util.BadApplicationTokenException;
import org.eclipse.userstorage.util.BadKeyException;
import org.eclipse.userstorage.util.ConflictException;
import org.eclipse.userstorage.util.NotFoundException;
import org.eclipse.userstorage.util.ProtocolException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public final class StorageTests
extends AbstractTest {
    public static final String APPLICATION_TOKEN = "pDKTqBfDuNxlAKydhEwxBZPxa4q";
    private static final String KEY = "test_blob";
    private static final String WRONG_ETAG = "wrong_etag";
    private ServerFixture serverFixture;
    private ClientFixture clientFixture;
    private StorageFactory factory;
    private ClientFixture.TestCache cache;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        StorageServiceRegistry.INSTANCE.stop();
        StorageServiceRegistry.INSTANCE.start();
        this.serverFixture = new ServerFixture(APPLICATION_TOKEN);
        this.clientFixture = new ClientFixture(this.serverFixture);
        this.factory = this.clientFixture.getFactory();
        this.cache = this.clientFixture.getCache();
    }

    @Override
    public void tearDown() throws Exception {
        if (this.clientFixture != null) {
            this.clientFixture.dispose();
            this.clientFixture = null;
        }
        if (this.serverFixture != null) {
            this.serverFixture.dispose();
            this.serverFixture = null;
        }
        super.tearDown();
    }

    @Test
    public void testApplicationToken() throws Exception {
        try {
            this.factory.create(null);
            StorageTests.fail("BadApplicationTokenException expected");
        }
        catch (BadApplicationTokenException badApplicationTokenException) {}
        try {
            this.factory.create("aaaa");
            StorageTests.fail("BadApplicationTokenException expected");
        }
        catch (BadApplicationTokenException badApplicationTokenException) {}
        try {
            this.factory.create("aaaaaaaaaaaaaaaaaaaaaaaaaaaa");
            StorageTests.fail("BadApplicationTokenException expected");
        }
        catch (BadApplicationTokenException badApplicationTokenException) {}
        try {
            this.factory.create("1aaaaaaaaa");
            StorageTests.fail("BadApplicationTokenException expected");
        }
        catch (BadApplicationTokenException badApplicationTokenException) {}
        this.factory.create("aaaaa");
        this.factory.create("aaaaaaaaaaaaaaaaaaaaaaaaaaa");
    }

    @Test
    public void testKey() throws Exception {
        IStorage storage = this.factory.create(APPLICATION_TOKEN);
        try {
            storage.getBlob(null);
            StorageTests.fail("BadKeyException expected");
        }
        catch (BadKeyException badKeyException) {}
        try {
            storage.getBlob("aaaa");
            StorageTests.fail("BadKeyException expected");
        }
        catch (BadKeyException badKeyException) {}
        try {
            storage.getBlob("aaaaaaaaaaaaaaaaaaaaaaaaaaa");
            StorageTests.fail("BadKeyException expected");
        }
        catch (BadKeyException badKeyException) {}
        try {
            storage.getBlob("1aaaaaaaaa");
            StorageTests.fail("BadKeyException expected");
        }
        catch (BadKeyException badKeyException) {}
        storage.getBlob("aaaaa");
        storage.getBlob("aaaaaaaaaaaaaaaaaaaaaaaaa");
    }

    @Test
    public void testUserAgent() throws Exception {
        IStorage storage = this.factory.create(APPLICATION_TOKEN);
        System.setProperty(Session.USER_AGENT_PROPERTY, "malicious/client");
        try {
            try {
                IBlob blob = storage.getBlob("any_blob");
                blob.getContents();
                StorageTests.fail("ProtocolException expected");
            }
            catch (ProtocolException expected) {
                MatcherAssert.assertThat((Object)expected.getStatusCode(), (Matcher)StorageTests.is((Object)403));
                System.clearProperty(Session.USER_AGENT_PROPERTY);
            }
        }
        finally {
            System.clearProperty(Session.USER_AGENT_PROPERTY);
        }
    }

    @Test
    public void testCreate() throws Exception {
        IStorage storage = this.factory.create(APPLICATION_TOKEN);
        IBlob blob = storage.getBlob(KEY);
        String value = "A short UTF-8 string value";
        MatcherAssert.assertThat((Object)blob.setContentsUTF(value), (Matcher)StorageTests.is((Object)true));
        ServerFixture.BlobInfo blobInfo = this.serverFixture.readServer(blob);
        MatcherAssert.assertThat((Object)blobInfo.contents, (Matcher)StorageTests.is((Object)value));
        MatcherAssert.assertThat((Object)blobInfo.eTag, (Matcher)StorageTests.is((Object)blob.getETag()));
    }

    @Test
    public void testCreateWithWrongETag() throws Exception {
        IStorage storage = this.factory.create(APPLICATION_TOKEN);
        IBlob blob = storage.getBlob(KEY);
        blob.setETag(WRONG_ETAG);
        blob.setContentsUTF("Text 2");
        MatcherAssert.assertThat((Object)blob.getETag(), StorageTests.isNotNull());
    }

    @Test
    public void testCreateAfterRetrieve() throws Exception {
        IStorage storage = this.factory.create(APPLICATION_TOKEN);
        IBlob blob = storage.getBlob(KEY);
        try {
            blob.getContentsUTF();
            StorageTests.fail("NotFoundException expected");
        }
        catch (NotFoundException notFoundException) {}
        String value = "A short UTF-8 string value";
        blob.setContentsUTF(value);
        ServerFixture.BlobInfo blobInfo = this.serverFixture.readServer(blob);
        MatcherAssert.assertThat((Object)blobInfo.contents, (Matcher)StorageTests.is((Object)value));
        MatcherAssert.assertThat((Object)blobInfo.eTag, (Matcher)StorageTests.is((Object)blob.getETag()));
        MatcherAssert.assertThat((Object)blobInfo.eTag, (Matcher)StorageTests.is((Matcher)StorageTests.not((Object)"not_found")));
    }

    @Test
    public void testCreateWithCache() throws Exception {
        IStorage storage = this.factory.create(APPLICATION_TOKEN, (StorageCache)this.cache);
        IBlob blob = storage.getBlob(KEY);
        String value = "A short UTF-8 string value";
        MatcherAssert.assertThat((Object)blob.setContentsUTF(value), (Matcher)StorageTests.is((Object)true));
        MatcherAssert.assertThat((Object)this.clientFixture.readCache(blob.getKey(), null), (Matcher)StorageTests.is((Object)value));
        MatcherAssert.assertThat((Object)this.clientFixture.readCache(blob.getKey(), ".properties"), (Matcher)StorageTests.containsString((String)("etag=" + blob.getETag())));
    }

    @Test
    public void testUpdateReinitializesCache() throws Exception {
        IStorage storage = this.factory.create(APPLICATION_TOKEN, (StorageCache)this.cache);
        IBlob blob = storage.getBlob(KEY);
        String value = "A short UTF-8 string value";
        MatcherAssert.assertThat((Object)blob.setContentsUTF(value), (Matcher)StorageTests.is((Object)true));
        String prevETag = blob.getETag();
        MatcherAssert.assertThat((Object)blob.setContentsUTF(""), (Matcher)StorageTests.is((Object)false));
        MatcherAssert.assertThat((String)"ETag not updated", (Object)blob.getETag(), (Matcher)StorageTests.not((Object)prevETag));
        MatcherAssert.assertThat((String)"Cache contents not updated", (Object)blob.getContentsUTF(), (Matcher)StorageTests.is((Object)""));
    }

    @Test
    public void testCreateAndUpdate() throws Exception {
        IStorage storage = this.factory.create(APPLICATION_TOKEN);
        IBlob blob = storage.getBlob(KEY);
        blob.setContentsUTF("Text 1");
        blob.setContentsUTF("Text 2");
        blob.setContentsUTF("Text 3");
        MatcherAssert.assertThat((Object)blob.getContentsUTF(), (Matcher)StorageTests.is((Object)"Text 3"));
    }

    @Test
    public void testUpdateWithWrongETag() throws Exception {
        IStorage storage = this.factory.create(APPLICATION_TOKEN);
        IBlob blob = storage.getBlob(KEY);
        blob.setContentsUTF("Text 1");
        blob.setETag(WRONG_ETAG);
        try {
            blob.setContentsUTF("Text 2");
            StorageTests.fail("ConflictException expected");
        }
        catch (ConflictException expected) {
            MatcherAssert.assertThat((Object)expected.getETag(), StorageTests.isNotNull());
            MatcherAssert.assertThat((Object)blob.getETag(), StorageTests.isNull());
        }
    }

    @Test
    public void testUpdateFailEarly() throws Exception {
        IStorage storage = this.factory.create(APPLICATION_TOKEN);
        IBlob blob = storage.getBlob(KEY);
        String value1 = "A short UTF-8 string value";
        MatcherAssert.assertThat((Object)blob.setContentsUTF(value1), (Matcher)StorageTests.is((Object)true));
        File tempFile = File.createTempFile("test-", ".txt");
        IOUtil.writeUTF((File)tempFile, (String)"Another string value");
        FileInputStream in = null;
        try {
            block9: {
                Credentials credentials = new Credentials("abc", "wrong");
                Credentials oldCredentials = FixedCredentialsProvider.setCredentials(credentials);
                try {
                    try {
                        ((StorageService)storage.getService()).setCredentials(credentials);
                        ((Storage)storage).getSession().reset();
                        in = new FileInputStream(tempFile);
                        blob.setContents((InputStream)in);
                        StorageTests.fail("ProtocolException: HTTP/1.1 401 Unauthorized expected");
                    }
                    catch (ProtocolException expected) {
                        MatcherAssert.assertThat((Object)expected.getStatusCode(), (Matcher)StorageTests.is((Object)401));
                        FixedCredentialsProvider.setCredentials(oldCredentials);
                        break block9;
                    }
                }
                catch (Throwable throwable) {
                    FixedCredentialsProvider.setCredentials(oldCredentials);
                    throw throwable;
                }
                FixedCredentialsProvider.setCredentials(oldCredentials);
            }
            MatcherAssert.assertThat((Object)tempFile.delete(), (Matcher)StorageTests.is((Object)true));
        }
        catch (Throwable throwable) {
            IOUtil.closeSilent(in);
            if (!tempFile.delete()) {
                tempFile.deleteOnExit();
            }
            throw throwable;
        }
        IOUtil.closeSilent((Closeable)in);
        if (!tempFile.delete()) {
            tempFile.deleteOnExit();
        }
    }

    @Test
    public void testRetrieveNotExistent() throws Exception {
        IStorage storage = this.factory.create(APPLICATION_TOKEN);
        IBlob blob = storage.getBlob("aaaaaaaaaa");
        blob.setETag(WRONG_ETAG);
        try {
            blob.getContents();
            StorageTests.fail("NotFoundException expected");
        }
        catch (NotFoundException notFoundException) {}
        MatcherAssert.assertThat((Object)blob.getETag(), StorageTests.isNull());
    }

    @Test
    public void testRetrieve() throws Exception {
        IStorage storage = this.factory.create(APPLICATION_TOKEN);
        IBlob blob = storage.getBlob(KEY);
        String value = "A short UTF-8 string value";
        blob.setContentsUTF(value);
        MatcherAssert.assertThat((Object)blob.getContentsUTF(), (Matcher)StorageTests.is((Object)value));
        ServerFixture.BlobInfo blobInfo = this.serverFixture.readServer(blob);
        MatcherAssert.assertThat((Object)blobInfo.contents, (Matcher)StorageTests.is((Object)value));
        MatcherAssert.assertThat((Object)blobInfo.eTag, (Matcher)StorageTests.is((Object)blob.getETag()));
    }

    @Test
    public void testRetrieveWithCache() throws Exception {
        IStorage storage = this.factory.create(APPLICATION_TOKEN, (StorageCache)this.cache);
        IBlob blob = storage.getBlob(KEY);
        String value = "A short UTF-8 string value";
        blob.setContentsUTF(value);
        MatcherAssert.assertThat((Object)blob.getContentsUTF(), (Matcher)StorageTests.is((Object)value));
        MatcherAssert.assertThat((Object)this.clientFixture.readCache(blob.getKey(), null), (Matcher)StorageTests.is((Object)value));
        MatcherAssert.assertThat((Object)this.clientFixture.readCache(blob.getKey(), ".properties"), (Matcher)StorageTests.containsString((String)("etag=" + blob.getETag())));
        InputStream contents = blob.getContents();
        MatcherAssert.assertThat((Object)contents, (Matcher)StorageTests.instanceOf(FileInputStream.class));
        IOUtil.copy((InputStream)contents, (OutputStream)new ByteArrayOutputStream());
        MatcherAssert.assertThat((Object)this.clientFixture.readCache(blob.getKey(), null), (Matcher)StorageTests.is((Object)value));
        MatcherAssert.assertThat((Object)this.clientFixture.readCache(blob.getKey(), ".properties"), (Matcher)StorageTests.containsString((String)("etag=" + blob.getETag())));
    }

    @Test
    public void testRetrieveMulti() throws Exception {
        IStorage storage = this.factory.create(APPLICATION_TOKEN);
        IBlob blob = storage.getBlob(KEY);
        blob.setContentsUTF("A short UTF-8 string value");
        blob.getContents();
        blob.getContents();
        blob.getContents();
        blob.getContents();
        blob.getContents();
    }

    @Test
    public void testRetrieveKeys() throws Exception {
        IStorage storage = this.factory.create(APPLICATION_TOKEN);
        storage.getBlob("anykey1").setContentsUTF("A short UTF-8 string value");
        storage.getBlob("anykey2").setContentsUTF("A short UTF-8 string value");
        storage.getBlob("anykey3").setContentsUTF("A short UTF-8 string value");
        storage.getBlob("anykey4").setContentsUTF("A short UTF-8 string value");
        HashSet<String> keys = new HashSet<String>();
        for (IBlob blob : storage.getBlobs()) {
            System.out.println(blob);
            keys.add(blob.getKey());
        }
        MatcherAssert.assertThat((Object)keys.contains("anykey1"), (Matcher)StorageTests.is((Object)true));
        MatcherAssert.assertThat((Object)keys.contains("anykey2"), (Matcher)StorageTests.is((Object)true));
        MatcherAssert.assertThat((Object)keys.contains("anykey3"), (Matcher)StorageTests.is((Object)true));
        MatcherAssert.assertThat((Object)keys.contains("anykey4"), (Matcher)StorageTests.is((Object)true));
    }

    @Test
    public void testConflict() throws Exception {
        IStorage storage = this.factory.create(APPLICATION_TOKEN);
        IBlob blob = storage.getBlob(KEY);
        String value1 = "A short UTF-8 string value";
        blob.setContentsUTF(value1);
        String value2 = "Different content";
        String eTag2 = this.serverFixture.writeServer(blob, value2);
        String value3 = "And now a conflicting string";
        try {
            blob.setContentsUTF(value3);
            StorageTests.fail("ConflictException expected");
        }
        catch (ConflictException expected) {
            MatcherAssert.assertThat((Object)expected.getETag(), StorageTests.isNotNull());
            MatcherAssert.assertThat((Object)blob.getETag(), StorageTests.isNull());
        }
        ServerFixture.BlobInfo blobInfo = this.serverFixture.readServer(blob);
        MatcherAssert.assertThat((Object)blobInfo.contents, (Matcher)StorageTests.is((Object)value2));
        MatcherAssert.assertThat((Object)blobInfo.eTag, (Matcher)StorageTests.is((Object)eTag2));
    }

    @Test
    public void testConflictWithCache() throws Exception {
        IStorage storage = this.factory.create(APPLICATION_TOKEN, (StorageCache)this.cache);
        IBlob blob = storage.getBlob(KEY);
        String value1 = "A short UTF-8 string value";
        blob.setContentsUTF(value1);
        this.serverFixture.writeServer(blob, "Different content");
        String value3 = "And now a conflicting string";
        try {
            blob.setContentsUTF(value3);
            StorageTests.fail("ConflictException expected");
        }
        catch (ConflictException expected) {
            MatcherAssert.assertThat((Object)expected.getETag(), StorageTests.isNotNull());
            MatcherAssert.assertThat((Object)blob.getETag(), StorageTests.isNull());
        }
        try {
            this.clientFixture.readCache(blob.getKey(), null);
            StorageTests.fail("FileNotFoundException expected");
        }
        catch (FileNotFoundException fileNotFoundException) {}
        try {
            this.clientFixture.readCache(blob.getKey(), ".properties");
            StorageTests.fail("FileNotFoundException expected");
        }
        catch (FileNotFoundException fileNotFoundException) {}
    }

    @Test
    public void testConflictResolution1() throws Exception {
        IStorage storage = this.factory.create(APPLICATION_TOKEN);
        IBlob blob = storage.getBlob(KEY);
        String value1 = "A short UTF-8 string value";
        blob.setContentsUTF(value1);
        String value2 = "Different content";
        String eTag2 = this.serverFixture.writeServer(blob, value2);
        MatcherAssert.assertThat((Object)blob.getContentsUTF(), (Matcher)StorageTests.is((Object)value2));
        MatcherAssert.assertThat((Object)blob.getETag(), (Matcher)StorageTests.is((Object)eTag2));
        String value3 = "And now a non-conflicting string";
        blob.setContentsUTF(value3);
        ServerFixture.BlobInfo blobInfo = this.serverFixture.readServer(blob);
        MatcherAssert.assertThat((Object)blobInfo.contents, (Matcher)StorageTests.is((Object)value3));
        MatcherAssert.assertThat((Object)blobInfo.eTag, (Matcher)StorageTests.is((Object)blob.getETag()));
    }

    @Test
    public void testConflictResolution1WithCache() throws Exception {
        IStorage storage = this.factory.create(APPLICATION_TOKEN, (StorageCache)this.cache);
        IBlob blob = storage.getBlob(KEY);
        String value1 = "A short UTF-8 string value";
        blob.setContentsUTF(value1);
        String value2 = "Different content";
        String eTag2 = this.serverFixture.writeServer(blob, value2);
        MatcherAssert.assertThat((Object)blob.getContentsUTF(), (Matcher)StorageTests.is((Object)value2));
        MatcherAssert.assertThat((Object)blob.getETag(), (Matcher)StorageTests.is((Object)eTag2));
        String value3 = "And now a non-conflicting string";
        blob.setContentsUTF(value3);
        MatcherAssert.assertThat((Object)this.clientFixture.readCache(blob.getKey(), null), (Matcher)StorageTests.is((Object)value3));
        MatcherAssert.assertThat((Object)this.clientFixture.readCache(blob.getKey(), ".properties"), (Matcher)StorageTests.containsString((String)("etag=" + blob.getETag())));
    }

    @Test
    public void testConflictResolution2() throws Exception {
        IStorage storage = this.factory.create(APPLICATION_TOKEN);
        IBlob blob = storage.getBlob(KEY);
        String value1 = "A short UTF-8 string value";
        blob.setContentsUTF(value1);
        String value2 = "Different content";
        String eTag2 = this.serverFixture.writeServer(blob, value2);
        String value3 = "And now a conflicting string";
        try {
            blob.setContentsUTF(value3);
            StorageTests.fail("ConflictException expected");
        }
        catch (ConflictException expected) {
            MatcherAssert.assertThat((Object)expected.getETag(), StorageTests.isNotNull());
            MatcherAssert.assertThat((Object)blob.getETag(), StorageTests.isNull());
            blob.setETag(eTag2);
        }
        blob.setContentsUTF(value3);
        ServerFixture.BlobInfo blobInfo = this.serverFixture.readServer(blob);
        MatcherAssert.assertThat((Object)blobInfo.contents, (Matcher)StorageTests.is((Object)value3));
        MatcherAssert.assertThat((Object)blobInfo.eTag, (Matcher)StorageTests.is((Object)blob.getETag()));
    }

    @Test
    public void testConflictResolution2WithCache() throws Exception {
        IStorage storage = this.factory.create(APPLICATION_TOKEN, (StorageCache)this.cache);
        IBlob blob = storage.getBlob(KEY);
        String value1 = "A short UTF-8 string value";
        blob.setContentsUTF(value1);
        String value2 = "Different content";
        String eTag2 = this.serverFixture.writeServer(blob, value2);
        String value3 = "And now a conflicting string";
        try {
            blob.setContentsUTF(value3);
            StorageTests.fail("ConflictException expected");
        }
        catch (ConflictException expected) {
            MatcherAssert.assertThat((Object)expected.getETag(), StorageTests.isNotNull());
            MatcherAssert.assertThat((Object)blob.getETag(), StorageTests.isNull());
            blob.setETag(eTag2);
        }
        try {
            this.clientFixture.readCache(blob.getKey(), null);
            StorageTests.fail("FileNotFoundException expected");
        }
        catch (FileNotFoundException fileNotFoundException) {}
        try {
            this.clientFixture.readCache(blob.getKey(), ".properties");
            StorageTests.fail("FileNotFoundException expected");
        }
        catch (FileNotFoundException fileNotFoundException) {}
        blob.setContentsUTF(value3);
        MatcherAssert.assertThat((Object)this.clientFixture.readCache(blob.getKey(), null), (Matcher)StorageTests.is((Object)value3));
        MatcherAssert.assertThat((Object)this.clientFixture.readCache(blob.getKey(), ".properties"), (Matcher)StorageTests.containsString((String)("etag=" + blob.getETag())));
    }

    @Test
    public void testAuthenticateFailure() throws Exception {
        IStorage storage = this.factory.create(APPLICATION_TOKEN);
        IBlob blob = storage.getBlob(KEY);
        Credentials credentials = new Credentials("abcd", "wrong123");
        Credentials oldCredentials = FixedCredentialsProvider.setCredentials(credentials);
        try {
            try {
                ((StorageService)storage.getService()).setCredentials(credentials);
                ((Storage)storage).getSession().reset();
                String value1 = "A short UTF-8 string value";
                MatcherAssert.assertThat((Object)blob.setContentsUTF(value1), (Matcher)StorageTests.is((Object)true));
                StorageTests.fail("ProtocolException: HTTP/1.1 401 Unauthorized expected");
            }
            catch (ProtocolException expected) {
                MatcherAssert.assertThat((Object)expected.getStatusCode(), (Matcher)StorageTests.is((Object)401));
                FixedCredentialsProvider.setCredentials(oldCredentials);
            }
        }
        finally {
            FixedCredentialsProvider.setCredentials(oldCredentials);
        }
    }

    @Test
    public void testReauthenticate() throws Exception {
        IStorage storage = this.factory.create(APPLICATION_TOKEN);
        IBlob blob = storage.getBlob(KEY);
        String value = "A short UTF-8 string value";
        blob.setContentsUTF(value);
        if (this.serverFixture.hasLocalServer()) {
            Map<String, USSServer.Session> sessions = this.serverFixture.getServer().getSessions();
            MatcherAssert.assertThat((Object)sessions.size(), (Matcher)StorageTests.is((Object)1));
            sessions.clear();
        }
        MatcherAssert.assertThat((Object)blob.getContentsUTF(), (Matcher)StorageTests.is((Object)value));
        ServerFixture.BlobInfo blobInfo = this.serverFixture.readServer(blob);
        MatcherAssert.assertThat((Object)blobInfo.contents, (Matcher)StorageTests.is((Object)value));
        MatcherAssert.assertThat((Object)blobInfo.eTag, (Matcher)StorageTests.is((Object)blob.getETag()));
        if (this.serverFixture.hasLocalServer()) {
            Map<String, USSServer.Session> sessions = this.serverFixture.getServer().getSessions();
            MatcherAssert.assertThat((Object)sessions.size(), (Matcher)StorageTests.is((Object)1));
        }
    }

    @Test
    public void testDelete() throws Exception {
        IStorage storage = this.factory.create(APPLICATION_TOKEN);
        IBlob blob = storage.getBlob(KEY);
        String value = "A short UTF-8 string value";
        blob.setContentsUTF(value);
        MatcherAssert.assertThat((Object)blob.getContentsUTF(), (Matcher)StorageTests.is((Object)value));
        blob.delete();
        ServerFixture.BlobInfo blobInfo = this.serverFixture.readServer(blob);
        MatcherAssert.assertThat((Object)blobInfo, StorageTests.isNull());
        try {
            blob.getContentsUTF();
            StorageTests.fail("NotFoundException expected");
        }
        catch (NotFoundException notFoundException) {}
    }

    @Test
    public void testDeleteWithoutETag() throws Exception {
        IStorage storage = this.factory.create(APPLICATION_TOKEN);
        IBlob blob = storage.getBlob(KEY);
        String value = "A short UTF-8 string value";
        blob.setContentsUTF(value);
        MatcherAssert.assertThat((Object)blob.getContentsUTF(), (Matcher)StorageTests.is((Object)value));
        blob.setETag(null);
        blob.delete();
        ServerFixture.BlobInfo blobInfo = this.serverFixture.readServer(blob);
        MatcherAssert.assertThat((Object)blobInfo, StorageTests.isNull());
        try {
            blob.getContentsUTF();
            StorageTests.fail("NotFoundException expected");
        }
        catch (NotFoundException notFoundException) {}
    }

    @Test
    public void testDeleteWithCache() throws Exception {
        IStorage storage = this.factory.create(APPLICATION_TOKEN, (StorageCache)this.cache);
        IBlob blob = storage.getBlob(KEY);
        String value = "A short UTF-8 string value";
        blob.setContentsUTF(value);
        MatcherAssert.assertThat((Object)blob.getContentsUTF(), (Matcher)StorageTests.is((Object)value));
        blob.delete();
        try {
            this.clientFixture.readCache(blob.getKey(), null);
            StorageTests.fail("FileNotFoundException expected");
        }
        catch (FileNotFoundException fileNotFoundException) {}
        try {
            this.clientFixture.readCache(blob.getKey(), ".properties");
            StorageTests.fail("FileNotFoundException expected");
        }
        catch (FileNotFoundException fileNotFoundException) {}
    }

    @Test
    public void testDeleteAll() throws Exception {
        IStorage storage = this.factory.create(APPLICATION_TOKEN);
        MatcherAssert.assertThat((Object)storage.getBlob(KEY).setContentsUTF("A short UTF-8 string value"), (Matcher)StorageTests.is((Object)true));
        boolean deleted = storage.deleteAllBlobs();
        MatcherAssert.assertThat((Object)deleted, (Matcher)StorageTests.is((Object)true));
        MatcherAssert.assertThat((Object)storage.getBlobs().iterator().hasNext(), (Matcher)StorageTests.is((Object)false));
    }

    @Test
    public void testDeleteNotExistent() throws Exception {
        IStorage storage = this.factory.create(APPLICATION_TOKEN);
        IBlob blob = storage.getBlob(KEY);
        boolean deleted = blob.delete();
        MatcherAssert.assertThat((Object)deleted, (Matcher)StorageTests.is((Object)false));
    }

    @Test
    public void testDeleteNotExistentWithWrongETag() throws Exception {
        IStorage storage = this.factory.create(APPLICATION_TOKEN);
        IBlob blob = storage.getBlob(KEY);
        blob.setETag(WRONG_ETAG);
        boolean deleted = blob.delete();
        MatcherAssert.assertThat((Object)deleted, (Matcher)StorageTests.is((Object)false));
    }

    @Test
    public void testConnectedness() {
        Credentials oldCredentials = FixedCredentialsProvider.setCredentials(null);
        IStorage storage = this.factory.create(APPLICATION_TOKEN);
        try {
            storage.setCredentialsProvider((ICredentialsProvider)new FixedCredentialsProvider());
            Assert.assertEquals((Object)IStorage.Connectedness.UNAUTHORIZED, (Object)storage.getConnectedness());
            FixedCredentialsProvider.setCredentials(new Credentials());
            Assert.assertEquals((Object)IStorage.Connectedness.AUTHORIZED, (Object)storage.getConnectedness());
            ((Storage)storage).getSession();
            Assert.assertEquals((Object)IStorage.Connectedness.CONNECTED, (Object)storage.getConnectedness());
        }
        finally {
            FixedCredentialsProvider.setCredentials(oldCredentials);
            ((Storage)storage).close();
        }
    }
}

