/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.dns.impl.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import org.vertx.java.core.dns.impl.netty.DnsMessage;
import org.vertx.java.core.dns.impl.netty.DnsResponseDecoder;
import org.vertx.java.core.dns.impl.netty.DnsResponseHeader;

public class DnsResponse
extends DnsMessage<DnsResponseHeader>
implements ByteBufHolder {
    private final ByteBuf rawPacket;
    private final int originalIndex;

    public DnsResponse(ByteBuf rawPacket) {
        this.rawPacket = rawPacket;
        this.originalIndex = rawPacket.readerIndex();
    }

    public ByteBuf content() {
        return this.rawPacket;
    }

    public int refCnt() {
        return this.rawPacket.refCnt();
    }

    public boolean release() {
        return this.rawPacket.release();
    }

    public DnsResponse copy() {
        return DnsResponseDecoder.decodeResponse(this.rawPacket.copy(), this.rawPacket.alloc());
    }

    public ByteBufHolder duplicate() {
        return DnsResponseDecoder.decodeResponse(this.rawPacket.duplicate(), this.rawPacket.alloc());
    }

    public DnsResponse retain() {
        this.rawPacket.retain();
        return this;
    }

    public DnsResponse retain(int increment) {
        this.rawPacket.retain(increment);
        return this;
    }

    public boolean release(int decrement) {
        return this.rawPacket.release(decrement);
    }

    public int originalIndex() {
        return this.originalIndex;
    }
}

