/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.impl;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.vertx.java.core.impl.VertxThreadFactory;
import org.vertx.java.core.impl.management.ManagementRegistry;

public class VertxExecutorFactory {
    public static final int WORKER_POOL_MAX_SIZE = 20;

    public static ExecutorService workerPool(String poolName) {
        int maxSize = Integer.getInteger("vertx.pool.worker.size", 20);
        ExecutorService exec = Executors.newFixedThreadPool(maxSize, new VertxThreadFactory(poolName));
        ManagementRegistry.registerThreadPool("Worker", exec);
        return exec;
    }

    public static EventLoopGroup eventLoopGroup(String poolName) {
        return new NioEventLoopGroup(VertxExecutorFactory.eventLoopSize(), (ThreadFactory)new VertxThreadFactory(poolName));
    }

    public static int eventLoopSize() {
        return Integer.getInteger("vertx.pool.eventloop.size", 2 * Runtime.getRuntime().availableProcessors());
    }
}

