/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.spi.cluster.impl.hazelcast;

import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.MultiMap;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.AsyncResultHandler;
import org.vertx.java.core.Handler;
import org.vertx.java.core.impl.DefaultFutureResult;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;
import org.vertx.java.core.spi.Action;
import org.vertx.java.core.spi.VertxSPI;
import org.vertx.java.core.spi.cluster.AsyncMultiMap;
import org.vertx.java.core.spi.cluster.ChoosableIterable;
import org.vertx.java.spi.cluster.impl.hazelcast.ChoosableSet;
import org.vertx.java.spi.cluster.impl.hazelcast.HazelcastServerID;

class HazelcastAsyncMultiMap<K, V>
implements AsyncMultiMap<K, V>,
EntryListener<K, V> {
    private static final Logger log = LoggerFactory.getLogger(HazelcastAsyncMultiMap.class);
    private final VertxSPI vertx;
    private final MultiMap<K, V> map;
    private ConcurrentMap<K, ChoosableSet<V>> cache = new ConcurrentHashMap<K, ChoosableSet<V>>();

    public HazelcastAsyncMultiMap(VertxSPI vertx, MultiMap<K, V> map) {
        this.vertx = vertx;
        this.map = map;
        map.addEntryListener((EntryListener)this, true);
    }

    public void removeAllForValue(final V val, Handler<AsyncResult<Void>> completionHandler) {
        this.vertx.executeBlocking((Action)new Action<Void>(){

            public Void perform() {
                for (Map.Entry entry : HazelcastAsyncMultiMap.this.map.entrySet()) {
                    Object v = entry.getValue();
                    if (!val.equals(v)) continue;
                    HazelcastAsyncMultiMap.this.map.remove(entry.getKey(), v);
                }
                return null;
            }
        }, completionHandler);
    }

    public void add(final K k, final V v, Handler<AsyncResult<Void>> completionHandler) {
        this.vertx.executeBlocking((Action)new Action<Void>(){

            public Void perform() {
                HazelcastAsyncMultiMap.this.map.put(k, HazelcastServerID.convertServerID(v));
                return null;
            }
        }, completionHandler);
    }

    public void get(final K k, final Handler<AsyncResult<ChoosableIterable<V>>> resultHandler) {
        ChoosableSet entries = (ChoosableSet)this.cache.get(k);
        DefaultFutureResult result = new DefaultFutureResult();
        if (entries != null && entries.isInitialised()) {
            result.setResult((Object)entries).setHandler(resultHandler);
        } else {
            this.vertx.executeBlocking(new Action<Collection<V>>(){

                public Collection<V> perform() {
                    return HazelcastAsyncMultiMap.this.map.get(k);
                }
            }, (Handler)new AsyncResultHandler<Collection<V>>(){

                public void handle(AsyncResult<Collection<V>> result) {
                    DefaultFutureResult sresult = new DefaultFutureResult();
                    if (result.succeeded()) {
                        ChoosableSet prev;
                        ChoosableSet sids;
                        Collection entries = (Collection)result.result();
                        if (entries != null) {
                            sids = new ChoosableSet(entries.size());
                            for (Object hid : entries) {
                                sids.add(hid);
                            }
                        } else {
                            sids = new ChoosableSet(0);
                        }
                        if ((prev = HazelcastAsyncMultiMap.this.cache.putIfAbsent(k, sids)) != null) {
                            prev.merge(sids);
                            sids = prev;
                        }
                        sids.setInitialised();
                        sresult.setResult(sids);
                    } else {
                        sresult.setFailure(result.cause());
                    }
                    sresult.setHandler(resultHandler);
                }
            });
        }
    }

    public void remove(final K k, final V v, Handler<AsyncResult<Void>> completionHandler) {
        this.vertx.executeBlocking((Action)new Action<Void>(){

            public Void perform() {
                HazelcastAsyncMultiMap.this.map.remove(k, v);
                return null;
            }
        }, completionHandler);
    }

    public void entryAdded(EntryEvent<K, V> entry) {
        this.addEntry(entry.getKey(), entry.getValue());
    }

    private void addEntry(K k, V v) {
        ChoosableSet prev;
        ChoosableSet<V> entries = (ChoosableSet<V>)this.cache.get(k);
        if (entries == null && (prev = this.cache.putIfAbsent(k, entries = new ChoosableSet<V>(1))) != null) {
            entries = prev;
        }
        entries.add(v);
    }

    public void entryRemoved(EntryEvent<K, V> entry) {
        this.removeEntry(entry.getKey(), entry.getValue());
    }

    private void removeEntry(K k, V v) {
        ChoosableSet entries = (ChoosableSet)this.cache.get(k);
        if (entries != null) {
            entries.remove(v);
            if (entries.isEmpty()) {
                this.cache.remove(k);
            }
        }
    }

    public void entryUpdated(EntryEvent<K, V> entry) {
        Object k = entry.getKey();
        ChoosableSet entries = (ChoosableSet)this.cache.get(k);
        if (entries != null) {
            entries.add(entry.getValue());
        }
    }

    public void entryEvicted(EntryEvent<K, V> entry) {
        this.entryRemoved(entry);
    }
}

