/**
 * Copyright (c) 2010-2018, Zoltan Ujhelyi, Istvan Rath, Daniel Varro, IncQuery Labs Ltd.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-v20.html.
 *  * 
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.viatra.query.patternlanguage.emf.vql;

import org.eclipse.emf.common.util.EList;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Pattern Call</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.viatra.query.patternlanguage.emf.vql.PatternCall#getPatternRef <em>Pattern Ref</em>}</li>
 *   <li>{@link org.eclipse.viatra.query.patternlanguage.emf.vql.PatternCall#getParameters <em>Parameters</em>}</li>
 * </ul>
 *
 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.PatternLanguagePackage#getPatternCall()
 * @model
 * @generated
 */
public interface PatternCall extends CallableRelation
{
	/**
	 * Returns the value of the '<em><b>Pattern Ref</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Pattern Ref</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Pattern Ref</em>' reference.
	 * @see #setPatternRef(Pattern)
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.PatternLanguagePackage#getPatternCall_PatternRef()
	 * @model
	 * @generated
	 */
	Pattern getPatternRef();

	/**
	 * Sets the value of the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.PatternCall#getPatternRef <em>Pattern Ref</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Pattern Ref</em>' reference.
	 * @see #getPatternRef()
	 * @generated
	 */
	void setPatternRef(Pattern value);

	/**
	 * Returns the value of the '<em><b>Parameters</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.viatra.query.patternlanguage.emf.vql.ValueReference}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Parameters</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Parameters</em>' containment reference list.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.PatternLanguagePackage#getPatternCall_Parameters()
	 * @model containment="true"
	 * @generated
	 */
	EList<ValueReference> getParameters();

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model annotation="http://www.eclipse.org/emf/2002/GenModel body='return org.eclipse.viatra.query.patternlanguage.emf.util.ASTStringProvider.INSTANCE.doSwitch(this);'"
	 * @generated
	 */
	String toString();

} // PatternCall
