/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.deployer.core.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.virgo.nano.core.AbortableSignal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AbortableSignalJunction {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbortableSignalJunction.class);
    private final AbortableSignal signal;
    private final List<AbortableSignal> subSignals;
    private final AtomicInteger incompleteCount;
    private final AtomicBoolean failureSignalled = new AtomicBoolean(false);
    private final AtomicBoolean abortionSignalled = new AtomicBoolean(false);

    public AbortableSignalJunction(AbortableSignal signal, int size) {
        this.signal = signal;
        ArrayList<SubSignal> s = new ArrayList<SubSignal>();
        int i = 0;
        while (i < size) {
            s.add(new SubSignal());
            ++i;
        }
        this.subSignals = Collections.unmodifiableList(s);
        this.incompleteCount = new AtomicInteger(size);
        if (size <= 0 && this.signal != null) {
            this.signal.signalSuccessfulCompletion();
        }
    }

    public List<AbortableSignal> getSignals() {
        return this.subSignals;
    }

    public boolean failed() {
        return this.failureSignalled.get();
    }

    public boolean aborted() {
        return this.abortionSignalled.get();
    }

    private void subSignalFailed(Throwable cause) {
        int i = this.incompleteCount.get();
        LOGGER.debug("SubSignal failed. {} has {} incomplete signals", (Object)this, (Object)i);
        while (i > 0 && !this.incompleteCount.compareAndSet(i, 0)) {
            i = this.incompleteCount.get();
        }
        if (i > 0 && this.signal != null) {
            LOGGER.debug("{} signalling failure", (Object)this);
            this.signal.signalFailure(cause);
            this.failureSignalled.set(true);
        }
    }

    private void subSignalAborted() {
        int i = this.incompleteCount.get();
        LOGGER.debug("SubSignal aborted. {} has {} incomplete signals", (Object)this, (Object)i);
        while (i > 0 && !this.incompleteCount.compareAndSet(i, 0)) {
            i = this.incompleteCount.get();
        }
        if (i > 0 && this.signal != null) {
            LOGGER.debug("{} signalling aborted", (Object)this);
            this.signal.signalAborted();
            this.abortionSignalled.set(true);
        }
    }

    private void subSignalSucceeded() {
        int incomplete = this.incompleteCount.decrementAndGet();
        LOGGER.debug("SubSignal succeeded. {} now has {} incomplete signals", (Object)this, (Object)incomplete);
        if (incomplete == 0 && this.signal != null) {
            LOGGER.debug("{} has no incomplete signals. Signalling success", (Object)this);
            this.signal.signalSuccessfulCompletion();
        }
    }

    private class SubSignal
    implements AbortableSignal {
        private final AtomicBoolean complete = new AtomicBoolean(false);

        private SubSignal() {
        }

        public void signalFailure(Throwable cause) {
            if (this.complete.compareAndSet(false, true)) {
                LOGGER.debug("SubSignal {} signalling failure", (Object)this);
                AbortableSignalJunction.this.subSignalFailed(cause);
            }
        }

        public void signalSuccessfulCompletion() {
            if (this.complete.compareAndSet(false, true)) {
                LOGGER.debug("SubSignal {} signalling success", (Object)this);
                AbortableSignalJunction.this.subSignalSucceeded();
            }
        }

        public void signalAborted() {
            if (this.complete.compareAndSet(false, true)) {
                LOGGER.debug("SubSignal {} signalling abortion", (Object)this);
                AbortableSignalJunction.this.subSignalAborted();
            }
        }
    }
}

