/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.debug.ui.interpreters;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.mod.launching.IInterpreterInstall;
import org.eclipse.dltk.mod.launching.IInterpreterInstallType;
import org.eclipse.dltk.mod.launching.ScriptRuntime;
import org.eclipse.dltk.mod.ui.preferences.ComboViewerBlock;
import org.eclipse.dltk.mod.ui.preferences.ImprovedAbstractConfigurationBlock;
import org.eclipse.dltk.mod.ui.preferences.OverlayPreferenceStore;
import org.eclipse.dltk.mod.ui.util.SWTFactory;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;

public abstract class InternalScriptInterpreterPreferenceBlock
extends ImprovedAbstractConfigurationBlock {
    private ComboViewerBlock viewer;

    public InternalScriptInterpreterPreferenceBlock(OverlayPreferenceStore store, PreferencePage page) {
        super(store, page);
    }

    public final Control createControl(Composite parent) {
        Composite composite = SWTFactory.createComposite((Composite)parent, (Font)parent.getFont(), (int)1, (int)1, (int)4);
        Group group = SWTFactory.createGroup((Composite)composite, (String)this.getSelectorGroupLabel(), (int)1, (int)1, (int)768);
        SWTFactory.createLabel((Composite)group, (String)this.getSelectorNameLabel(), (int)1);
        GridData gd = new GridData(4, 4, true, true);
        this.viewer = new ComboViewerBlock((Composite)group, gd){

            protected String getObjectName(Object element) {
                return ((IInterpreterInstall)element).getName();
            }

            protected void selectedObjectChanged(Object element) {
                InternalScriptInterpreterPreferenceBlock.this.setString(InternalScriptInterpreterPreferenceBlock.this.getPreferenceKey(), this.getObjectId(element));
            }

            protected Object getDefaultObject() {
                return InternalScriptInterpreterPreferenceBlock.this.getDefaultSelectedInterpreter();
            }

            protected String getObjectId(Object element) {
                return ScriptRuntime.getCompositeIdFromInterpreter((IInterpreterInstall)((IInterpreterInstall)element));
            }

            protected String getSavedObjectId() {
                return InternalScriptInterpreterPreferenceBlock.this.getString(InternalScriptInterpreterPreferenceBlock.this.getPreferenceKey());
            }

            protected Object getObjectById(String id) {
                return ScriptRuntime.getInterpreterFromCompositeId((String)id);
            }
        };
        this.viewer.initialize((Object[])this.getInterpreterInstalls());
        return composite;
    }

    protected abstract String getNatureId();

    protected abstract String getPreferenceKey();

    protected abstract String getSelectorGroupLabel();

    protected abstract String getSelectorNameLabel();

    protected Object getDefaultSelectedInterpreter() {
        ScriptRuntime.DefaultInterpreterEntry entry = new ScriptRuntime.DefaultInterpreterEntry(this.getNatureId(), "org.eclipse.dltk.mod.core.environment.localEnvironment");
        return ScriptRuntime.getDefaultInterpreterInstall((ScriptRuntime.DefaultInterpreterEntry)entry);
    }

    protected List createOverlayKeys() {
        ArrayList<OverlayPreferenceStore.OverlayKey> keys = new ArrayList<OverlayPreferenceStore.OverlayKey>(1);
        keys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, this.getPreferenceKey()));
        return keys;
    }

    public void performDefaults() {
        super.performDefaults();
        this.viewer.performDefaults();
    }

    private IInterpreterInstall[] getInterpreterInstalls() {
        ArrayList<IInterpreterInstall> interpreters = new ArrayList<IInterpreterInstall>();
        IInterpreterInstallType[] types = ScriptRuntime.getInterpreterInstallTypes((String)this.getNatureId());
        int i = 0;
        while (i < types.length) {
            IInterpreterInstall[] installs = types[i].getInterpreterInstalls();
            int j = 0;
            while (j < installs.length) {
                interpreters.add(installs[j]);
                ++j;
            }
            ++i;
        }
        return interpreters.toArray(new IInterpreterInstall[interpreters.size()]);
    }
}

