/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jstojava.loader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.vjet.dsf.jsgroup.bootstrap.JsLibBootstrapLoader;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.ts.IJstTypeLoader;
import org.eclipse.vjet.dsf.jst.ts.util.JstSrcFileCollector;
import org.eclipse.vjet.dsf.jst.ts.util.JstTypeSerializer;
import org.eclipse.vjet.dsf.jstojava.parser.VjoParser;
import org.eclipse.vjet.dsf.ts.event.group.AddGroupEvent;

public class DefaultJstTypeLoader
implements IJstTypeLoader {
    private FileSuffix[] m_acceptedSuffixes;
    private static final String[] m_seperators = new String[]{"/", File.separator};

    public DefaultJstTypeLoader() {
        this(FileSuffix.js, FileSuffix.vjo, FileSuffix.ser);
    }

    public DefaultJstTypeLoader(FileSuffix ... acceptedSuffixes) {
        this.m_acceptedSuffixes = acceptedSuffixes;
    }

    public List<IJstTypeLoader.SourceType> loadJstTypes(List<AddGroupEvent> groupList) {
        ArrayList<IJstTypeLoader.SourceType> typeList = new ArrayList<IJstTypeLoader.SourceType>();
        for (AddGroupEvent group : groupList) {
            String groupName = group.getGroupName();
            String groupPath = group.getGroupPath();
            List srcPathList = group.getSourcePathList();
            if (srcPathList == null || srcPathList.size() == 0) {
                File groupFolderOrFile = this.getGroupSrcFolder(groupPath, null);
                typeList.addAll(this.loadJstTypesFromGroup(groupName, groupFolderOrFile));
                continue;
            }
            for (String srcPath : srcPathList) {
                File groupFolderOrFile = this.getGroupSrcFolder(groupPath, srcPath);
                typeList.addAll(this.loadJstTypesFromGroup(groupName, groupFolderOrFile));
            }
        }
        return typeList;
    }

    private List<IJstTypeLoader.SourceType> loadJstTypesFromGroup(String groupName, File groupFolderOrFile) {
        ArrayList<IJstTypeLoader.SourceType> srcTypeList = new ArrayList<IJstTypeLoader.SourceType>();
        if (groupFolderOrFile != null) {
            try {
                if (groupFolderOrFile.getCanonicalFile().isDirectory()) {
                    return this.loadJstTypesFromProject(groupName, groupFolderOrFile);
                }
                return this.loadJstTypesFromLibrary(groupName, groupFolderOrFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return srcTypeList;
    }

    private File getGroupSrcFolder(String groupPath, String srcPath) {
        File srcFolder;
        System.out.println("groupPath:" + groupPath + ", srcPath:" + srcPath);
        if (groupPath != null) {
            File groupFile = new File(groupPath);
            groupPath = this.decodePath(groupPath);
            if (groupFile.exists()) {
                if (!groupFile.isDirectory() || srcPath == null) {
                    return groupFile;
                }
                File srcFolder2 = new File(groupFile, srcPath);
                return srcFolder2;
            }
        } else if (srcPath != null && (srcFolder = new File(srcPath = this.decodePath(srcPath))).exists() && srcFolder.isDirectory()) {
            return srcFolder;
        }
        return null;
    }

    private String decodePath(String groupPath) {
        try {
            groupPath = URLDecoder.decode(groupPath, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return groupPath;
    }

    protected List<IJstTypeLoader.SourceType> loadJstTypesFromProject(String groupName, File srcFolder) {
        JstSrcFileCollector fileColl = new JstSrcFileCollector();
        ArrayList<IJstTypeLoader.SourceType> srcTypeList = new ArrayList<IJstTypeLoader.SourceType>();
        if (srcFolder != null) {
            List list = fileColl.getJsSrcFiles(srcFolder);
            for (File file : list) {
                try {
                    if (!this.isAccepted(file)) continue;
                    srcTypeList.add(DefaultJstTypeLoader.createType(groupName, srcFolder.getPath(), file));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return srcTypeList;
    }

    protected boolean isAccepted(File file) {
        return this.isAcceptedSuffix(file.getPath());
    }

    protected List<IJstTypeLoader.SourceType> loadJstTypesFromLibrary(String groupName, File libFile) {
        ArrayList<IJstTypeLoader.SourceType> typeList = new ArrayList<IJstTypeLoader.SourceType>();
        String libFileName = libFile.getName().toLowerCase();
        if (libFileName.endsWith(".zip") || libFileName.endsWith(".jar")) {
            try {
                ZipFile jarFile = new ZipFile(libFile);
                ZipEntry bootstrapEntry = jarFile.getEntry("bootstrap.js");
                if (bootstrapEntry != null) {
                    InputStream stream = jarFile.getInputStream(bootstrapEntry);
                    JsLibBootstrapLoader.load(VjoParser.load(stream, "bootstrap.js"), groupName);
                }
                Enumeration<? extends ZipEntry> enumeration = jarFile.entries();
                while (enumeration.hasMoreElements()) {
                    ZipEntry elem = enumeration.nextElement();
                    if (!this.acceptZipEntry(elem)) continue;
                    if (elem.getName().endsWith(".ser")) {
                        typeList.addAll(this.loadAllTypes(groupName, jarFile, elem));
                        continue;
                    }
                    if (elem.getName().contains("bootstrap.js")) continue;
                    typeList.add(DefaultJstTypeLoader.createType(groupName, jarFile, elem));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return typeList;
    }

    private boolean acceptZipEntry(ZipEntry elem) {
        String name;
        return !elem.isDirectory() && this.isAcceptedSuffix(name = elem.getName());
    }

    private boolean isAcceptedSuffix(String name) {
        FileSuffix[] fileSuffixArray = this.m_acceptedSuffixes;
        int n = this.m_acceptedSuffixes.length;
        int n2 = 0;
        while (n2 < n) {
            FileSuffix suf = fileSuffixArray[n2];
            if (name.endsWith(suf.getValue())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static String replaceSeperators(String fileName) {
        String typeName = fileName;
        if (fileName != null && fileName.length() != 0) {
            String[] stringArray = m_seperators;
            int n = m_seperators.length;
            int n2 = 0;
            while (n2 < n) {
                String seperator = stringArray[n2];
                typeName = typeName.replace(seperator, ".");
                ++n2;
            }
        }
        return typeName;
    }

    public static IJstTypeLoader.SourceType createType(String groupName, String srcPath, File file) throws IOException {
        String fileName = file.getPath();
        fileName = DefaultJstTypeLoader.replaceSeperators(fileName);
        String srcFolder = srcPath;
        srcFolder = DefaultJstTypeLoader.replaceSeperators(srcFolder);
        int start = fileName.lastIndexOf(srcFolder);
        start += srcFolder.length() + 1;
        int end = fileName.length();
        if (fileName.endsWith(".js")) {
            end = fileName.lastIndexOf(".js");
        } else if (fileName.endsWith(".vjo")) {
            end = fileName.lastIndexOf(".vjo");
        }
        String typeName = fileName.substring(start, end);
        IJstTypeLoader.SourceType srcType = new IJstTypeLoader.SourceType(groupName, typeName, null, file);
        return srcType;
    }

    public static IJstTypeLoader.SourceType createType(String groupName, ZipFile jarFile, ZipEntry elem) throws IOException {
        String typeName = elem.getName();
        int end = typeName.length();
        if (typeName.endsWith(".js")) {
            end = typeName.lastIndexOf(".js");
        } else if (typeName.endsWith(".vjo")) {
            end = typeName.lastIndexOf(".vjo");
        }
        typeName = typeName.substring(0, end);
        typeName = DefaultJstTypeLoader.replaceSeperators(typeName);
        InputStream stream = jarFile.getInputStream(elem);
        byte[] bs = new byte[stream.available()];
        stream.read(bs);
        stream.close();
        String source = new String(bs);
        IJstTypeLoader.SourceType srcType = new IJstTypeLoader.SourceType(groupName, typeName, source);
        return srcType;
    }

    protected List<IJstTypeLoader.SourceType> loadAllTypes(String groupName, ZipFile jarFile, ZipEntry elem) throws IOException {
        InputStream stream = jarFile.getInputStream(elem);
        List jstTypes = JstTypeSerializer.getInstance().deserialize(stream);
        ArrayList<IJstTypeLoader.SourceType> srcTypes = new ArrayList<IJstTypeLoader.SourceType>();
        for (IJstType type : jstTypes) {
            srcTypes.add(new IJstTypeLoader.SourceType(groupName, type));
        }
        return srcTypes;
    }

    public static enum FileSuffix {
        js(".js"),
        vjo(".vjo"),
        ser(".ser");

        String m_value;

        private FileSuffix(String val) {
            this.m_value = val;
        }

        public String getValue() {
            return this.m_value;
        }
    }
}

