/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jstojava.translator;

import org.eclipse.mod.wst.jsdt.internal.compiler.ast.Literal;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.StringLiteral;
import org.eclipse.vjet.dsf.jsgen.shared.ids.ScopeIds;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.JstSource;
import org.eclipse.vjet.dsf.jst.declaration.JstProperty;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.term.SimpleLiteral;
import org.eclipse.vjet.dsf.jst.token.ISimpleTerm;
import org.eclipse.vjet.dsf.jstojava.translator.BasePropsProtosTranslator;
import org.eclipse.vjet.dsf.jstojava.translator.IFindTypeSupport;
import org.eclipse.vjet.dsf.jstojava.translator.JstUtil;
import org.eclipse.vjet.dsf.jstojava.translator.TranslateCtx;
import org.eclipse.vjet.dsf.jstojava.translator.TranslateHelper;

public class ValuesTranslator
extends BasePropsProtosTranslator {
    public ValuesTranslator(TranslateCtx ctx) {
        super(ctx);
        this.type = ScopeIds.VALUES;
    }

    public void processValues(Literal literal, JstType type) {
        if (literal instanceof StringLiteral) {
            String s = JstUtil.getCorrectName(literal);
            String[] names = s.split(",");
            int index = literal.sourceStart + 1;
            int ordinal = 0;
            String[] stringArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String fullname = stringArray[n2];
                int fullLength = fullname.length();
                String trimFullname = fullname.trim();
                if (trimFullname.length() > 0 && Character.isJavaIdentifierStart(trimFullname.charAt(0))) {
                    int indent = fullname.indexOf(trimFullname);
                    type.addEnumValue((IJstProperty)this.createEnumProperty(type, index + indent, trimFullname, ordinal++));
                }
                index = index + fullLength + 1;
                ++n2;
            }
        }
    }

    private JstProperty createEnumProperty(JstType type, int index, String name, int ordinal) {
        JstProperty property = new JstProperty((IJstType)type, name.trim());
        property.setParent((IJstNode)type);
        property.getModifiers().setFinal();
        property.getModifiers().setPublic();
        property.getModifiers().setStatic(true);
        JstSource source = ValuesTranslator.createSource(index, index + name.trim().length() - 1, this.m_ctx.getSourceUtil());
        property.setSource(source);
        property.getName().setSource(source);
        if (ordinal != -1) {
            property.setValue((ISimpleTerm)SimpleLiteral.getIntLiteral((int)ordinal));
        }
        return property;
    }

    public static JstSource createSource(int start, int end, IFindTypeSupport.ILineInfoProvider util) {
        return TranslateHelper.createJstSource(util, end - start, start, end);
    }
}

