/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jstojava.translator.robust.ast2jst;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.mod.wst.jsdt.core.ast.IASTNode;
import org.eclipse.mod.wst.jsdt.core.ast.IAbstractVariableDeclaration;
import org.eclipse.mod.wst.jsdt.core.ast.IStatement;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.util.JstBindingUtil;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.IJstTypeReference;
import org.eclipse.vjet.dsf.jst.JstSource;
import org.eclipse.vjet.dsf.jst.declaration.JstCache;
import org.eclipse.vjet.dsf.jst.declaration.JstFactory;
import org.eclipse.vjet.dsf.jst.declaration.JstFuncType;
import org.eclipse.vjet.dsf.jst.declaration.JstInferredType;
import org.eclipse.vjet.dsf.jst.declaration.JstMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstVars;
import org.eclipse.vjet.dsf.jst.expr.AssignExpr;
import org.eclipse.vjet.dsf.jst.meta.IJsCommentMeta;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jst.token.ILHS;
import org.eclipse.vjet.dsf.jstojava.parser.comments.CommentCollector;
import org.eclipse.vjet.dsf.jstojava.translator.IFindTypeSupport;
import org.eclipse.vjet.dsf.jstojava.translator.TranslateHelper;
import org.eclipse.vjet.dsf.jstojava.translator.robust.ast2jst.BaseAst2JstTranslator;

public class LocalDeclarationTranslator
extends BaseAst2JstTranslator<LocalDeclaration, JstVars[]> {
    @Override
    protected JstVars[] doTranslate(LocalDeclaration statement) {
        List<IJsCommentMeta> outerMetaList;
        LocalDeclaration origStatement = statement;
        IJsCommentMeta outerMeta = null;
        List<IJsCommentMeta> metaList = null;
        CommentCollector commentCollector = this.m_ctx.getCommentCollector();
        int exprStartOffset = statement.declarationSourceStart;
        ArrayList<JstVars> varsList = new ArrayList<JstVars>();
        int exprEndOffset = LocalDeclarationTranslator.findSourceEnd(statement);
        metaList = outerMetaList = commentCollector.getCommentMeta(exprStartOffset, exprEndOffset, this.m_ctx.getPreviousNodeSourceEnd(), this.m_ctx.getNextNodeSourceStart());
        boolean multiVar = false;
        IJstType outerJstType = null;
        if (statement.nextLocal != null) {
            multiVar = true;
        }
        if (metaList.size() > 0 && metaList.get(0).getTyping() != null) {
            outerMeta = metaList.get(0);
            outerJstType = TranslateHelper.findType(this.m_ctx, outerMeta.getTyping(), outerMeta);
        }
        int count = 0;
        do {
            IJstType foundType;
            BaseJstNode initBaseNode;
            IJstType jstType = null;
            IJsCommentMeta meta = null;
            if (multiVar && count == 0 && outerMeta != null && outerMeta.getDirection().equals((Object)IJsCommentMeta.DIRECTION.FORWARD)) {
                jstType = outerJstType;
            } else if (multiVar && statement.nextLocal != null) {
                exprStartOffset = statement.sourceStart;
                exprEndOffset = statement.sourceEnd;
                metaList = commentCollector.getCommentMeta(exprStartOffset, exprEndOffset, this.m_ctx.getPreviousNodeSourceEnd(), statement.nextLocal.sourceStart);
            } else if (multiVar && statement.nextLocal == null && outerMetaList != null && outerMeta != null && outerMeta.getDirection().equals((Object)IJsCommentMeta.DIRECTION.BACK)) {
                jstType = outerJstType;
            }
            String name = String.valueOf(statement.getName());
            JstIdentifier jstIdentifier = new JstIdentifier(name);
            JstSource source = TranslateHelper.getIdentifierSource((IAbstractVariableDeclaration)statement, this.m_ctx.getSourceUtil());
            jstIdentifier.setSource(source);
            IExpr init = null;
            if (statement.initialization != null) {
                List<IJsCommentMeta> metaFromExpr;
                init = (IExpr)this.getTranslatorAndTranslate((IASTNode)statement.initialization);
                initBaseNode = (BaseJstNode)init;
                if (init != null && init instanceof BaseJstNode && (metaFromExpr = TranslateHelper.findMetaFromExpr(initBaseNode)) != null && metaFromExpr.size() != 0) {
                    metaList = metaFromExpr;
                }
                init = metaList != null ? TranslateHelper.getCastable(init, metaList, this.m_ctx) : TranslateHelper.getCastable(init, (IStatement)statement, this.m_ctx);
            }
            if (metaList != null && metaList.size() > 0) {
                meta = metaList.get(0);
            } else if (init != null && init instanceof BaseJstNode && (metaList = TranslateHelper.findMetaFromExpr(initBaseNode = (BaseJstNode)init)) != null && metaList.size() > 0) {
                meta = metaList.iterator().next();
            }
            if (meta != null) {
                jstType = this.getTypeFromMeta(jstType, meta, metaList, jstIdentifier, init);
            }
            AssignExpr assignExpr = new AssignExpr((ILHS)jstIdentifier, init);
            assignExpr.setSource(TranslateHelper.getSource((IAbstractVariableDeclaration)statement, this.m_ctx.getSourceUtil()));
            if (multiVar) {
                foundType = jstType;
            } else if (!multiVar && outerJstType == null) {
                foundType = jstType;
            } else if (outerMetaList != null && outerMetaList.size() == 1) {
                foundType = outerJstType;
                foundType = this.handleSynthesizedMethods(foundType, metaList, jstIdentifier, init);
            } else {
                foundType = jstType;
            }
            boolean typeFound = true;
            if (foundType == null) {
                typeFound = false;
                foundType = JstCache.getInstance().getType("Undefined");
                if (foundType == null) {
                    foundType = JstFactory.getInstance().createJstType("Undefined", true);
                }
                foundType = new JstInferredType(foundType);
            }
            JstVars vars = new JstVars(foundType);
            if (meta != null && meta.getModifiers().isFinal()) {
                vars.setIsFinal(true);
            }
            if (origStatement != null) {
                vars.setSource(LocalDeclarationTranslator.getStatementSource(origStatement, this.m_ctx.getSourceUtil()));
            }
            vars.addAssignment(assignExpr);
            if (meta != null && typeFound) {
                IJstTypeReference typeRef = vars.getTypeRef();
                TranslateHelper.setTypeRefSource((BaseJstNode)typeRef, meta);
                meta = null;
                metaList = null;
            }
            varsList.add(vars);
            ++count;
        } while ((statement = (LocalDeclaration)statement.nextLocal) != null);
        return varsList.toArray(new JstVars[0]);
    }

    private IJstType getTypeFromMeta(IJstType jstType, IJsCommentMeta meta, List<IJsCommentMeta> metaList, JstIdentifier jstIdentifier, IExpr init) {
        if (meta.isCast() && init != null) {
            jstType = init.getResultType();
        } else if (meta.getTyping() != null) {
            jstType = TranslateHelper.findType(this.m_ctx, meta.getTyping(), meta);
            jstType = this.handleSynthesizedMethods(jstType, metaList, jstIdentifier, init);
        }
        return jstType;
    }

    private IJstType handleSynthesizedMethods(IJstType jstType, List<IJsCommentMeta> metaList, JstIdentifier jstIdentifier, IExpr init) {
        if (jstType instanceof JstFuncType) {
            IJstMethod replacement = null;
            boolean rhsMethodFound = false;
            if (init != null) {
                IJstNode initBinding = JstBindingUtil.getJstBinding((IJstNode)init);
                boolean bl = rhsMethodFound = initBinding != null && initBinding instanceof JstMethod;
                if (rhsMethodFound) {
                    replacement = (IJstMethod)initBinding;
                    jstIdentifier.setJstBinding(initBinding);
                    IJstType iJstType = jstType = init.getResultType() != null ? init.getResultType() : jstType;
                }
            }
            if (!rhsMethodFound) {
                replacement = TranslateHelper.MethodTranslateHelper.createJstSynthesizedMethod(metaList, (IFindTypeSupport)this.m_ctx, "");
                jstType = TranslateHelper.replaceSynthesizedMethodBinding(jstIdentifier, replacement);
            }
        }
        return jstType;
    }

    private static int findSourceEnd(LocalDeclaration statement) {
        return statement.declarationSourceEnd;
    }

    private static JstSource getStatementSource(LocalDeclaration statement, IFindTypeSupport.ILineInfoProvider util) {
        int line = util.line(statement.declarationSourceStart);
        int col = util.col(statement.declarationSourceStart);
        return new JstSource(2, line, col, LocalDeclarationTranslator.findSourceEnd(statement) - statement.declarationSourceStart + 1, statement.declarationSourceStart, LocalDeclarationTranslator.findSourceEnd(statement));
    }
}

