/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vsf.docprocessing;

import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Queue;
import org.eclipse.vjet.dsf.common.context.DsfCtx;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.dom.DDocument;
import org.eclipse.vjet.dsf.dom.util.DeferConstructionCollector;
import org.eclipse.vjet.dsf.html.dom.util.IDeferConstruction;
import org.eclipse.vjet.dsf.logger.LogLevel;
import org.eclipse.vjet.dsf.logger.Logger;
import org.eclipse.vjet.vsf.docprocessing.BaseDocProcessEvent;
import org.eclipse.vjet.vsf.docprocessing.DocProcessCtx;
import org.eclipse.vjet.vsf.docprocessing.IDocModifier;
import org.eclipse.vjet.vsf.docprocessing.IDocProcessEventListener;
import org.eclipse.vjet.vsf.docprocessing.IDocProcessor;
import org.eclipse.vjet.vsf.docprocessing.IJsProcessor;
import org.eclipse.vjet.vsf.docprocessing.IProductionPlan;
import org.eclipse.vjet.vsf.docprocessing.PostDocProcessEvent;
import org.eclipse.vjet.vsf.docprocessing.PreDocProcessEvent;
import org.eclipse.vjet.vsf.docprocessing.ProductionCtx;

public abstract class BaseDocProcessor
implements IDocProcessor {
    private static Logger s_logger;
    protected IProductionPlan m_plan;

    public BaseDocProcessor(IProductionPlan plan) {
        this.m_plan = plan;
    }

    protected abstract void processDocAnnotation(DDocument var1);

    @Override
    public IProductionPlan getPlan() {
        return this.m_plan;
    }

    @Override
    public void setPlan(IProductionPlan plan) {
        this.m_plan = plan;
    }

    @Override
    public void process(DDocument doc) {
        this.beforeProcess(doc);
        this.finishComponents();
        this.processDocModifiers(doc);
        this.processDocAnnotation(doc);
        this.finishComponents();
        this.processJs(doc);
        this.afterProcess(doc);
    }

    protected void processJs(DDocument doc) {
        this.createJsProcessor().process(doc, this.m_plan.getViewSpec());
    }

    protected void finishComponents() {
        DeferConstructionCollector collector = DsfCtx.ctx().getDeferConstructionCollector();
        IDeferConstruction component = null;
        while ((component = collector.removeFirst()) != null) {
            component.finish();
        }
    }

    protected void processDocModifiers(DDocument doc) {
        ProductionCtx pctx;
        if (this.m_plan.isProcessDocModifiers() && (pctx = ProductionCtx.ctx()).hasDocModifiers()) {
            IDocModifier modifier = null;
            try {
                Queue<IDocModifier> queue = pctx.getDocModifiersQueue();
                while (!queue.isEmpty()) {
                    modifier = queue.poll();
                    if (modifier == null) continue;
                    modifier.modify(doc);
                }
            }
            catch (ConcurrentModificationException cme) {
                throw new DsfRuntimeException("Modifier: " + (modifier != null ? modifier.getClass().getName() : "Unknown") + " is adding something to ctx", (Throwable)cme);
            }
        }
    }

    protected abstract IJsProcessor createJsProcessor();

    private void beforeProcess(DDocument doc) {
        this.dispatchEvent(doc, DocProcessCtx.ctx().getListenerList(), true);
        this.dispatchEvent(doc, DocProcessCtx.getGlobalListenerList(), true);
    }

    private void afterProcess(DDocument doc) {
        this.dispatchEvent(doc, DocProcessCtx.ctx().getListenerList(), false);
        this.dispatchEvent(doc, DocProcessCtx.getGlobalListenerList(), false);
    }

    private void dispatchEvent(DDocument doc, List<IDocProcessEventListener> listeners, boolean isBefore) {
        if (listeners == null) {
            return;
        }
        for (IDocProcessEventListener listener : listeners) {
            try {
                if (!listener.isActive()) continue;
                BaseDocProcessEvent event = isBefore ? new PreDocProcessEvent(this, doc) : new PostDocProcessEvent(this, doc);
                event.dispatch(listener);
            }
            catch (Exception e) {
                this.logEx(e);
            }
        }
    }

    private void logEx(Exception e) {
        if (this.getLogger().isLogEnabled(LogLevel.DEBUG)) {
            this.getLogger().log(LogLevel.DEBUG, (Throwable)e);
        }
    }

    private Logger getLogger() {
        if (s_logger == null) {
            s_logger = Logger.getInstance(this.getClass());
        }
        return s_logger;
    }
}

