/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.css.dom.impl;

import java.io.Serializable;
import org.eclipse.vjet.dsf.css.dom.impl.DCssBaseColor;
import org.eclipse.vjet.dsf.css.dom.impl.DCssValue;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.RGBColor;

public class DCssRgbColor
extends DCssBaseColor
implements RGBColor,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    protected CSSPrimitiveValue m_red;
    protected CSSPrimitiveValue m_green;
    protected CSSPrimitiveValue m_blue;

    public DCssRgbColor(LexicalUnit lu) {
        LexicalUnit next = lu;
        this.m_red = new DCssValue(next, true);
        next = next.getNextLexicalUnit();
        next = next.getNextLexicalUnit();
        this.m_green = new DCssValue(next, true);
        next = next.getNextLexicalUnit();
        next = next.getNextLexicalUnit();
        this.m_blue = new DCssValue(next, true);
    }

    protected DCssRgbColor() {
    }

    @Override
    public CSSPrimitiveValue getRed() {
        return this.m_red;
    }

    public void setRed(CSSPrimitiveValue red) {
        this.m_red = red;
    }

    @Override
    public CSSPrimitiveValue getGreen() {
        return this.m_green;
    }

    public void setGreen(CSSPrimitiveValue green) {
        this.m_green = green;
    }

    @Override
    public CSSPrimitiveValue getBlue() {
        return this.m_blue;
    }

    public void setBlue(CSSPrimitiveValue blue) {
        this.m_blue = blue;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String toString() {
        String rs = this.m_red.toString();
        String gs = this.m_green.toString();
        String bs = this.m_blue.toString();
        StringBuilder sb = null;
        if (DCssRgbColor.isPercentage(rs) && DCssRgbColor.isPercentage(gs) && DCssRgbColor.isPercentage(bs)) {
            sb = new StringBuilder(20);
            sb.append("rgb(");
            DCssRgbColor.appendPercentage(sb, rs);
            sb.append(',');
            DCssRgbColor.appendPercentage(sb, gs);
            sb.append(',');
            DCssRgbColor.appendPercentage(sb, bs);
            sb.append(')');
        } else {
            sb = new StringBuilder(7);
            sb.append('#');
            DCssRgbColor.appendHexValue(sb, Integer.parseInt(rs));
            DCssRgbColor.appendHexValue(sb, Integer.parseInt(gs));
            DCssRgbColor.appendHexValue(sb, Integer.parseInt(bs));
            if (sb.charAt(1) == sb.charAt(2) && sb.charAt(3) == sb.charAt(4) && sb.charAt(5) == sb.charAt(6)) {
                char[] chars = new char[]{'#', sb.charAt(1), sb.charAt(3), sb.charAt(5)};
                sb = new StringBuilder(4);
                sb.append(chars);
            }
        }
        return sb.toString();
    }

    private static void appendHexValue(StringBuilder sb, int value) {
        if (value < 0) {
            value = 0;
        } else if (value > 255) {
            value = 255;
        }
        String h = Integer.toHexString(value);
        if (h.length() == 1) {
            sb.append('0');
        }
        sb.append(h);
    }
}

