/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.context.subctx.browser;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.vjet.dsf.common.context.subctx.browser.Capability;
import org.eclipse.vjet.dsf.common.context.subctx.browser.IBrowser;
import org.eclipse.vjet.dsf.common.context.subctx.browser.IFeatureCapableChecker;

public class BrowserCapabilityRegistry {
    private static BrowserCapabilityRegistry _instance;
    private Map<String, IFeatureCapableChecker> _capabilities = new HashMap<String, IFeatureCapableChecker>();

    private BrowserCapabilityRegistry() {
    }

    public static synchronized BrowserCapabilityRegistry getInstance() {
        if (_instance == null) {
            _instance = new BrowserCapabilityRegistry();
        }
        return _instance;
    }

    public void register(String featureId, IFeatureCapableChecker capable) {
        if (featureId == null || featureId.trim().length() == 0 || capable == null) {
            return;
        }
        if (this._capabilities.containsKey(featureId)) {
            return;
        }
        this._capabilities.put(featureId, capable);
    }

    public String[] getKnownFeatures() {
        return this._capabilities.keySet().toArray(new String[0]);
    }

    public Capability capableOf(String featureId, IBrowser browser) {
        if (featureId == null || featureId.trim().length() == 0) {
            return Capability.UNKNOWN_FEATURE;
        }
        IFeatureCapableChecker capable = this._capabilities.get(featureId);
        if (capable == null) {
            return Capability.UNKNOWN_FEATURE;
        }
        boolean capableOf = true;
        try {
            capableOf = capable.supportFeature(browser);
        }
        catch (Exception exception) {
            return Capability.UNKNOWN_FEATURE;
        }
        if (capableOf) {
            return Capability.IS_CAPABLE;
        }
        return Capability.NOT_CAPABLE;
    }
}

