/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.dbgp;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.IPath;

public final class DbgpURIUtil {
    public static boolean isDBGPURI(URI uri) {
        if (uri == null) {
            return false;
        }
        String scheme = uri.getScheme();
        return scheme != null && "dbgp".equals(scheme);
    }

    public static boolean isDBGPPath(IPath path) {
        if (path == null) {
            return false;
        }
        return path.toString().startsWith("dbgp");
    }

    public static URI convert2DBGPURIFromPath(IPath path) throws URISyntaxException {
        if (path == null || !DbgpURIUtil.isDBGPPath(path)) {
            return null;
        }
        path = path.setDevice(null);
        return new URI("dbgp", "", path.toString(), null);
    }
}

