/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jstojava.codegentools;

import java.io.File;
import java.io.IOException;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.ts.JstTypeSpaceMgr;
import org.eclipse.vjet.dsf.jstojava.controller.BuildController;
import org.eclipse.vjet.dsf.jstojava.controller.GenerationConfig;
import org.eclipse.vjet.dsf.jstojava.parser.VjoParser;
import org.eclipse.vjet.dsf.jstojava.translator.TranslateConfig;
import org.eclipse.vjet.dsf.ts.type.TypeName;

public class JsToJavaGen {
    private static final JsGenTypes[] DEFAULT_GEN_TARGETS = new JsGenTypes[]{JsGenTypes.JSR, JsGenTypes.NJP};

    public static void main(String[] args) {
        System.out.println("--------------");
        int i = 0;
        while (i < args.length) {
            System.out.println(">>>" + args[i]);
            ++i;
        }
        System.out.println("--------------");
        String onDemandLoc = JsToJavaGen.checkAndGetOnDemandLocation(args);
        if (onDemandLoc != null) {
            JsToJavaGen.generate(onDemandLoc);
        } else {
            JsToJavaGenInfo info = JsToJavaGen.parseArgs(args);
            JsToJavaGen.generate(info);
        }
    }

    private static void generate(String location) {
        String ONDEMAND = "ONDEMAND";
        TranslateConfig cfg = new TranslateConfig();
        BuildController c = new BuildController();
        JstTypeSpaceMgr mgr = c.loadType(ONDEMAND, null);
        cfg.setSkiptImplementation(true);
        VjoParser p = new VjoParser(cfg);
        IJstType t = p.parse(ONDEMAND, new File(location));
        mgr = c.loadType(ONDEMAND, t);
        GenerationConfig config = new GenerationConfig();
        config.setGenJsr(true);
        config.setGenNJP(true);
        IJstType type = mgr.getQueryExecutor().findType(new TypeName(ONDEMAND, t.getName()));
        if (type != null) {
            try {
                c.generate(type, config);
                c.printOut(System.out, c.getResult());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            System.err.println("Problem generating " + location);
        }
    }

    private static void generate(JsToJavaGenInfo info) {
        BuildController c = new BuildController();
        JstTypeSpaceMgr mgr = c.loadTypes("TEST", info.getProjectPath(), info.getSourcDirs());
        GenerationConfig config = new GenerationConfig();
        JsToJavaGen.determineGenConfig(config, info);
        try {
            if (info.getOnlyThisType() == null) {
                c.generateAll(config);
            } else {
                TypeName typeName = new TypeName("TEST", info.getOnlyThisType());
                IJstType type = mgr.getQueryExecutor().findType(typeName);
                if (type != null) {
                    c.generate(type, config);
                } else {
                    throw new DsfRuntimeException("type : " + info.getOnlyThisType() + " was not found in typespace");
                }
            }
            c.printOut(System.out, c.getResult());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String checkAndGetOnDemandLocation(String[] args) {
        if (args.length == 1 && args[0].indexOf("=") < 0) {
            return args[0].replace('\\', '/');
        }
        return null;
    }

    private static void determineGenConfig(GenerationConfig config, JsToJavaGenInfo info) {
        JsGenTypes[] types = info.getGenTypes();
        if (types == null) {
            return;
        }
        config.setGenJsr(false);
        config.setGenNJP(false);
        JsGenTypes[] jsGenTypesArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            JsGenTypes type = jsGenTypesArray[n2];
            if (type != null) {
                if (type.equals((Object)JsGenTypes.JSR)) {
                    config.setGenJsr(true);
                }
                if (type.equals((Object)JsGenTypes.NJP)) {
                    config.setGenNJP(true);
                }
            }
            ++n2;
        }
    }

    private static JsToJavaGenInfo parseArgs(String[] args) {
        JsToJavaGenInfo info = new JsToJavaGenInfo();
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String a = stringArray[n2];
            String[] split = a.split("=");
            JsToJavaGen.handleProjectPath(info, a, split);
            JsToJavaGen.handleSourceDir(info, a, split);
            JsToJavaGen.handleGenOnlyOneType(info, a, split);
            JsToJavaGen.handleGenConfig(info, a, split);
            ++n2;
        }
        return info;
    }

    private static void handleGenConfig(JsToJavaGenInfo info, String a, String[] split) {
        JsGenTypes[] targets = new JsGenTypes[2];
        if (a.indexOf("-genConfig") != -1) {
            if (split[1].indexOf(",") != -1) {
                String[] types;
                String[] stringArray = types = split[1].split(",");
                int n = types.length;
                int n2 = 0;
                while (n2 < n) {
                    String type = stringArray[n2];
                    JsToJavaGen.determineTargets(targets, type);
                    ++n2;
                }
            } else if (split[1] != null) {
                JsToJavaGen.determineTargets(targets, split[1]);
            } else {
                targets = DEFAULT_GEN_TARGETS;
            }
        } else {
            targets = DEFAULT_GEN_TARGETS;
        }
        info.setGenTypes(targets);
    }

    private static void determineTargets(JsGenTypes[] targets, String type) {
        if (type.indexOf("JSR") != -1) {
            targets[0] = JsGenTypes.JSR;
        }
        if (type.indexOf("NJP") != -1) {
            targets[1] = JsGenTypes.NJP;
        }
    }

    private static void handleGenOnlyOneType(JsToJavaGenInfo info, String a, String[] split) {
        if (a.indexOf("-genOnlyThisType") != -1) {
            info.setOnlyThisType(split[1]);
        }
    }

    private static void handleProjectPath(JsToJavaGenInfo info, String a, String[] split) {
        if (a.indexOf("-projectPath") != -1) {
            info.setProjectPath(split[1]);
        }
    }

    private static void handleSourceDir(JsToJavaGenInfo info, String a, String[] split) {
        if (a.indexOf("-sourceDirs") != -1) {
            String[] srcDirs = split[1].indexOf(",") != -1 ? split[1].split(",") : new String[]{split[1]};
            info.setSourcDirs(srcDirs);
        }
    }

    public static enum JsGenTypes {
        JSR,
        NJP;

    }

    static class JsToJavaGenInfo {
        private String m_projectPath;
        private String[] m_sourcDirs;
        private String m_onlyThisType;
        private JsGenTypes[] m_genTypes;

        JsToJavaGenInfo() {
        }

        public String getProjectPath() {
            return this.m_projectPath;
        }

        public String[] getSourcDirs() {
            return this.m_sourcDirs;
        }

        public String getOnlyThisType() {
            return this.m_onlyThisType;
        }

        public JsGenTypes[] getGenTypes() {
            return this.m_genTypes;
        }

        public void setProjectPath(String projectPath) {
            this.m_projectPath = projectPath;
        }

        public void setSourcDirs(String[] sourcDirs) {
            this.m_sourcDirs = sourcDirs;
        }

        public void setOnlyThisType(String onlyThisType) {
            this.m_onlyThisType = onlyThisType;
        }

        public void setGenTypes(JsGenTypes[] genTypes) {
            this.m_genTypes = genTypes;
        }
    }
}

