/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.console.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.dltk.mod.console.IScriptConsoleShell;
import org.eclipse.dltk.mod.console.ScriptConsoleCompletionProposal;
import org.eclipse.dltk.mod.console.ui.IScriptConsoleViewer;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;

public abstract class ScriptConsoleCompletionProcessor
implements IContentAssistProcessor {
    private static IProposalDecorator defaultDecorator;
    private IScriptConsoleShell interpreterShell;

    protected IProposalDecorator getDefaultDecorator() {
        if (defaultDecorator == null) {
            defaultDecorator = new IProposalDecorator(){

                @Override
                public String formatProposal(ScriptConsoleCompletionProposal c) {
                    return c.getDisplay();
                }

                @Override
                public Image getImage(ScriptConsoleCompletionProposal c) {
                    return null;
                }
            };
        }
        return defaultDecorator;
    }

    public ScriptConsoleCompletionProcessor(IScriptConsoleShell interpreterShell) {
        this.interpreterShell = interpreterShell;
    }

    protected IScriptConsoleShell getInterpreterShell() {
        return this.interpreterShell;
    }

    protected List createProposalsFromString(List list, int offset, IProposalDecorator decorator) {
        if (decorator == null) {
            decorator = this.getDefaultDecorator();
        }
        ArrayList<CompletionProposal> result = new ArrayList<CompletionProposal>();
        for (ScriptConsoleCompletionProposal c : list) {
            CompletionProposal proposal = new CompletionProposal(c.getInsert(), offset, 0, c.getInsert().length(), decorator.getImage(c), decorator.formatProposal(c), null, null);
            result.add(proposal);
        }
        Collections.sort(result, new Comparator(){

            public int compare(Object o1, Object o2) {
                CompletionProposal p1 = (CompletionProposal)o1;
                CompletionProposal p2 = (CompletionProposal)o2;
                return p1.getDisplayString().compareTo(p2.getDisplayString());
            }
        });
        return result;
    }

    protected abstract ICompletionProposal[] computeCompletionProposalsImpl(IScriptConsoleViewer var1, int var2);

    protected abstract IContextInformation[] computeContextInformationImpl(ITextViewer var1, int var2);

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        return this.computeCompletionProposalsImpl((IScriptConsoleViewer)viewer, offset);
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return this.computeContextInformationImpl((IScriptConsoleViewer)viewer, offset);
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    protected static interface IProposalDecorator {
        public String formatProposal(ScriptConsoleCompletionProposal var1);

        public Image getImage(ScriptConsoleCompletionProposal var1);
    }
}

