/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.core.environment;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.mod.core.environment.EnvironmentManager;
import org.eclipse.dltk.mod.core.environment.IEnvironment;
import org.eclipse.dltk.mod.core.environment.IFileHandle;
import org.eclipse.dltk.mod.core.environment.Messages;

public class EnvironmentPathUtils {
    public static final String PATH_DELIMITER = ";";
    private static final char SEPARATOR = '/';

    public static IPath getFullPath(IEnvironment env, IPath path) {
        if (EnvironmentPathUtils.isFull(path)) {
            throw new RuntimeException(MessageFormat.format(Messages.EnvironmentPathUtils_invalidPath, path));
        }
        String device = path.getDevice();
        if (device == null) {
            device = Character.toString(':');
        }
        return path.setDevice(String.valueOf(env.getId()) + '/' + device);
    }

    public static boolean isFull(IPath path) {
        String device = path.getDevice();
        return device != null && device.indexOf(47) >= 0;
    }

    public static IEnvironment getPathEnvironment(IPath path) {
        if (!EnvironmentPathUtils.isFull(path)) {
            return null;
        }
        String envId = path.getDevice();
        if (envId == null) {
            return null;
        }
        int index = envId.indexOf(47);
        envId = envId.substring(0, index);
        return EnvironmentManager.getEnvironmentById(envId);
    }

    public static IPath getLocalPath(IPath path) {
        if (!EnvironmentPathUtils.isFull(path)) {
            return path;
        }
        String device = path.getDevice();
        int index = device.indexOf(47);
        Assert.isTrue((index >= 0 ? 1 : 0) != 0);
        device = device.substring(index + 1);
        if (device.length() == 1 && device.charAt(0) == ':') {
            device = null;
        }
        return path.setDevice(device);
    }

    public static String getLocalPathString(IPath path) {
        IEnvironment env = EnvironmentPathUtils.getPathEnvironment(path);
        IPath localPath = EnvironmentPathUtils.getLocalPath(path);
        return env.convertPathToString(localPath);
    }

    public static IFileHandle getFile(IPath fullPath) {
        IEnvironment env = EnvironmentPathUtils.getPathEnvironment(fullPath);
        if (env == null) {
            return null;
        }
        IPath path = EnvironmentPathUtils.getLocalPath(fullPath);
        return env.getFile(path);
    }

    public static Map decodePaths(String concatenatedPaths) {
        HashMap<IEnvironment, String> result = new HashMap<IEnvironment, String>();
        if (concatenatedPaths != null) {
            String[] paths = concatenatedPaths.split(PATH_DELIMITER);
            int i = 0;
            while (i < paths.length) {
                IPath path = Path.fromPortableString((String)paths[i]);
                IEnvironment env = EnvironmentPathUtils.getPathEnvironment(path);
                if (env != null) {
                    String localPath = EnvironmentPathUtils.getLocalPathString(path);
                    result.put(env, localPath);
                }
                ++i;
            }
        }
        return result;
    }

    public static String encodePaths(Map env2path) {
        Iterator it = env2path.entrySet().iterator();
        StringBuffer concatenatedPaths = new StringBuffer();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            IEnvironment key = (IEnvironment)entry.getKey();
            String localPath = (String)entry.getValue();
            IPath path = EnvironmentPathUtils.getFullPath(key, (IPath)new Path(localPath));
            concatenatedPaths.append(path.toPortableString());
            if (!it.hasNext()) continue;
            concatenatedPaths.append(PATH_DELIMITER);
        }
        return concatenatedPaths.toString();
    }

    public static IFileHandle getFile(IEnvironment environment, IPath path) {
        if (EnvironmentPathUtils.isFull(path)) {
            return EnvironmentPathUtils.getFile(path);
        }
        return environment.getFile(path);
    }
}

