/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.core;

import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.ISourceRange;
import org.eclipse.dltk.mod.core.ISourceReference;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.core.WorkingCopyOwner;
import org.eclipse.dltk.mod.internal.core.AbstractSourceModule;
import org.eclipse.dltk.mod.internal.core.ImportDeclaration;
import org.eclipse.dltk.mod.internal.core.ModelElement;
import org.eclipse.dltk.mod.internal.core.ModelElementInfo;
import org.eclipse.dltk.mod.internal.core.ModelManager;
import org.eclipse.dltk.mod.internal.core.SourceModule;
import org.eclipse.dltk.mod.internal.core.SourceRange;
import org.eclipse.dltk.mod.internal.core.SourceRefElement;
import org.eclipse.dltk.mod.internal.core.util.MementoTokenizer;
import org.eclipse.dltk.mod.utils.CorePrinter;
import org.eclipse.vjet.eclipse.core.IImportContainer;
import org.eclipse.vjet.eclipse.core.IImportDeclaration;

public class ImportContainer
extends SourceRefElement
implements IImportContainer {
    public ImportContainer(AbstractSourceModule parent) {
        super(parent);
    }

    @Override
    protected void closing(Object info) throws ModelException {
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ImportContainer)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public int getElementType() {
        return 12;
    }

    @Override
    public IModelElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner workingCopyOwner) {
        switch (token.charAt(0)) {
            case '!': {
                return this.getHandleUpdatingCountFromMemento(memento, workingCopyOwner);
            }
            case '#': {
                if (memento.hasMoreTokens()) {
                    String importName = memento.nextToken();
                    ModelElement importDecl = (ModelElement)((Object)this.getImport(importName));
                    return importDecl.getHandleFromMemento(memento, workingCopyOwner);
                }
                return this;
            }
        }
        return null;
    }

    @Override
    protected char getHandleMementoDelimiter() {
        return '#';
    }

    @Override
    public IImportDeclaration getImport(String importName) {
        boolean isOnDemand;
        int index = importName.indexOf(".*");
        boolean bl = isOnDemand = index != -1;
        if (isOnDemand) {
            importName = new String(importName.substring(0, index));
        }
        return new ImportDeclaration(this, importName, isOnDemand);
    }

    @Override
    public IModelElement getPrimaryElement(boolean checkOwner) {
        SourceModule cu = (SourceModule)this.parent;
        if (checkOwner && cu.isPrimary()) {
            return this;
        }
        return new ImportContainer(cu);
    }

    @Override
    public ISourceRange getSourceRange() throws ModelException {
        IModelElement[] imports = this.getChildren();
        ISourceRange firstRange = ((ISourceReference)((Object)imports[0])).getSourceRange();
        ISourceRange lastRange = ((ISourceReference)((Object)imports[imports.length - 1])).getSourceRange();
        SourceRange range = new SourceRange(firstRange.getOffset(), lastRange.getOffset() + lastRange.getLength() - firstRange.getOffset());
        return range;
    }

    @Override
    public void printNode(CorePrinter output) {
    }

    public String readableName() {
        return null;
    }

    @Override
    protected void toString(int tab, StringBuffer buffer) {
        Object info = ModelManager.getModelManager().peekAtInfo(this);
        if (info == null || !(info instanceof ModelElementInfo)) {
            return;
        }
        IModelElement[] children = ((ModelElementInfo)info).getChildren();
        int i = 0;
        while (i < children.length) {
            if (i > 0) {
                buffer.append("\n");
            }
            ((ModelElement)children[i]).toString(tab, buffer);
            ++i;
        }
    }

    @Override
    protected void toStringInfo(int tab, StringBuffer buffer, Object info, boolean showResolvedInfo) {
        buffer.append(this.tabString(tab));
        buffer.append("<import container>");
        if (info == null) {
            buffer.append(" (not open)");
        }
    }
}

