/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.core;

import java.io.InputStream;
import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.mod.core.CompletionRequestor;
import org.eclipse.dltk.mod.core.DLTKLanguageManager;
import org.eclipse.dltk.mod.core.IField;
import org.eclipse.dltk.mod.core.IMethod;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IScriptFolder;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.IType;
import org.eclipse.dltk.mod.core.ITypeHierarchy;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.core.WorkingCopyOwner;
import org.eclipse.dltk.mod.core.search.SearchEngine;
import org.eclipse.dltk.mod.internal.core.CreateTypeHierarchyOperation;
import org.eclipse.dltk.mod.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.dltk.mod.internal.core.ModelElement;
import org.eclipse.dltk.mod.internal.core.ModelManager;
import org.eclipse.dltk.mod.internal.core.NamedMember;
import org.eclipse.dltk.mod.internal.core.SourceField;
import org.eclipse.dltk.mod.internal.core.SourceMethod;
import org.eclipse.dltk.mod.internal.core.SourceTypeElementInfo;
import org.eclipse.dltk.mod.internal.core.hierarchy.TypeHierarchy;
import org.eclipse.dltk.mod.internal.core.util.MementoTokenizer;
import org.eclipse.dltk.mod.internal.core.util.Messages;
import org.eclipse.dltk.mod.utils.CorePrinter;

public class SourceType
extends NamedMember
implements IType {
    public SourceType(ModelElement parent, String name) {
        super(parent, name);
    }

    @Override
    public int getElementType() {
        return 7;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof SourceType)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public String[] getSuperClasses() throws ModelException {
        SourceTypeElementInfo info = (SourceTypeElementInfo)this.getElementInfo();
        return info.superclassNames;
    }

    @Override
    public void printNode(CorePrinter output) {
        output.formatPrint("DLTK Source Type:" + this.getElementName());
        output.indent();
        try {
            IModelElement[] modelElements = this.getChildren();
            int i = 0;
            while (i < modelElements.length) {
                IModelElement element = modelElements[i];
                if (element instanceof ModelElement) {
                    ((ModelElement)element).printNode(output);
                } else {
                    output.print("Unknown element:" + element);
                }
                ++i;
            }
        }
        catch (ModelException ex) {
            output.formatPrint(ex.getLocalizedMessage());
        }
        output.dedent();
    }

    @Override
    public IField getField(String fieldName) {
        return new SourceField(this, fieldName);
    }

    @Override
    public IField[] getFields() throws ModelException {
        ArrayList list = this.getChildrenOfType(8);
        IField[] array = new IField[list.size()];
        list.toArray(array);
        return array;
    }

    @Override
    public IType getType(String typeName) {
        return new SourceType(this, typeName);
    }

    @Override
    public IType[] getTypes() throws ModelException {
        ArrayList list = this.getChildrenOfType(7);
        IType[] array = new IType[list.size()];
        list.toArray(array);
        return array;
    }

    @Override
    public IMethod getMethod(String selector) {
        return new SourceMethod(this, selector);
    }

    @Override
    public IMethod[] getMethods() throws ModelException {
        ArrayList list = this.getChildrenOfType(9);
        IMethod[] array = new IMethod[list.size()];
        list.toArray(array);
        return array;
    }

    @Override
    public IModelElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner workingCopyOwner) {
        switch (token.charAt(0)) {
            case '!': {
                return this.getHandleUpdatingCountFromMemento(memento, workingCopyOwner);
            }
            case '^': {
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                String fieldName = memento.nextToken();
                ModelElement field = (ModelElement)((Object)this.getField(fieldName));
                return field.getHandleFromMemento(memento, workingCopyOwner);
            }
            case '~': {
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                String selector = memento.nextToken();
                ArrayList<String> params = new ArrayList<String>();
                block13: while (memento.hasMoreTokens()) {
                    token = memento.nextToken();
                    switch (token.charAt(0)) {
                        case '[': 
                        case ']': {
                            break block13;
                        }
                        case '~': {
                            if (!memento.hasMoreTokens()) {
                                return this;
                            }
                            String param = memento.nextToken();
                            StringBuffer buffer = new StringBuffer();
                            params.add(String.valueOf(buffer.toString()) + param);
                            break;
                        }
                        default: {
                            break block13;
                        }
                    }
                }
                String[] parameters = new String[params.size()];
                params.toArray(parameters);
                ModelElement method = (ModelElement)((Object)this.getMethod(selector));
                switch (token.charAt(0)) {
                    case '@': 
                    case '[': 
                    case ']': {
                        return method.getHandleFromMemento(token, memento, workingCopyOwner);
                    }
                }
                return method;
            }
            case '[': {
                String typeName;
                if (memento.hasMoreTokens()) {
                    typeName = memento.nextToken();
                    char firstChar = typeName.charAt(0);
                    if (firstChar == '^' || firstChar == '~' || firstChar == '[' || firstChar == '!') {
                        token = typeName;
                        typeName = "";
                    } else {
                        token = null;
                    }
                } else {
                    typeName = "";
                    token = null;
                }
                ModelElement type = (ModelElement)((Object)this.getType(typeName));
                if (token == null) {
                    return type.getHandleFromMemento(memento, workingCopyOwner);
                }
                return type.getHandleFromMemento(token, memento, workingCopyOwner);
            }
        }
        return null;
    }

    @Override
    protected char getHandleMementoDelimiter() {
        return '[';
    }

    @Override
    public String getFullyQualifiedName(String enclosingTypeSeparator) {
        try {
            return this.getFullyQualifiedName(enclosingTypeSeparator, false);
        }
        catch (ModelException modelException) {
            return null;
        }
    }

    @Override
    public String getFullyQualifiedName() {
        return this.getFullyQualifiedName("$");
    }

    @Override
    public void codeComplete(char[] snippet, int insertion, int position, char[][] localVariableTypeNames, char[][] localVariableNames, int[] localVariableModifiers, boolean isStatic, CompletionRequestor requestor) throws ModelException {
    }

    @Override
    public void codeComplete(char[] snippet, int insertion, int position, char[][] localVariableTypeNames, char[][] localVariableNames, int[] localVariableModifiers, boolean isStatic, CompletionRequestor requestor, WorkingCopyOwner owner) throws ModelException {
    }

    @Override
    public IScriptFolder getScriptFolder() {
        IModelElement parentElement = this.parent;
        while (parentElement != null) {
            if (parentElement.getElementType() == 4) {
                return (IScriptFolder)parentElement;
            }
            parentElement = parentElement.getParent();
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    @Override
    public String getTypeQualifiedName() {
        return this.getTypeQualifiedName("$");
    }

    @Override
    public String getTypeQualifiedName(String enclosingTypeSeparator) {
        try {
            return this.getTypeQualifiedName(enclosingTypeSeparator, false);
        }
        catch (ModelException modelException) {
            return null;
        }
    }

    @Override
    public IMethod[] findMethods(IMethod method) {
        try {
            return SourceType.findMethods(method, this.getMethods());
        }
        catch (ModelException modelException) {
            return null;
        }
    }

    @Override
    public ITypeHierarchy loadTypeHierachy(InputStream input, IProgressMonitor monitor) throws ModelException {
        return this.loadTypeHierachy(input, DefaultWorkingCopyOwner.PRIMARY, monitor);
    }

    public ITypeHierarchy loadTypeHierachy(InputStream input, WorkingCopyOwner owner, IProgressMonitor monitor) throws ModelException {
        return TypeHierarchy.load(this, input, owner);
    }

    @Override
    public ITypeHierarchy newSupertypeHierarchy(IProgressMonitor monitor) throws ModelException {
        return this.newSupertypeHierarchy(DefaultWorkingCopyOwner.PRIMARY, monitor);
    }

    @Override
    public ITypeHierarchy newSupertypeHierarchy(ISourceModule[] workingCopies, IProgressMonitor monitor) throws ModelException {
        CreateTypeHierarchyOperation op = new CreateTypeHierarchyOperation((IType)this, workingCopies, SearchEngine.createWorkspaceScope(DLTKLanguageManager.getLanguageToolkit(this)), false);
        op.runOperation(monitor);
        return op.getResult();
    }

    @Override
    public ITypeHierarchy newSupertypeHierarchy(WorkingCopyOwner owner, IProgressMonitor monitor) throws ModelException {
        ISourceModule[] workingCopies = ModelManager.getModelManager().getWorkingCopies(owner, true);
        CreateTypeHierarchyOperation op = new CreateTypeHierarchyOperation((IType)this, workingCopies, SearchEngine.createWorkspaceScope(DLTKLanguageManager.getLanguageToolkit(this)), false);
        op.runOperation(monitor);
        return op.getResult();
    }

    @Override
    public ITypeHierarchy newTypeHierarchy(IScriptProject project, IProgressMonitor monitor) throws ModelException {
        return this.newTypeHierarchy(project, DefaultWorkingCopyOwner.PRIMARY, monitor);
    }

    @Override
    public ITypeHierarchy newTypeHierarchy(IScriptProject project, WorkingCopyOwner owner, IProgressMonitor monitor) throws ModelException {
        if (project == null) {
            throw new IllegalArgumentException(Messages.hierarchy_nullProject);
        }
        ISourceModule[] workingCopies = ModelManager.getModelManager().getWorkingCopies(owner, true);
        ISourceModule[] projectWCs = null;
        if (workingCopies != null) {
            int length = workingCopies.length;
            projectWCs = new ISourceModule[length];
            int index = 0;
            int i = 0;
            while (i < length) {
                ISourceModule wc = workingCopies[i];
                if (project.equals(wc.getScriptProject())) {
                    projectWCs[index++] = wc;
                }
                ++i;
            }
            if (index != length) {
                ISourceModule[] iSourceModuleArray = projectWCs;
                projectWCs = new ISourceModule[index];
                System.arraycopy(iSourceModuleArray, 0, projectWCs, 0, index);
            }
        }
        CreateTypeHierarchyOperation op = new CreateTypeHierarchyOperation((IType)this, projectWCs, project, true);
        op.runOperation(monitor);
        return op.getResult();
    }

    @Override
    public ITypeHierarchy newTypeHierarchy(IProgressMonitor monitor) throws ModelException {
        CreateTypeHierarchyOperation op = new CreateTypeHierarchyOperation((IType)this, null, SearchEngine.createWorkspaceScope(DLTKLanguageManager.getLanguageToolkit(this)), true);
        op.runOperation(monitor);
        return op.getResult();
    }

    @Override
    public ITypeHierarchy newTypeHierarchy(ISourceModule[] workingCopies, IProgressMonitor monitor) throws ModelException {
        CreateTypeHierarchyOperation op = new CreateTypeHierarchyOperation((IType)this, workingCopies, SearchEngine.createWorkspaceScope(DLTKLanguageManager.getLanguageToolkit(this)), true);
        op.runOperation(monitor);
        return op.getResult();
    }

    @Override
    public ITypeHierarchy newTypeHierarchy(WorkingCopyOwner owner, IProgressMonitor monitor) throws ModelException {
        ISourceModule[] workingCopies = ModelManager.getModelManager().getWorkingCopies(owner, true);
        CreateTypeHierarchyOperation op = new CreateTypeHierarchyOperation((IType)this, workingCopies, SearchEngine.createWorkspaceScope(DLTKLanguageManager.getLanguageToolkit(this)), true);
        op.runOperation(monitor);
        return op.getResult();
    }
}

