/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.debug.ui.actions;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.ui.InspectPopupDialog;
import org.eclipse.dltk.mod.debug.core.eval.EvaluatedScriptExpression;
import org.eclipse.dltk.mod.debug.core.eval.IScriptEvaluationResult;
import org.eclipse.dltk.mod.debug.ui.DLTKDebugUIPlugin;
import org.eclipse.dltk.mod.internal.debug.ui.actions.ScriptInspectAction;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;

public class PopupScriptInspectAction
extends ScriptInspectAction {
    private static final String INSPECT_COMMAND_ID = "org.eclipse.dltk.mod.debug.ui.commands.ScriptInspect";

    private void showPopup(StyledText textWidget, IExpression expression) {
        ScriptInspectPopupDialog displayPopup = new ScriptInspectPopupDialog(this.getShell(), PopupScriptInspectAction.getPopupAnchor(textWidget), INSPECT_COMMAND_ID, expression);
        displayPopup.open();
    }

    @Override
    protected void displayResult(IScriptEvaluationResult result) {
        IWorkbenchPart part = this.getPart();
        final StyledText styledText = PopupScriptInspectAction.getStyledText(part);
        if (styledText != null) {
            EvaluatedScriptExpression expression = new EvaluatedScriptExpression(result);
            DLTKDebugUIPlugin.getStandardDisplay().asyncExec(new Runnable((IExpression)expression){
                private final /* synthetic */ IExpression val$expression;
                {
                    this.val$expression = iExpression;
                }

                @Override
                public void run() {
                    PopupScriptInspectAction.this.showPopup(styledText, this.val$expression);
                }
            });
        }
        this.evaluationCleanup();
    }

    private class ScriptInspectPopupDialog
    extends InspectPopupDialog {
        private IHandler fCloseHandler;
        private IHandlerActivation fActivation;
        private IHandlerService fHandlerService;

        public ScriptInspectPopupDialog(Shell shell, Point anchor, String commandId, IExpression expression) {
            super(shell, anchor, commandId, expression);
            this.fCloseHandler = new AbstractHandler(){

                public Object execute(ExecutionEvent event) throws ExecutionException {
                    ScriptInspectPopupDialog.this.persist();
                    ScriptInspectPopupDialog.this.close();
                    return null;
                }
            };
        }

        public int open() {
            int result = super.open();
            IWorkbench workbench = PlatformUI.getWorkbench();
            String JDTCommandId = "org.eclipse.jdt.debug.ui.commands.Inspect";
            ICommandService commandService = (ICommandService)workbench.getAdapter(ICommandService.class);
            if (commandService.getCommand(JDTCommandId) != null) {
                this.fHandlerService = (IHandlerService)workbench.getAdapter(IHandlerService.class);
                this.fActivation = this.fHandlerService.activateHandler(JDTCommandId, this.fCloseHandler);
            }
            return result;
        }

        public boolean close() {
            if (this.fActivation != null && this.fHandlerService != null) {
                this.fHandlerService.deactivateHandler(this.fActivation);
            }
            return super.close();
        }
    }
}

