/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.debug.ui.interpreters;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.dltk.mod.core.IBuildpathEntry;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.core.environment.EnvironmentManager;
import org.eclipse.dltk.mod.debug.ui.ScriptDebugImages;
import org.eclipse.dltk.mod.internal.debug.ui.interpreters.AbstractInterpreterComboBlock;
import org.eclipse.dltk.mod.internal.debug.ui.interpreters.BuildInterpreterDescriptor;
import org.eclipse.dltk.mod.internal.debug.ui.interpreters.InterpretersMessages;
import org.eclipse.dltk.mod.internal.ui.wizards.IBuildpathContainerPage;
import org.eclipse.dltk.mod.ui.wizards.IBuildpathContainerPageExtension;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public abstract class AbstractInterpreterContainerWizardPage
extends WizardPage
implements IBuildpathContainerPage,
IBuildpathContainerPageExtension {
    private IBuildpathEntry fSelection;
    private AbstractInterpreterComboBlock fInterpreterEnvironmentBlock;
    private IScriptProject scriptProject;
    private IBuildpathEntry[] currentEntries;

    public AbstractInterpreterContainerWizardPage() {
        super(InterpretersMessages.InterpreterContainerWizardPage_Interpreter_System_Library_1);
    }

    public boolean finish() {
        IStatus status = this.fInterpreterEnvironmentBlock.getStatus();
        if (!status.isOK()) {
            return false;
        }
        this.fSelection = this.fInterpreterEnvironmentBlock.getEntry();
        return true;
    }

    public IBuildpathEntry getSelection() {
        return this.fSelection;
    }

    public void setSelection(IBuildpathEntry containerEntry) {
        this.fSelection = containerEntry;
        this.initializeFromSelection();
    }

    protected void initializeFromSelection() {
        if (this.getControl() != null) {
            if (this.fSelection == null) {
                this.fInterpreterEnvironmentBlock.setUseDefaultInterpreter();
            } else {
                this.fInterpreterEnvironmentBlock.setPath(this.fSelection.getPath());
            }
            IStatus status = this.fInterpreterEnvironmentBlock.getStatus();
            if (!status.isOK()) {
                this.setErrorMessage(status.getMessage());
                try {
                    Boolean b;
                    IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler(status);
                    if (handler != null && (b = (Boolean)handler.handleStatus(status, (Object)this)).booleanValue()) {
                        this.fInterpreterEnvironmentBlock.refreshInterpreters();
                    }
                }
                catch (CoreException coreException) {}
            }
        }
    }

    protected abstract AbstractInterpreterComboBlock getInterpreterBlock();

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        composite.setFont(parent.getFont());
        this.fInterpreterEnvironmentBlock = this.getInterpreterBlock();
        this.fInterpreterEnvironmentBlock.setEnvironment(EnvironmentManager.getEnvironment((IModelElement)this.getScriptProject()));
        String currentLanguageNature = this.fInterpreterEnvironmentBlock.getCurrentLanguageNature();
        this.fInterpreterEnvironmentBlock.setDefaultInterpreterDescriptor(new BuildInterpreterDescriptor(currentLanguageNature, EnvironmentManager.getEnvironment((IModelElement)this.getScriptProject()).getId()));
        this.fInterpreterEnvironmentBlock.setTitle(InterpretersMessages.InterpreterContainerWizardPage_3);
        this.fInterpreterEnvironmentBlock.createControl(composite);
        gd = new GridData(768);
        this.fInterpreterEnvironmentBlock.getControl().setLayoutData((Object)gd);
        this.setControl((Control)composite);
        this.fInterpreterEnvironmentBlock.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                IStatus status = AbstractInterpreterContainerWizardPage.this.fInterpreterEnvironmentBlock.getStatus();
                if (status.isOK()) {
                    AbstractInterpreterContainerWizardPage.this.setErrorMessage(null);
                } else {
                    AbstractInterpreterContainerWizardPage.this.setErrorMessage(status.getMessage());
                }
            }
        });
        this.setTitle(InterpretersMessages.InterpreterContainerWizardPage_Interpreter_System_Library_1);
        this.setMessage(InterpretersMessages.InterpreterContainerWizardPage_Select_the_Interpreter_used_to_build_this_project__4);
        this.initializeFromSelection();
    }

    public Image getImage() {
        return ScriptDebugImages.get("IMG_WIZBAN_LIBRARY");
    }

    public void initialize(IScriptProject project, IBuildpathEntry[] currentEntries) {
        this.scriptProject = project;
        this.currentEntries = currentEntries;
    }

    public IScriptProject getScriptProject() {
        return this.scriptProject;
    }

    public IBuildpathEntry[] getCurrentEntries() {
        return this.currentEntries;
    }
}

