/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.dbgp.internal.commands;

import java.net.URI;
import java.util.Map;
import org.eclipse.dltk.mod.dbgp.IDbgpFeature;
import org.eclipse.dltk.mod.dbgp.IDbgpProperty;
import org.eclipse.dltk.mod.dbgp.IDbgpStackLevel;
import org.eclipse.dltk.mod.dbgp.IDbgpStatus;
import org.eclipse.dltk.mod.dbgp.breakpoints.DbgpBreakpointConfig;
import org.eclipse.dltk.mod.dbgp.breakpoints.IDbgpBreakpoint;
import org.eclipse.dltk.mod.dbgp.commands.IDbgpBreakpointCommands;
import org.eclipse.dltk.mod.dbgp.commands.IDbgpContextCommands;
import org.eclipse.dltk.mod.dbgp.commands.IDbgpContinuationCommands;
import org.eclipse.dltk.mod.dbgp.commands.IDbgpCoreCommands;
import org.eclipse.dltk.mod.dbgp.commands.IDbgpDataTypeCommands;
import org.eclipse.dltk.mod.dbgp.commands.IDbgpFeatureCommands;
import org.eclipse.dltk.mod.dbgp.commands.IDbgpPropertyCommands;
import org.eclipse.dltk.mod.dbgp.commands.IDbgpSourceCommands;
import org.eclipse.dltk.mod.dbgp.commands.IDbgpStatckCommands;
import org.eclipse.dltk.mod.dbgp.commands.IDbgpStatusCommands;
import org.eclipse.dltk.mod.dbgp.commands.IDbgpStreamCommands;
import org.eclipse.dltk.mod.dbgp.exceptions.DbgpException;
import org.eclipse.dltk.mod.dbgp.internal.commands.DbgpBreakpointCommands;
import org.eclipse.dltk.mod.dbgp.internal.commands.DbgpContextCommands;
import org.eclipse.dltk.mod.dbgp.internal.commands.DbgpContinuationCommands;
import org.eclipse.dltk.mod.dbgp.internal.commands.DbgpDataTypeCommands;
import org.eclipse.dltk.mod.dbgp.internal.commands.DbgpFeatureCommands;
import org.eclipse.dltk.mod.dbgp.internal.commands.DbgpPropertyCommands;
import org.eclipse.dltk.mod.dbgp.internal.commands.DbgpSourceCommands;
import org.eclipse.dltk.mod.dbgp.internal.commands.DbgpStackCommands;
import org.eclipse.dltk.mod.dbgp.internal.commands.DbgpStatusCommands;
import org.eclipse.dltk.mod.dbgp.internal.commands.DbgpStreamCommands;
import org.eclipse.dltk.mod.dbgp.internal.commands.IDbgpCommunicator;

public class DbgpCoreCommands
implements IDbgpCoreCommands {
    private final IDbgpFeatureCommands featureCommands;
    private final IDbgpStatusCommands statusCommands;
    private final IDbgpBreakpointCommands breakpointCommands;
    private final IDbgpSourceCommands sourceCommands;
    private final IDbgpContextCommands contextCommands;
    private final IDbgpStatckCommands stackCommands;
    private final IDbgpContinuationCommands continuationCommands;
    private final IDbgpStreamCommands streamCommands;
    private final IDbgpDataTypeCommands dataTypeCommands;
    private final IDbgpPropertyCommands propertyCommands;

    public DbgpCoreCommands(IDbgpCommunicator communicator) {
        this.featureCommands = new DbgpFeatureCommands(communicator);
        this.statusCommands = new DbgpStatusCommands(communicator);
        this.breakpointCommands = new DbgpBreakpointCommands(communicator);
        this.sourceCommands = new DbgpSourceCommands(communicator);
        this.contextCommands = new DbgpContextCommands(communicator);
        this.stackCommands = new DbgpStackCommands(communicator);
        this.continuationCommands = new DbgpContinuationCommands(communicator);
        this.streamCommands = new DbgpStreamCommands(communicator);
        this.propertyCommands = new DbgpPropertyCommands(communicator);
        this.dataTypeCommands = new DbgpDataTypeCommands(communicator);
    }

    @Override
    public IDbgpFeature getFeature(String featureName) throws DbgpException {
        return this.featureCommands.getFeature(featureName);
    }

    @Override
    public boolean setFeature(String featureName, String featureValue) throws DbgpException {
        return this.featureCommands.setFeature(featureName, featureValue);
    }

    @Override
    public IDbgpBreakpoint getBreakpoint(String id) throws DbgpException {
        return this.breakpointCommands.getBreakpoint(id);
    }

    @Override
    public IDbgpBreakpoint[] getBreakpoints() throws DbgpException {
        return this.breakpointCommands.getBreakpoints();
    }

    @Override
    public void removeBreakpoint(String id) throws DbgpException {
        this.breakpointCommands.removeBreakpoint(id);
    }

    @Override
    public String setCallBreakpoint(URI uri, String function, DbgpBreakpointConfig info) throws DbgpException {
        return this.breakpointCommands.setCallBreakpoint(uri, function, info);
    }

    @Override
    public String setConditionalBreakpoint(URI uri, DbgpBreakpointConfig info) throws DbgpException {
        return this.breakpointCommands.setConditionalBreakpoint(uri, info);
    }

    @Override
    public String setConditionalBreakpoint(URI uri, int lineNumber, DbgpBreakpointConfig info) throws DbgpException {
        return this.breakpointCommands.setConditionalBreakpoint(uri, lineNumber, info);
    }

    @Override
    public String setExceptionBreakpoint(String exception, DbgpBreakpointConfig info) throws DbgpException {
        return this.breakpointCommands.setExceptionBreakpoint(exception, info);
    }

    @Override
    public String setLineBreakpoint(URI uri, int lineNumber, DbgpBreakpointConfig info) throws DbgpException {
        return this.breakpointCommands.setLineBreakpoint(uri, lineNumber, info);
    }

    @Override
    public String setReturnBreakpoint(URI uri, String function, DbgpBreakpointConfig info) throws DbgpException {
        return this.breakpointCommands.setReturnBreakpoint(uri, function, info);
    }

    @Override
    public String setWatchBreakpoint(URI uri, int line, DbgpBreakpointConfig info) throws DbgpException {
        return this.breakpointCommands.setWatchBreakpoint(uri, line, info);
    }

    @Override
    public void updateBreakpoint(String id, DbgpBreakpointConfig config) throws DbgpException {
        this.breakpointCommands.updateBreakpoint(id, config);
    }

    @Override
    public IDbgpStatus detach() throws DbgpException {
        return this.continuationCommands.detach();
    }

    @Override
    public IDbgpStatus run() throws DbgpException {
        return this.continuationCommands.run();
    }

    @Override
    public IDbgpStatus stepInto() throws DbgpException {
        return this.continuationCommands.stepInto();
    }

    @Override
    public IDbgpStatus stepOut() throws DbgpException {
        return this.continuationCommands.stepOut();
    }

    @Override
    public IDbgpStatus stepOver() throws DbgpException {
        return this.continuationCommands.stepOver();
    }

    @Override
    public IDbgpStatus stop() throws DbgpException {
        return this.continuationCommands.stop();
    }

    @Override
    public Map getTypeMap() throws DbgpException {
        return this.dataTypeCommands.getTypeMap();
    }

    @Override
    public String getSource(URI uri) throws DbgpException {
        return this.sourceCommands.getSource(uri);
    }

    @Override
    public String getSource(URI uri, int beginLine) throws DbgpException {
        return this.sourceCommands.getSource(uri, beginLine);
    }

    @Override
    public String getSource(URI uri, int beginLine, int endLine) throws DbgpException {
        return this.sourceCommands.getSource(uri, beginLine, endLine);
    }

    @Override
    public IDbgpStatus getStatus() throws DbgpException {
        return this.statusCommands.getStatus();
    }

    @Override
    public IDbgpStackLevel getStackLevel(int stackDepth) throws DbgpException {
        return this.stackCommands.getStackLevel(stackDepth);
    }

    @Override
    public IDbgpStackLevel[] getStackLevels() throws DbgpException {
        return this.stackCommands.getStackLevels();
    }

    @Override
    public int getStackDepth() throws DbgpException {
        return this.stackCommands.getStackDepth();
    }

    @Override
    public Map getContextNames(int stackDepth) throws DbgpException {
        return this.contextCommands.getContextNames(stackDepth);
    }

    @Override
    public IDbgpProperty[] getContextProperties(int stackDepth) throws DbgpException {
        return this.contextCommands.getContextProperties(stackDepth);
    }

    @Override
    public IDbgpProperty[] getContextProperties(int stackDepth, int contextId) throws DbgpException {
        return this.contextCommands.getContextProperties(stackDepth, contextId);
    }

    @Override
    public boolean configureStderr(int value) throws DbgpException {
        return this.streamCommands.configureStderr(value);
    }

    @Override
    public boolean configureStdout(int value) throws DbgpException {
        return this.streamCommands.configureStdout(value);
    }

    @Override
    public IDbgpProperty getProperty(String name) throws DbgpException {
        return this.propertyCommands.getProperty(name);
    }

    @Override
    public IDbgpProperty getProperty(String name, int stackDepth) throws DbgpException {
        return this.propertyCommands.getProperty(name, stackDepth);
    }

    @Override
    public IDbgpProperty getProperty(String name, int stackDepth, int contextId) throws DbgpException {
        return this.propertyCommands.getProperty(name, stackDepth, contextId);
    }

    @Override
    public boolean setProperty(IDbgpProperty property) throws DbgpException {
        return this.propertyCommands.setProperty(property);
    }

    @Override
    public boolean setProperty(String name, int stackDepth, String value) throws DbgpException {
        return this.propertyCommands.setProperty(name, stackDepth, value);
    }

    @Override
    public IDbgpProperty getPropertyByKey(String name, String key) throws DbgpException {
        return this.propertyCommands.getPropertyByKey(name, key);
    }

    @Override
    public IDbgpProperty getProperty(int page, String name, int stackDepth) throws DbgpException {
        return this.propertyCommands.getProperty(page, name, stackDepth);
    }
}

