/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.launching;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.dltk.mod.core.IBuildpathEntry;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.launching.IInterpreterInstall;
import org.eclipse.dltk.mod.launching.IRuntimeBuildpathEntry;
import org.eclipse.dltk.mod.launching.IRuntimeBuildpathEntryResolver;
import org.eclipse.dltk.mod.launching.IRuntimeBuildpathEntryResolver2;

public class RuntimeBuildpathEntryResolver
implements IRuntimeBuildpathEntryResolver2 {
    private IConfigurationElement fConfigurationElement;
    private IRuntimeBuildpathEntryResolver fDelegate;

    public RuntimeBuildpathEntryResolver(IConfigurationElement element) {
        this.fConfigurationElement = element;
    }

    @Override
    public IRuntimeBuildpathEntry[] resolveRuntimeBuildpathEntry(IRuntimeBuildpathEntry entry, ILaunchConfiguration configuration) throws CoreException {
        return this.getResolver().resolveRuntimeBuildpathEntry(entry, configuration);
    }

    protected IRuntimeBuildpathEntryResolver getResolver() throws CoreException {
        if (this.fDelegate == null) {
            this.fDelegate = (IRuntimeBuildpathEntryResolver)this.fConfigurationElement.createExecutableExtension("class");
        }
        return this.fDelegate;
    }

    public String getContainerId() {
        return this.fConfigurationElement.getAttribute("container");
    }

    public String getRuntimeBuildpathEntryId() {
        return this.fConfigurationElement.getAttribute("runtimeBuildpathEntryId");
    }

    @Override
    public IInterpreterInstall resolveInterpreterInstall(String lang, String environment, IBuildpathEntry entry) throws CoreException {
        return this.getResolver().resolveInterpreterInstall(lang, environment, entry);
    }

    @Override
    public IRuntimeBuildpathEntry[] resolveRuntimeBuildpathEntry(IRuntimeBuildpathEntry entry, IScriptProject project) throws CoreException {
        return this.getResolver().resolveRuntimeBuildpathEntry(entry, project);
    }

    @Override
    public boolean isInterpreterInstallReference(String lang, String environment, IBuildpathEntry entry) {
        try {
            IRuntimeBuildpathEntryResolver resolver = this.getResolver();
            if (resolver instanceof IRuntimeBuildpathEntryResolver2) {
                IRuntimeBuildpathEntryResolver2 resolver2 = (IRuntimeBuildpathEntryResolver2)resolver;
                return resolver2.isInterpreterInstallReference(lang, environment, entry);
            }
            return resolver.resolveInterpreterInstall(lang, environment, entry) != null;
        }
        catch (CoreException coreException) {
            return false;
        }
    }
}

