/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.launching.sourcelookup;

import java.net.URI;
import java.text.MessageFormat;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupParticipant;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.WorkingCopyOwner;
import org.eclipse.dltk.mod.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.dltk.mod.internal.core.ScriptProject;
import org.eclipse.dltk.mod.internal.debug.core.model.ScriptStackFrame;
import org.eclipse.dltk.mod.internal.launching.LaunchConfigurationUtils;
import org.eclipse.dltk.mod.launching.sourcelookup.DBGPSourceModule;
import org.eclipse.dltk.mod.launching.sourcelookup.Messages;

public class DBGPSourceLookupParticipant
extends AbstractSourceLookupParticipant {
    public String getSourceName(Object object) throws CoreException {
        if (!(object instanceof ScriptStackFrame)) {
            return null;
        }
        ScriptStackFrame frame = (ScriptStackFrame)object;
        URI uri = frame.getFileName();
        if ("dbgp".equals(uri.getScheme())) {
            return MessageFormat.format(Messages.DBGPSourceLookupParticipant_debugResource, uri.getPath());
        }
        return uri.toString();
    }

    public Object[] findSourceElements(Object object) throws CoreException {
        if (object instanceof ScriptStackFrame) {
            ScriptStackFrame frame = (ScriptStackFrame)object;
            ILaunchConfiguration launchConfiguration = this.getDirector().getLaunchConfiguration();
            IProject project = LaunchConfigurationUtils.getProject(launchConfiguration);
            ScriptProject scriptProject = (ScriptProject)DLTKCore.create((IProject)project);
            URI uri = frame.getFileName();
            if (!"dbgp".equals(uri.getScheme())) {
                return null;
            }
            return new Object[]{new DBGPSourceModule(scriptProject, frame.getFileName().getPath(), (WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY, frame)};
        }
        return new Object[0];
    }
}

