/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.ui.callhierarchy;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.mod.core.IMember;
import org.eclipse.dltk.mod.core.IMethod;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.ISourceRange;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.internal.corext.callhierarchy.CallHierarchy;
import org.eclipse.dltk.mod.internal.corext.callhierarchy.CallLocation;
import org.eclipse.dltk.mod.internal.corext.callhierarchy.MethodWrapper;
import org.eclipse.dltk.mod.internal.corext.util.Messages;
import org.eclipse.dltk.mod.internal.ui.actions.OpenActionUtil;
import org.eclipse.dltk.mod.internal.ui.callhierarchy.CallHierarchyMessages;
import org.eclipse.dltk.mod.internal.ui.callhierarchy.CallHierarchyViewPart;
import org.eclipse.dltk.mod.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.mod.ui.DLTKUIPlugin;
import org.eclipse.dltk.mod.ui.util.ExceptionHandler;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.texteditor.ITextEditor;

public class CallHierarchyUI {
    private static final int DEFAULT_MAX_CALL_DEPTH = 10;
    private static final String PREF_MAX_CALL_DEPTH = "PREF_MAX_CALL_DEPTH";
    private static CallHierarchyUI fgInstance;

    private CallHierarchyUI() {
    }

    public static CallHierarchyUI getDefault() {
        if (fgInstance == null) {
            fgInstance = new CallHierarchyUI();
        }
        return fgInstance;
    }

    public int getMaxCallDepth() {
        IPreferenceStore settings = DLTKUIPlugin.getDefault().getPreferenceStore();
        int maxCallDepth = settings.getInt(PREF_MAX_CALL_DEPTH);
        if (maxCallDepth < 1 || maxCallDepth > 99) {
            maxCallDepth = 10;
        }
        return maxCallDepth;
    }

    public void setMaxCallDepth(int maxCallDepth) {
        IPreferenceStore settings = DLTKUIPlugin.getDefault().getPreferenceStore();
        settings.setValue(PREF_MAX_CALL_DEPTH, maxCallDepth);
    }

    public static void jumpToMember(IModelElement element) {
        if (element != null) {
            try {
                IEditorPart methodEditor = EditorUtility.openInEditor(element, true);
                EditorUtility.revealInEditor(methodEditor, element);
            }
            catch (ModelException e) {
                DLTKUIPlugin.log(e);
            }
            catch (PartInitException e) {
                DLTKUIPlugin.log(e);
            }
        }
    }

    public static void jumpToLocation(CallLocation callLocation) {
        try {
            IEditorPart methodEditor = EditorUtility.openInEditor(callLocation.getMember(), false);
            if (methodEditor instanceof ITextEditor) {
                ITextEditor editor = (ITextEditor)methodEditor;
                editor.selectAndReveal(callLocation.getStart(), callLocation.getEnd() - callLocation.getStart());
            }
        }
        catch (ModelException e) {
            DLTKUIPlugin.log(e);
        }
        catch (PartInitException e) {
            DLTKUIPlugin.log(e);
        }
    }

    public static boolean openInEditor(Object element, Shell shell, String title) {
        int selectionLength;
        int selectionStart;
        IModelElement enclosingMember;
        CallLocation callLocation;
        block9: {
            block10: {
                ISourceRange selectionRange;
                block11: {
                    callLocation = CallHierarchy.getCallLocation(element);
                    if (callLocation != null) {
                        enclosingMember = callLocation.getMember();
                        selectionStart = callLocation.getStart();
                        selectionLength = callLocation.getEnd() - selectionStart;
                        break block9;
                    }
                    if (!(element instanceof MethodWrapper)) break block10;
                    enclosingMember = ((MethodWrapper)((Object)element)).getMember();
                    selectionRange = null;
                    if (enclosingMember instanceof IMember) {
                        selectionRange = ((IMember)enclosingMember).getNameRange();
                    }
                    if (selectionRange == null && enclosingMember instanceof IMember) {
                        selectionRange = ((IMember)enclosingMember).getSourceRange();
                    }
                    if (selectionRange != null) break block11;
                    return true;
                }
                selectionStart = selectionRange.getOffset();
                selectionLength = selectionRange.getLength();
                break block9;
            }
            return true;
        }
        try {
            boolean activateOnOpen = OpenStrategy.activateOnOpen();
            IEditorPart methodEditor = EditorUtility.openInEditor(enclosingMember, activateOnOpen);
            if (methodEditor instanceof ITextEditor) {
                ITextEditor editor = (ITextEditor)methodEditor;
                editor.selectAndReveal(selectionStart, selectionLength);
            }
            return true;
        }
        catch (ModelException e) {
            DLTKUIPlugin.log((IStatus)new Status(4, DLTKUIPlugin.getPluginId(), 10001, CallHierarchyMessages.CallHierarchyUI_open_in_editor_error_message, (Throwable)e));
            ErrorDialog.openError((Shell)shell, (String)title, (String)CallHierarchyMessages.CallHierarchyUI_open_in_editor_error_message, (IStatus)e.getStatus());
            return false;
        }
        catch (PartInitException x) {
            String name = callLocation != null ? callLocation.getCalledMember().getElementName() : (element instanceof MethodWrapper ? ((MethodWrapper)((Object)element)).getName() : "");
            MessageDialog.openError((Shell)shell, (String)title, (String)Messages.format(CallHierarchyMessages.CallHierarchyUI_open_in_editor_error_messageArgs, new String[]{name, x.getMessage()}));
            return false;
        }
    }

    public static IEditorPart isOpenInEditor(Object elem) {
        IModelElement modelElement = null;
        if (elem instanceof MethodWrapper) {
            modelElement = ((MethodWrapper)((Object)elem)).getMember();
        } else if (elem instanceof CallLocation) {
            modelElement = ((CallLocation)elem).getCalledMember();
        }
        if (modelElement != null) {
            return EditorUtility.isOpenInEditor(modelElement);
        }
        return null;
    }

    public static IModelElement[] getCandidates(Object input) {
        if (!(input instanceof IModelElement)) {
            return null;
        }
        IModelElement elem = (IModelElement)input;
        if (elem.getElementType() == 9) {
            return new IModelElement[]{elem};
        }
        return null;
    }

    public static CallHierarchyViewPart open(IModelElement[] candidates, IWorkbenchWindow window, String partID) {
        Assert.isTrue((candidates != null && candidates.length != 0 ? 1 : 0) != 0);
        IModelElement input = null;
        if (candidates.length > 1) {
            String title = CallHierarchyMessages.CallHierarchyUI_selectionDialog_title;
            String message = CallHierarchyMessages.CallHierarchyUI_selectionDialog_message;
            input = OpenActionUtil.selectModelElement(candidates, window.getShell(), title, message);
        } else {
            input = candidates[0];
        }
        if (input == null) {
            return null;
        }
        return CallHierarchyUI.openInViewPart(window, input, partID);
    }

    private static void openEditor(Object input, boolean activate) throws PartInitException, ModelException {
        IEditorPart part = EditorUtility.openInEditor(input, activate);
        if (input instanceof IModelElement) {
            EditorUtility.revealInEditor(part, (IModelElement)input);
        }
    }

    private static CallHierarchyViewPart openInViewPart(IWorkbenchWindow window, IModelElement input, String partID) {
        IWorkbenchPage page = window.getActivePage();
        try {
            CallHierarchyViewPart result = (CallHierarchyViewPart)page.showView(partID);
            result.setMethod((IMethod)input);
            CallHierarchyUI.openEditor(input, false);
            return result;
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, window.getShell(), CallHierarchyMessages.CallHierarchyUI_error_open_view, e.getMessage());
            return null;
        }
    }

    static ISelection convertSelection(ISelection selection) {
        if (selection.isEmpty()) {
            return selection;
        }
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            ArrayList<Object> modelElements = new ArrayList<Object>();
            for (Object element : structuredSelection) {
                IModelElement member;
                if (element instanceof MethodWrapper) {
                    member = ((MethodWrapper)((Object)element)).getMember();
                    if (member == null) continue;
                    modelElements.add(member);
                    continue;
                }
                if (element instanceof IMember) {
                    modelElements.add(element);
                    continue;
                }
                if (!(element instanceof CallLocation)) continue;
                member = ((CallLocation)element).getMember();
                modelElements.add(member);
            }
            return new StructuredSelection(modelElements);
        }
        return StructuredSelection.EMPTY;
    }
}

