/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.ui.editor;

import java.io.File;
import java.io.IOException;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.internal.ui.JarEntryFile;
import org.eclipse.dltk.mod.internal.ui.editor.IModelElementFileAdivsor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class ExternalFileEditorInput
implements IEditorInput,
IStorageEditorInput {
    private File fFile;
    private static IModelElementFileAdivsor fAdvisor;
    private IModelElement fElement;
    private WorkbenchAdapter fWorkbenchAdapter = new WorkbenchAdapter();
    private IStorage m_storage;

    public File getFile() {
        if (this.fFile != null) {
            return this.fFile;
        }
        if (fAdvisor != null) {
            this.fFile = fAdvisor.getFile(this.fElement);
        }
        return this.fFile;
    }

    public ExternalFileEditorInput(File file) {
        this.fFile = file;
        this.fWorkbenchAdapter = new WorkbenchAdapter();
    }

    public ExternalFileEditorInput(IModelElement element) {
        this.fElement = element;
        this.fWorkbenchAdapter = new WorkbenchAdapter();
    }

    public boolean exists() {
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        if (this.fFile != null) {
            return this.fFile.getName();
        }
        if (this.fElement != null) {
            return this.fElement.getElementName();
        }
        if (fAdvisor != null) {
            this.fFile = fAdvisor.getFile(this.fElement);
        }
        if (this.fFile != null) {
            return this.fFile.getName();
        }
        return "";
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return this.getFile().getAbsolutePath();
    }

    public Object getAdapter(Class adapter) {
        if (ILocationProvider.class.equals((Object)adapter)) {
            return null;
        }
        if (IWorkbenchAdapter.class.equals((Object)adapter)) {
            return this.fWorkbenchAdapter;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public boolean equals(Object o) {
        IPathEditorInput input;
        IFile file;
        if (o == this) {
            return true;
        }
        if (o instanceof ExternalFileEditorInput) {
            ExternalFileEditorInput input2 = (ExternalFileEditorInput)o;
            return this.getFile().equals(input2.getFile());
        }
        if (o instanceof IPathEditorInput && (file = (IFile)(input = (IPathEditorInput)o).getAdapter(IFile.class)) != null && !file.exists()) {
            return false;
        }
        return false;
    }

    public int hashCode() {
        return this.getFile().hashCode();
    }

    public static void registryAdvisor(IModelElementFileAdivsor advisor) {
        fAdvisor = advisor;
    }

    public IModelElement getModelElement() {
        return this.fElement;
    }

    public IStorage getStorage() {
        if (this.m_storage == null) {
            this.m_storage = this.calculateStorage();
        }
        return this.m_storage;
    }

    private IStorage calculateStorage() {
        File file = this.getFile();
        if (file != null) {
            String[] strs;
            if (file.exists()) {
                return new LocalFileStorage(file);
            }
            String path = file.getPath();
            if (path.indexOf("!") > -1 && (strs = path.split("!")).length == 2) {
                try {
                    File jarFile = new File(strs[0]);
                    ZipFile zipFile = new ZipFile(jarFile);
                    final String typeName = strs[1].replace("\\", "/");
                    return new JarEntryFile(zipFile, typeName){

                        @Override
                        public String getName() {
                            return typeName;
                        }
                    };
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    private class WorkbenchAdapter
    implements IWorkbenchAdapter {
        private WorkbenchAdapter() {
        }

        public Object[] getChildren(Object o) {
            return null;
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            return null;
        }

        public String getLabel(Object o) {
            return ((ExternalFileEditorInput)o).getName();
        }

        public Object getParent(Object o) {
            return null;
        }
    }
}

