/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.ui.refactoring.actions;

import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.internal.ui.refactoring.RefactoringSaveHelper;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.swt.widgets.Shell;

public class RefactoringStarter {
    private RefactoringSaveHelper fSaveHelper = new RefactoringSaveHelper();
    private RefactoringStatus fStatus;

    public void activate(Refactoring refactoring, RefactoringWizard wizard, Shell parent, String dialogTitle, boolean mustSaveEditors) throws ModelException {
        if (!this.canActivate(mustSaveEditors, parent)) {
            return;
        }
        try {
            RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation(wizard);
            int result = op.run(parent, dialogTitle);
            this.fStatus = op.getInitialConditionCheckingStatus();
            if (result == 1 || result == 1025) {
                this.fSaveHelper.triggerBuild();
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    public RefactoringStatus getInitialConditionCheckingStatus() {
        return this.fStatus;
    }

    private boolean canActivate(boolean mustSaveEditors, Shell shell) {
        return !mustSaveEditors || this.fSaveHelper.saveEditors(shell);
    }
}

