/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.ui.text;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.internal.ui.text.IProblemRequestorExtension;
import org.eclipse.dltk.mod.internal.ui.text.IScriptReconcilingListener;
import org.eclipse.dltk.mod.ui.DLTKUIPlugin;
import org.eclipse.dltk.mod.ui.IWorkingCopyManager;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class ScriptReconcilingStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension {
    private ITextEditor fEditor;
    private IWorkingCopyManager fManager;
    private IDocumentProvider fDocumentProvider;
    private IProgressMonitor fProgressMonitor;
    private IScriptReconcilingListener fScriptReconcilingListener;
    private boolean fIsScriptReconcilingListener;
    private boolean fNotify = true;

    public ScriptReconcilingStrategy(ITextEditor editor) {
        this.fEditor = editor;
        this.fManager = DLTKUIPlugin.getDefault().getWorkingCopyManager();
        this.fDocumentProvider = DLTKUIPlugin.getDefault().getSourceModuleDocumentProvider();
        this.fIsScriptReconcilingListener = this.fEditor instanceof IScriptReconcilingListener;
        if (this.fIsScriptReconcilingListener) {
            this.fScriptReconcilingListener = (IScriptReconcilingListener)this.fEditor;
        }
    }

    private IProblemRequestorExtension getProblemRequestorExtension() {
        IAnnotationModel model = this.fDocumentProvider.getAnnotationModel((Object)this.fEditor.getEditorInput());
        if (model instanceof IProblemRequestorExtension) {
            return (IProblemRequestorExtension)model;
        }
        return null;
    }

    protected void reconcile(final boolean initialReconcile) {
        if (this.fEditor == null) {
            return;
        }
        final ISourceModule unit = this.fManager.getWorkingCopy(this.fEditor.getEditorInput());
        if (unit == null) {
            return;
        }
        try {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws ModelException {
                    ScriptReconcilingStrategy.this.reconcile(unit, initialReconcile);
                }

                public void handleException(Throwable ex) {
                    DLTKUIPlugin.logErrorMessage("Error in DLTK Core during reconcile", ex);
                }
            });
        }
        catch (Throwable throwable) {
            try {
                if (this.fIsScriptReconcilingListener) {
                    IProgressMonitor pm = this.fProgressMonitor;
                    if (pm == null) {
                        pm = new NullProgressMonitor();
                    }
                    this.fScriptReconcilingListener.reconciled(unit, !this.fNotify, pm);
                }
            }
            finally {
                this.fNotify = true;
            }
            throw throwable;
        }
        try {
            if (this.fIsScriptReconcilingListener) {
                IProgressMonitor pm = this.fProgressMonitor;
                if (pm == null) {
                    pm = new NullProgressMonitor();
                }
                this.fScriptReconcilingListener.reconciled(unit, !this.fNotify, pm);
            }
        }
        finally {
            this.fNotify = true;
        }
    }

    private void reconcile(ISourceModule unit, boolean initialReconcile) throws ModelException {
        IProblemRequestorExtension extension = this.getProblemRequestorExtension();
        if (extension != null) {
            extension.setProgressMonitor(this.fProgressMonitor);
            extension.setIsActive(true);
        }
        try {
            try {
                unit.reconcile(true, null, this.fProgressMonitor);
            }
            catch (OperationCanceledException operationCanceledException) {
                Assert.isTrue((this.fProgressMonitor == null || this.fProgressMonitor.isCanceled() ? 1 : 0) != 0);
                if (extension != null) {
                    extension.setProgressMonitor(null);
                    extension.setIsActive(false);
                }
            }
        }
        finally {
            if (extension != null) {
                extension.setProgressMonitor(null);
                extension.setIsActive(false);
            }
        }
    }

    public void aboutToBeReconciled() {
        if (this.fIsScriptReconcilingListener) {
            this.fScriptReconcilingListener.aboutToBeReconciled();
        }
    }

    public void setDocument(IDocument document) {
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        this.reconcile(false);
    }

    public void reconcile(IRegion partition) {
        this.reconcile(false);
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.fProgressMonitor = monitor;
    }

    public void initialReconcile() {
        this.reconcile(true);
    }

    public void notifyListeners(boolean notify) {
        this.fNotify = notify;
    }
}

