/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.internal.ui.DLTKUIMessages;
import org.eclipse.dltk.mod.internal.ui.dialogs.OpenMethodSelectionDialog2;
import org.eclipse.dltk.mod.ui.DLTKPluginImages;
import org.eclipse.dltk.mod.ui.DLTKUIPlugin;
import org.eclipse.dltk.mod.ui.IDLTKUILanguageToolkit;
import org.eclipse.dltk.mod.ui.util.ExceptionHandler;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public abstract class OpenMethodAction
extends Action
implements IWorkbenchWindowActionDelegate {
    public OpenMethodAction() {
        this.setText(DLTKUIMessages.OpenMethodAction_label);
        this.setDescription(DLTKUIMessages.OpenMethodAction_description);
        this.setToolTipText(DLTKUIMessages.OpenMethodAction_tooltip);
        this.setImageDescriptor(DLTKPluginImages.DESC_TOOL_OPENMETHOD);
    }

    protected abstract IDLTKUILanguageToolkit getUILanguageToolkit();

    public void run() {
        Shell parent = DLTKUIPlugin.getActiveWorkbenchShell();
        OpenMethodSelectionDialog2 dialog = new OpenMethodSelectionDialog2(parent, true, (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), null, 1, this.getUILanguageToolkit());
        dialog.setTitle(this.getOpenMethodDialogTitle());
        dialog.setMessage(this.getOpenMethodDialogMessage());
        int result = dialog.open();
        if (result != 0) {
            return;
        }
        Object[] types = dialog.getResult();
        if (types != null && types.length > 0) {
            IModelElement type = null;
            int i = 0;
            while (i < types.length) {
                type = (IModelElement)types[i];
                try {
                    DLTKUIPlugin.openInEditor(type, true, true);
                }
                catch (CoreException x) {
                    ExceptionHandler.handle(x, this.getOpenMethodErrorTitle(), this.getOpenMethodErrorMessage());
                }
                ++i;
            }
        }
    }

    protected String getOpenMethodErrorMessage() {
        return DLTKUIMessages.OpenMethodAction_errorMessage;
    }

    protected String getOpenMethodErrorTitle() {
        return DLTKUIMessages.OpenMethodAction_errorTitle;
    }

    protected String getOpenMethodDialogMessage() {
        return DLTKUIMessages.OpenMethodAction_dialogMessage;
    }

    protected String getOpenMethodDialogTitle() {
        return DLTKUIMessages.OpenMethodAction_dialogTitle;
    }

    public void run(IAction action) {
        this.run();
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

