/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.ui.viewsupport;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.internal.corext.util.Messages;
import org.eclipse.dltk.mod.internal.ui.DLTKUIMessages;
import org.eclipse.dltk.mod.internal.ui.scriptview.BuildPathContainer;
import org.eclipse.dltk.mod.ui.ScriptElementLabels;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class StatusBarUpdater
implements ISelectionChangedListener {
    private final long LABEL_FLAGS = ScriptElementLabels.DEFAULT_QUALIFIED | 0x40000000000L | 0x80000000000L | 1L | 2L | 0x20L | 0x10L | 0x4000L | 0x200000L;
    private IStatusLineManager fStatusLineManager;

    public StatusBarUpdater(IStatusLineManager statusLineManager) {
        this.fStatusLineManager = statusLineManager;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        String statusBarMessage = this.formatMessage(event.getSelection());
        this.fStatusLineManager.setMessage(statusBarMessage);
    }

    protected String formatMessage(ISelection sel) {
        if (sel instanceof IStructuredSelection && !sel.isEmpty()) {
            IWorkbenchAdapter wbadapter;
            IStructuredSelection selection = (IStructuredSelection)sel;
            int nElements = selection.size();
            if (nElements > 1) {
                return Messages.format(DLTKUIMessages.StatusBarUpdater_num_elements_selected, String.valueOf(nElements));
            }
            Object elem = selection.getFirstElement();
            if (elem instanceof IModelElement) {
                return this.formatModelElementMessage((IModelElement)elem);
            }
            if (elem instanceof IResource) {
                return this.formatResourceMessage((IResource)elem);
            }
            if (elem instanceof BuildPathContainer) {
                BuildPathContainer container = (BuildPathContainer)elem;
                return String.valueOf(container.getLabel()) + " - " + container.getScriptProject().getElementName();
            }
            if (elem instanceof IAdaptable && (wbadapter = (IWorkbenchAdapter)((IAdaptable)elem).getAdapter(IWorkbenchAdapter.class)) != null) {
                return wbadapter.getLabel(elem);
            }
        }
        return "";
    }

    private String formatModelElementMessage(IModelElement element) {
        return ScriptElementLabels.getDefault().getElementLabel(element, this.LABEL_FLAGS);
    }

    private String formatResourceMessage(IResource element) {
        IContainer parent = element.getParent();
        if (parent != null && parent.getType() != 8) {
            return String.valueOf(element.getName()) + " - " + parent.getFullPath().makeRelative().toString();
        }
        return element.getName();
    }
}

