/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.ui.wizards;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.DLTKLanguageManager;
import org.eclipse.dltk.mod.core.IBuildpathEntry;
import org.eclipse.dltk.mod.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.mod.internal.corext.util.Messages;
import org.eclipse.dltk.mod.internal.ui.util.CoreUtility;
import org.eclipse.dltk.mod.internal.ui.wizards.BuildpathDetector;
import org.eclipse.dltk.mod.internal.ui.wizards.NewWizardMessages;
import org.eclipse.dltk.mod.launching.IInterpreterInstall;
import org.eclipse.dltk.mod.launching.ScriptRuntime;
import org.eclipse.dltk.mod.ui.util.ExceptionHandler;
import org.eclipse.dltk.mod.ui.wizards.CapabilityConfigurationPage;
import org.eclipse.dltk.mod.ui.wizards.ProjectWizardFirstPage;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;

public abstract class ProjectWizardSecondPage
extends CapabilityConfigurationPage {
    private static final String FILENAME_PROJECT = ".project";
    private static final String FILENAME_BUILDPATH = ".buildpath";
    private final ProjectWizardFirstPage fFirstPage;
    private URI fCurrProjectLocation;
    private IProject fCurrProject;
    private boolean fKeepContent;
    private File fDotProjectBackup;
    private File fDotBuildpathBackup;
    private Boolean fIsAutobuild;

    public ProjectWizardSecondPage(ProjectWizardFirstPage mainPage) {
        this.fFirstPage = mainPage;
        this.fCurrProjectLocation = null;
        this.fCurrProject = null;
        this.fKeepContent = false;
        this.fDotProjectBackup = null;
        this.fDotBuildpathBackup = null;
        this.fIsAutobuild = null;
    }

    public ProjectWizardFirstPage getFirstPage() {
        return this.fFirstPage;
    }

    @Override
    protected boolean useNewSourcePage() {
        return true;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.changeToNewProject();
        } else {
            this.removeProject();
        }
        super.setVisible(visible);
    }

    private void changeToNewProject() {
        this.fKeepContent = this.fFirstPage.getDetect();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    try {
                        if (ProjectWizardSecondPage.this.fIsAutobuild == null) {
                            ProjectWizardSecondPage.this.fIsAutobuild = CoreUtility.enableAutoBuild(false);
                        }
                        ProjectWizardSecondPage.this.updateProject(monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        throw new InterruptedException();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, (IRunnableWithProgress)new WorkspaceModifyDelegatingOperation(op));
        }
        catch (InvocationTargetException e) {
            String title = NewWizardMessages.ScriptProjectWizardSecondPage_error_title;
            String message = NewWizardMessages.ScriptProjectWizardSecondPage_error_message;
            ExceptionHandler.handle(e, this.getShell(), title, message);
        }
        catch (InterruptedException interruptedException) {}
    }

    final void updateProject(IProgressMonitor monitor) throws CoreException, InterruptedException {
        this.fCurrProject = this.fFirstPage.getProjectHandle();
        this.fCurrProjectLocation = this.getProjectLocationURI();
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(NewWizardMessages.ScriptProjectWizardSecondPage_operation_initialize, 70);
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            URI realLocation = this.fCurrProjectLocation;
            if (this.fCurrProjectLocation == null) {
                try {
                    URI rootLocation = ResourcesPlugin.getWorkspace().getRoot().getLocationURI();
                    realLocation = new URI(rootLocation.getScheme(), null, Path.fromPortableString((String)rootLocation.getPath()).append(this.fCurrProject.getName()).toString(), null);
                }
                catch (URISyntaxException uRISyntaxException) {
                    Assert.isTrue((boolean)false, (String)"Can't happen");
                }
            }
            this.rememberExistingFiles(realLocation);
            ProjectWizardSecondPage.createProject(this.fCurrProject, this.fCurrProjectLocation, (IProgressMonitor)new SubProgressMonitor(monitor, 20));
            IBuildpathEntry[] entries = null;
            if (this.fFirstPage.getDetect()) {
                if (!this.fCurrProject.getFile(FILENAME_BUILDPATH).exists()) {
                    IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit((String)this.getScriptNature());
                    BuildpathDetector detector = this.createBuildpathDetector(monitor, toolkit);
                    entries = detector.getBuildpath();
                } else {
                    monitor.worked(20);
                }
            } else if (this.fFirstPage.isSrc()) {
                IFolder folder;
                IPreferenceStore store = this.getPreferenceStore();
                Path srcPath = new Path(store.getString("com.xore.dltk.ui.wizards.srcFoldersSrcName"));
                if (srcPath.segmentCount() > 0) {
                    folder = this.fCurrProject.getFolder((IPath)srcPath);
                    CoreUtility.createFolder(folder, true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                } else {
                    monitor.worked(10);
                }
                if (srcPath.segmentCount() > 0) {
                    folder = this.fCurrProject.getFolder((IPath)srcPath);
                    CoreUtility.createFolder(folder, true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                } else {
                    monitor.worked(10);
                }
                IPath projectPath = this.fCurrProject.getFullPath();
                ArrayList<IBuildpathEntry> cpEntries = new ArrayList<IBuildpathEntry>();
                cpEntries.add(DLTKCore.newSourceEntry((IPath)projectPath.append((IPath)srcPath)));
                IBuildpathEntry[] entrys = this.getDefaultBuildpathEntry();
                if (entrys != null) {
                    cpEntries.addAll(Arrays.asList(entrys));
                }
                entries = cpEntries.toArray(new IBuildpathEntry[cpEntries.size()]);
            } else {
                IPath projectPath = this.fCurrProject.getFullPath();
                ArrayList<IBuildpathEntry> cpEntries = new ArrayList<IBuildpathEntry>();
                cpEntries.add(DLTKCore.newSourceEntry((IPath)projectPath));
                IBuildpathEntry[] entrys = this.getDefaultBuildpathEntry();
                if (entrys != null) {
                    cpEntries.addAll(Arrays.asList(entrys));
                }
                entries = cpEntries.toArray(new IBuildpathEntry[cpEntries.size()]);
                monitor.worked(20);
            }
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.init(DLTKCore.create((IProject)this.fCurrProject), entries, false);
            this.configureScriptProject((IProgressMonitor)new SubProgressMonitor(monitor, 30));
        }
        finally {
            monitor.done();
        }
    }

    protected BuildpathDetector createBuildpathDetector(IProgressMonitor monitor, IDLTKLanguageToolkit toolkit) throws CoreException {
        BuildpathDetector detector = new BuildpathDetector(this.fCurrProject, toolkit);
        detector.detectBuildpath((IProgressMonitor)new SubProgressMonitor(monitor, 20));
        return detector;
    }

    protected abstract IPreferenceStore getPreferenceStore();

    private URI getProjectLocationURI() throws CoreException {
        if (this.fFirstPage.isInWorkspace()) {
            return null;
        }
        return this.fFirstPage.getLocationURI();
    }

    private IBuildpathEntry[] getDefaultBuildpathEntry() {
        IBuildpathEntry defaultPath = ScriptRuntime.getDefaultInterpreterContainerEntry();
        Path InterpreterEnvironmentContainerPath = new Path(ScriptRuntime.INTERPRETER_CONTAINER);
        IInterpreterInstall inst = this.fFirstPage.getInterpreter();
        if (inst != null) {
            IPath newPath = InterpreterEnvironmentContainerPath.append(inst.getInterpreterInstallType().getId()).append(inst.getName());
            return new IBuildpathEntry[]{DLTKCore.newContainerEntry((IPath)newPath)};
        }
        if (defaultPath != null) {
            return new IBuildpathEntry[]{defaultPath};
        }
        return null;
    }

    private void rememberExistingFiles(URI projectLocation) throws CoreException {
        this.fDotProjectBackup = null;
        this.fDotBuildpathBackup = null;
        IFileStore file = EFS.getStore((URI)projectLocation);
        if (file.fetchInfo().exists()) {
            IFileStore buildpathFile;
            IFileStore projectFile = file.getChild(FILENAME_PROJECT);
            if (projectFile.fetchInfo().exists()) {
                this.fDotProjectBackup = this.createBackup(projectFile, "project-desc");
            }
            if ((buildpathFile = file.getChild(FILENAME_BUILDPATH)).fetchInfo().exists()) {
                this.fDotBuildpathBackup = this.createBackup(buildpathFile, "buildpath-desc");
            }
        }
    }

    private void restoreExistingFiles(URI projectLocation, IProgressMonitor monitor) throws CoreException {
        int ticks = ((this.fDotProjectBackup != null ? 1 : 0) + (this.fDotBuildpathBackup != null ? 1 : 0)) * 2;
        monitor.beginTask("", ticks);
        try {
            if (this.fDotProjectBackup != null) {
                IFileStore projectFile = EFS.getStore((URI)projectLocation).getChild(FILENAME_PROJECT);
                projectFile.delete(0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                this.copyFile(this.fDotProjectBackup, projectFile, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.dltk.mod.ui", 4, NewWizardMessages.ScriptProjectWizardSecondPage_problem_restore_project, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        try {
            if (this.fDotBuildpathBackup != null) {
                IFileStore buildpathFile = EFS.getStore((URI)projectLocation).getChild(FILENAME_BUILDPATH);
                buildpathFile.delete(0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                this.copyFile(this.fDotBuildpathBackup, buildpathFile, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.dltk.mod.ui", 4, NewWizardMessages.ScriptProjectWizardSecondPage_problem_restore_buildpath, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    private File createBackup(IFileStore source, String name) throws CoreException {
        try {
            File bak = File.createTempFile("eclipse-" + name, ".bak");
            this.copyFile(source, bak);
            return bak;
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.dltk.mod.ui", 4, Messages.format(NewWizardMessages.ScriptProjectWizardSecondPage_problem_backup, name), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    private void copyFile(IFileStore source, File target) throws IOException, CoreException {
        InputStream is = source.openInputStream(0, null);
        FileOutputStream os = new FileOutputStream(target);
        this.copyFile(is, os);
    }

    private void copyFile(File source, IFileStore target, IProgressMonitor monitor) throws IOException, CoreException {
        FileInputStream is = new FileInputStream(source);
        OutputStream os = target.openOutputStream(0, monitor);
        this.copyFile(is, os);
    }

    private void copyFile(InputStream is, OutputStream os) throws IOException {
        try {
            int bytesRead;
            byte[] buffer = new byte[8192];
            while ((bytesRead = is.read(buffer)) != -1) {
                os.write(buffer, 0, bytesRead);
            }
        }
        finally {
            try {
                is.close();
            }
            finally {
                os.close();
            }
        }
    }

    public void performFinish(IProgressMonitor monitor) throws CoreException, InterruptedException {
        try {
            monitor.beginTask(NewWizardMessages.ScriptProjectWizardSecondPage_operation_create, 3);
            if (this.fCurrProject == null) {
                this.updateProject((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            this.configureScriptProject((IProgressMonitor)new SubProgressMonitor(monitor, 2));
            if (!this.fKeepContent && DLTKCore.DEBUG) {
                System.err.println("Add compiler compilance options here...");
            }
        }
        finally {
            monitor.done();
            this.fCurrProject = null;
            if (this.fIsAutobuild != null) {
                CoreUtility.enableAutoBuild(this.fIsAutobuild);
                this.fIsAutobuild = null;
            }
        }
    }

    private void removeProject() {
        if (this.fCurrProject == null || !this.fCurrProject.exists()) {
            return;
        }
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                ProjectWizardSecondPage.this.doRemoveProject(monitor);
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)new WorkspaceModifyDelegatingOperation(op));
        }
        catch (InvocationTargetException e) {
            String title = NewWizardMessages.ScriptProjectWizardSecondPage_error_remove_title;
            String message = NewWizardMessages.ScriptProjectWizardSecondPage_error_remove_message;
            ExceptionHandler.handle(e, this.getShell(), title, message);
        }
        catch (InterruptedException interruptedException) {}
    }

    final void doRemoveProject(IProgressMonitor monitor) throws InvocationTargetException {
        boolean noProgressMonitor;
        boolean bl = noProgressMonitor = this.fCurrProjectLocation == null;
        if (monitor == null || noProgressMonitor) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(NewWizardMessages.ScriptProjectWizardSecondPage_operation_remove, 3);
        try {
            try {
                try {
                    URI projLoc = this.fCurrProject.getLocationURI();
                    boolean removeContent = !this.fKeepContent && this.fCurrProject.isSynchronized(2);
                    this.fCurrProject.delete(removeContent, false, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                    this.restoreExistingFiles(projLoc, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                finally {
                    CoreUtility.enableAutoBuild(this.fIsAutobuild);
                    this.fIsAutobuild = null;
                }
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            monitor.done();
            this.fCurrProject = null;
            this.fKeepContent = false;
        }
    }

    public void performCancel() {
        this.removeProject();
    }

    public IProject getCurrProject() {
        return this.fCurrProject;
    }
}

