/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.af.common.error;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.vjet.af.common.error.ErrorArgsInterface;

public class ErrorNamedArgs
implements ErrorArgsInterface,
Serializable,
Cloneable {
    private static final int INITIAL_LIST_CAPACITY = 3;
    private static final int INITIAL_MAP_CAPACITY = 7;
    private HashMap m_map = new HashMap(7);
    private ArrayList m_names = new ArrayList(3);
    private static final long serialVersionUID = 5323418970760560460L;

    public ErrorNamedArgs() {
    }

    public ErrorNamedArgs(String[][] args) {
        this.add(args);
    }

    @Override
    public int size() {
        return this.m_names.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public String getNameByIndex(int index) {
        return (String)this.m_names.get(index);
    }

    @Override
    public String getValueByName(String name) {
        if (name == null) {
            throw new NullPointerException("The argument name must be non-null");
        }
        return (String)this.m_map.get(name);
    }

    @Override
    public boolean equals(ErrorArgsInterface thatErrorArgs) {
        if (thatErrorArgs == null) {
            return false;
        }
        int size = this.m_names.size();
        if (size != thatErrorArgs.size()) {
            return false;
        }
        int i = 0;
        while (i < size) {
            String name = (String)this.m_names.get(i);
            String value = this.getValueByName(name);
            if (!value.equals(thatErrorArgs.getValueByName(name))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object instanceof ErrorArgsInterface) {
            return this.equals((ErrorArgsInterface)object);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        int size = this.size();
        int i = 0;
        while (i < size) {
            String name = (String)this.m_names.get(i);
            hash ^= name.hashCode();
            hash ^= this.getValueByName(name).hashCode();
            ++i;
        }
        return hash;
    }

    public void add(String name, String value) {
        if (name == null) {
            throw new NullPointerException("Name of the argument added to NamedErrorArgs can't be null");
        }
        if (name.length() == 0) {
            throw new NullPointerException("Name of the argument added to NamedErrorArgs can't be empty");
        }
        if (value == null) {
            throw new NullPointerException("Argument value added to NamedErrorArgs can't be null");
        }
        if (this.m_map.get(name) != null) {
            throw new RuntimeException("Duplicate NamedErrorArgs name: " + name);
        }
        this.m_names.add(name);
        this.m_map.put(name, value);
    }

    public void add(String[][] args) {
        int i = 0;
        while (i < args.length) {
            String[] pair = args[i];
            if (pair.length != 2) {
                throw new IndexOutOfBoundsException("Non-pair in the NamedErrorArgs constructor");
            }
            this.add(pair[0], pair[1]);
            ++i;
        }
    }

    @Override
    public void add(ErrorArgsInterface args) {
        int size = args.size();
        int i = 0;
        while (i < size) {
            String name = args.getNameByIndex(i);
            String value = args.getValueByName(name);
            this.add(name, value);
            ++i;
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{ ");
        int size = this.size();
        int i = 0;
        while (i < size) {
            if (i != 0) {
                sb.append(", ");
            }
            String name = this.getNameByIndex(i);
            String value = this.getValueByName(name);
            sb.append(name);
            sb.append(" : ");
            sb.append(value);
            ++i;
        }
        sb.append(" }");
        return sb.toString();
    }
}

