/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jsgen.shared.jstvalidator.library;

import java.util.HashMap;
import java.util.List;
import org.eclipse.vjet.dsf.jsgen.shared.ids.FieldProbIds;
import org.eclipse.vjet.dsf.jsgen.shared.ids.VarProbIds;
import org.eclipse.vjet.dsf.jsgen.shared.jstvalidator.ValidationCtx;
import org.eclipse.vjet.dsf.jsgen.shared.jstvalidator.library.JstBasicUtils;
import org.eclipse.vjet.dsf.jsgen.shared.jstvalidator.library.ProblemUtil;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.declaration.JstArg;

public class UniquenessValidator {
    public static void assertUniqueMembers(ValidationCtx ctx, List<IJstProperty> props, List<? extends IJstMethod> methods) {
        IJstMethod instanceMethod;
        if (props.size() == 0 && methods.size() == 0) {
            return;
        }
        for (IJstProperty iJstProperty : props) {
            instanceMethod = JstBasicUtils.getMethod(iJstProperty.getName().getName(), methods);
            if (instanceMethod == null) continue;
            ctx.getProblems().add(ProblemUtil.problem(FieldProbIds.DuplicateField, (IJstNode)instanceMethod, ctx));
        }
        for (IJstMethod iJstMethod : methods) {
            instanceMethod = JstBasicUtils.getProp(iJstMethod.getName().getName(), props);
            if (instanceMethod == null) continue;
            ctx.getProblems().add(ProblemUtil.problem(FieldProbIds.DuplicateField, (IJstNode)instanceMethod, ctx));
        }
    }

    public static void assertUniqueParams(ValidationCtx ctx, IJstMethod method) {
        HashMap<String, JstArg> nodes = new HashMap<String, JstArg>();
        List arg = method.getArgs();
        for (JstArg a : arg) {
            if (nodes.containsKey(a.getName())) {
                ctx.getProblems().add(ProblemUtil.problem(VarProbIds.RedefinedLocal, (IJstNode)a, ctx));
                continue;
            }
            nodes.put(a.getName(), a);
        }
    }
}

