/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jsgen.shared.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.vjet.dsf.jsgen.shared.util.CodeGenCleaner;

public class CodeGenCleanerTask
extends Task {
    private String m_option;
    private String m_sourceDirs;
    private String m_projectDir;
    private boolean m_verbose = false;

    public void execute() throws BuildException {
        if (this.m_option == null) {
            throw new BuildException("option is null");
        }
        if (this.m_sourceDirs == null) {
            throw new BuildException("sourceDirs is null");
        }
        if (this.m_projectDir == null) {
            throw new BuildException("projectDir is null");
        }
        long startTime = System.currentTimeMillis();
        try {
            try {
                int deleted = CodeGenCleaner.clean(this.m_option, CodeGenCleanerTask.parseSourceDirs(this.m_sourceDirs, this.m_projectDir), this.m_verbose);
                System.out.println("Deleted " + deleted + " files");
            }
            catch (Exception e) {
                e.printStackTrace();
                long totalTime = (System.currentTimeMillis() - startTime) / 1000L;
                System.out.println("CodeGenCleaner completed in " + totalTime + " sec");
            }
        }
        finally {
            long totalTime = (System.currentTimeMillis() - startTime) / 1000L;
            System.out.println("CodeGenCleaner completed in " + totalTime + " sec");
        }
    }

    protected static List<String> parseSourceDirs(String srcDirs, String projRoot) {
        String[] sources = srcDirs.split(File.pathSeparator);
        ArrayList<String> dirs = new ArrayList<String>(sources.length);
        String[] stringArray = sources;
        int n = sources.length;
        int n2 = 0;
        while (n2 < n) {
            String source;
            String sourceFile = source = stringArray[n2];
            if (source.indexOf(projRoot) == -1) {
                sourceFile = String.valueOf(projRoot) + File.separatorChar + source;
            }
            dirs.add(sourceFile);
            ++n2;
        }
        return dirs;
    }

    public String getOption() {
        return this.m_option;
    }

    public void setOption(String option) {
        this.m_option = option;
    }

    public boolean getVerbose() {
        return this.m_verbose;
    }

    public void setVerbose(boolean verbose) {
        this.m_verbose = verbose;
    }

    public String getSourceDirs() {
        return this.m_sourceDirs;
    }

    public void setSourceDirs(String dirs) {
        this.m_sourceDirs = dirs;
    }

    public String getProjectDir() {
        return this.m_projectDir;
    }

    public void setProjectDir(String dir) {
        this.m_projectDir = dir;
    }
}

