/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jsgen.shared.util;

import java.util.List;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstArg;
import org.eclipse.vjet.dsf.jst.declaration.JstConstructor;

public class JstDisplayUtils {
    public static String getFullMethodString(IJstMethod method, IJstType ownerType, boolean optional) {
        return JstDisplayUtils.getFullMethodString(method.getName().getName(), method, ownerType, optional);
    }

    public static String getFullMethodString(String name, IJstMethod method, IJstType ownerType, boolean optional) {
        String aname;
        StringBuilder strBldr = new StringBuilder();
        name = JstDisplayUtils.renameInvoke(method, name);
        if (method instanceof JstConstructor) {
            JstConstructor c = (JstConstructor)method;
            name = c.getOwnerType().getName();
        }
        strBldr.append(name);
        strBldr.append("(");
        IJstType ref = method.getRtnType();
        String oname = "";
        if (ownerType != null) {
            oname = ownerType.getSimpleName();
        }
        if ((aname = JstDisplayUtils.getJstArgsString(method)).length() > 0) {
            strBldr.append(aname);
        }
        strBldr.append(")");
        if (optional) {
            strBldr.append(" ? ");
        }
        if (ref != null) {
            String rname = ref.getSimpleName();
            strBldr.append(" ").append(rname);
        }
        strBldr.append(" - ");
        strBldr.append(oname);
        return strBldr.toString();
    }

    public static String renameInvoke(IJstMethod method, String name) {
        IJstType ownerType;
        if ("_invoke_".equals(name) && (ownerType = method.getOwnerType()) != null && ownerType.isFType()) {
            name = ownerType.getSimpleName();
        }
        return name;
    }

    public static String getJstArgsString(IJstMethod method) {
        String result;
        StringBuffer buffer = new StringBuffer();
        List args = method.getArgs();
        if (args != null && !args.isEmpty()) {
            for (JstArg arg : args) {
                IJstType type = arg.getType();
                if (type != null) {
                    buffer.append(type.getSimpleName());
                } else {
                    buffer.append("Object");
                }
                buffer.append(" " + arg.getName());
                buffer.append(", ");
            }
        }
        if ((result = buffer.toString()).length() > 2) {
            result = result.substring(0, result.length() - 2);
        }
        return result;
    }
}

