/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jsgen.shared.validation.vjo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.IVjoDependencyVerifiable;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.VjoSemanticProblem;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.VjoValidationDriver;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.VjoMethodControlFlowTable;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.VjoMethodReferencesTable;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.VjoPropertyStatesTable;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.symbol.VjoScope;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.symbol.VjoSymbolTable;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstRefType;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.IScriptProblem;
import org.eclipse.vjet.dsf.jst.declaration.JstCache;
import org.eclipse.vjet.dsf.jst.declaration.JstMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstParamType;
import org.eclipse.vjet.dsf.jst.term.ObjLiteral;

public class VjoValidationCtx {
    private String m_path;
    private IJstNode m_jstNode;
    private Set<IJstNode> m_visitedNodes;
    private Set<String> m_jstTypeNames;
    private String m_groupId;
    private IJstType m_global;
    private IJstType m_package;
    private Map<IJstType, IVjoDependencyVerifiable> m_type2Dependencies;
    private Map<IJstType, List<IScriptProblem>> m_type2SyntaxProblems;
    private Map<IJstType, IJstType> m_type2TypeSpacedTypeMap;
    private VjoScope m_scope;
    private Map<IJstType, IJstType> m_makeType2scopeTypeMap;
    private Map<IJstType, IJstType> m_makeType2parentTypeMap;
    private Map<IJstType, IJstType> m_makeType2sourceTypeMap;
    private Map<ObjLiteral, IJstType> m_objLiteral2MakeTypeMap;
    private Map<JstParamType, IJstType> m_paramType2ResolvedTypeMap;
    private Map<IJstNode, List<VjoSemanticProblem>> m_node2Problems;
    private Map<IJstType, Set<IJstRefType>> m_knownActivelyNeededTypes;
    private Map<IJstType, Set<IJstRefType>> m_mustActivelyNeededTypes;
    private VjoSymbolTable m_symbolTable = new VjoSymbolTable();
    private VjoMethodControlFlowTable m_methodFlowTable = new VjoMethodControlFlowTable();
    private VjoMethodReferencesTable m_methodInvocationTable = new VjoMethodReferencesTable();
    private VjoPropertyStatesTable m_propertyStatesTable = new VjoPropertyStatesTable();
    private Map<IJstProperty, List<IJstMethod>> m_finalPropertyInitMap = new HashMap<IJstProperty, List<IJstMethod>>();
    private Set<IJstType> m_uninitializedTypes;
    private Set<IJstType> m_missingImportTypes;
    private Set<String> m_unresolvedTypes;
    private VjoValidationDriver.VjoValidationMode m_validationMode = VjoValidationDriver.VjoValidationMode.validateType;

    public Set<IJstType> getUninitializedTypes() {
        if (this.m_uninitializedTypes == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.m_uninitializedTypes);
    }

    public void addUnintializedType(IJstType type) {
        if (this.m_uninitializedTypes == null) {
            this.m_uninitializedTypes = new HashSet<IJstType>();
        }
        if (!(this.m_uninitializedTypes.contains(type) || "Object".equals(type.getName()) || "vjo.Object".equals(type.getName()))) {
            this.m_uninitializedTypes.add(type);
        }
    }

    public void removeUnintializedType(IJstType type) {
        if (this.m_uninitializedTypes != null) {
            this.m_uninitializedTypes.remove(type);
        }
    }

    public void clearUnintializedTypes() {
        if (this.m_uninitializedTypes != null) {
            this.m_uninitializedTypes.clear();
        }
    }

    public Set<IJstType> getMissingImportTypes() {
        if (this.m_missingImportTypes == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.m_missingImportTypes);
    }

    public Set<String> getUnresolvedTypes() {
        if (this.m_unresolvedTypes == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.m_unresolvedTypes);
    }

    public void addMissingImportType(IJstType type) {
        if (this.m_missingImportTypes == null) {
            this.m_missingImportTypes = new HashSet<IJstType>();
        }
        if (!this.m_missingImportTypes.contains(type)) {
            this.m_missingImportTypes.add(type);
        }
    }

    public void addUnresolvedType(String type) {
        if (this.m_unresolvedTypes == null) {
            this.m_unresolvedTypes = new HashSet<String>();
        }
        if (!this.m_unresolvedTypes.contains(type)) {
            this.m_unresolvedTypes.add(type);
        }
    }

    public void removeMissingImportType(IJstType type) {
        if (this.m_missingImportTypes != null) {
            this.m_missingImportTypes.remove(type);
        }
    }

    public void removeUnrsolvedType(String type) {
        if (this.m_unresolvedTypes != null) {
            this.m_unresolvedTypes.remove(type);
        }
    }

    public void clearMissingImportTypes() {
        if (this.m_missingImportTypes != null) {
            this.m_missingImportTypes.clear();
        }
    }

    public void clearUnresolvedTypes() {
        if (this.m_unresolvedTypes != null) {
            this.m_unresolvedTypes.clear();
        }
    }

    public IJstType getMakeScopeType(IJstType makeType) {
        if (this.m_makeType2scopeTypeMap == null) {
            return null;
        }
        return this.m_makeType2scopeTypeMap.get(makeType);
    }

    public VjoValidationCtx setMakeScopeType(IJstType makeType, IJstType scopeType) {
        if (this.m_makeType2scopeTypeMap == null) {
            this.m_makeType2scopeTypeMap = new HashMap<IJstType, IJstType>();
        }
        this.m_makeType2scopeTypeMap.put(makeType, scopeType);
        this.getDependencyVerifier(makeType).addDependency(scopeType);
        return this;
    }

    public IJstType getMakeParentType(IJstType makeType) {
        if (this.m_makeType2parentTypeMap == null) {
            return null;
        }
        return this.m_makeType2parentTypeMap.get(makeType);
    }

    public VjoValidationCtx setMakeParentType(IJstType makeType, IJstType parentType) {
        if (this.m_makeType2parentTypeMap == null) {
            this.m_makeType2parentTypeMap = new HashMap<IJstType, IJstType>();
        }
        this.m_makeType2parentTypeMap.put(makeType, parentType);
        this.getDependencyVerifier(makeType).addDependency(parentType);
        return this;
    }

    public IJstType getMakeSourceType(IJstType makeType) {
        if (this.m_makeType2sourceTypeMap == null) {
            return null;
        }
        return this.m_makeType2sourceTypeMap.get(makeType);
    }

    public VjoValidationCtx setMakeSourceType(IJstType makeType, IJstType sourceType) {
        if (this.m_makeType2sourceTypeMap == null) {
            this.m_makeType2sourceTypeMap = new HashMap<IJstType, IJstType>();
        }
        this.m_makeType2sourceTypeMap.put(makeType, sourceType);
        this.getDependencyVerifier(makeType).addDependency(sourceType);
        return this;
    }

    public IJstType getMakeTypeByObjLiteral(ObjLiteral objLiteral) {
        if (this.m_objLiteral2MakeTypeMap == null) {
            return null;
        }
        return this.m_objLiteral2MakeTypeMap.get(objLiteral);
    }

    public VjoValidationCtx setMakeTypeForObjLiteral(ObjLiteral objLiteral, IJstType makeType) {
        if (this.m_objLiteral2MakeTypeMap == null) {
            this.m_objLiteral2MakeTypeMap = new HashMap<ObjLiteral, IJstType>();
        }
        this.m_objLiteral2MakeTypeMap.put(objLiteral, makeType);
        return this;
    }

    public IJstType getResolvedTypeByParamType(JstParamType paramType) {
        if (this.m_paramType2ResolvedTypeMap == null || paramType == null) {
            return null;
        }
        return this.m_paramType2ResolvedTypeMap.get(paramType);
    }

    public VjoValidationCtx setResolvedTypeForParamType(JstParamType paramType, IJstType resolvedType) {
        if (this.m_paramType2ResolvedTypeMap == null) {
            this.m_paramType2ResolvedTypeMap = new HashMap<JstParamType, IJstType>();
        }
        this.m_paramType2ResolvedTypeMap.put(paramType, resolvedType);
        return this;
    }

    public VjoValidationCtx resetResolvedTypeByParamType(JstParamType paramType) {
        if (this.m_paramType2ResolvedTypeMap != null && paramType != null) {
            this.m_paramType2ResolvedTypeMap.remove(paramType);
        }
        return this;
    }

    public String getPath() {
        return this.m_path;
    }

    public VjoValidationCtx setPath(String path) {
        this.m_path = path;
        return this;
    }

    public IJstNode getJstNode() {
        return this.m_jstNode;
    }

    public VjoValidationCtx setJstNode(IJstNode node) {
        this.m_jstNode = node;
        return this;
    }

    public Set<IJstNode> getVisitedJstNodes() {
        if (this.m_visitedNodes == null) {
            this.m_visitedNodes = new HashSet<IJstNode>();
        }
        return this.m_visitedNodes;
    }

    public Set<String> getJstTypeNames() {
        if (this.m_jstTypeNames == null) {
            this.m_jstTypeNames = new HashSet<String>();
        }
        return this.m_jstTypeNames;
    }

    public VjoValidationCtx addJstTypeName(String name) {
        if (this.m_jstTypeNames == null) {
            this.m_jstTypeNames = new HashSet<String>();
        }
        this.m_jstTypeNames.add(name);
        return this;
    }

    public String getGroupId() {
        return this.m_groupId;
    }

    public VjoValidationCtx setGroupId(String groupId) {
        this.m_groupId = groupId;
        return this;
    }

    public IJstType getGlobal() {
        return this.m_global;
    }

    public VjoValidationCtx setGlobal(IJstType global) {
        this.m_global = global;
        return this;
    }

    public IJstType getPackage() {
        return this.m_package;
    }

    public VjoValidationCtx setPackage(IJstType vjoPackage) {
        this.m_package = vjoPackage;
        return this;
    }

    public void setDependencyVerifier(IJstType type, IVjoDependencyVerifiable verifier) {
        if (this.m_type2Dependencies == null) {
            this.m_type2Dependencies = new HashMap<IJstType, IVjoDependencyVerifiable>();
        }
        this.m_type2Dependencies.put(type, verifier);
    }

    public IVjoDependencyVerifiable getDependencyVerifier(IJstType type) {
        IVjoDependencyVerifiable verifier = this.m_type2Dependencies.get(type);
        return verifier == null ? IVjoDependencyVerifiable.FALSE_VERIFIER : verifier;
    }

    public void addSyntaxProblems(IJstType type, Collection<IScriptProblem> syntaxProblems) {
        List<IScriptProblem> problems;
        if (this.m_type2SyntaxProblems == null) {
            this.m_type2SyntaxProblems = new HashMap<IJstType, List<IScriptProblem>>();
        }
        if ((problems = this.m_type2SyntaxProblems.get(type)) == null) {
            problems = new ArrayList<IScriptProblem>();
            this.m_type2SyntaxProblems.put(type, problems);
        }
        if (syntaxProblems != null) {
            problems.addAll(syntaxProblems);
        }
    }

    public List<IScriptProblem> getSyntaxProblems(IJstType type) {
        if (this.m_type2SyntaxProblems == null) {
            return Collections.emptyList();
        }
        List<IScriptProblem> toReturn = this.m_type2SyntaxProblems.get(type);
        if (toReturn == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(toReturn);
    }

    public void addTypeSpaceType(IJstType type, IJstType typeSpaceType) {
        if (this.m_type2TypeSpacedTypeMap == null) {
            this.m_type2TypeSpacedTypeMap = new HashMap<IJstType, IJstType>();
        }
        this.m_type2TypeSpacedTypeMap.put(type, typeSpaceType);
    }

    public IJstType getTypeSpaceType(IJstType type) {
        if (this.m_type2TypeSpacedTypeMap == null) {
            return type;
        }
        IJstType typeSpaceType = this.m_type2TypeSpacedTypeMap.get(type);
        if (typeSpaceType == null) {
            typeSpaceType = type;
        }
        return typeSpaceType;
    }

    public IJstType getCacheType(String typeName) {
        if (typeName == null) {
            return null;
        }
        IJstType cacheType = this.getScope().getClosestScopeNode().getOwnerType();
        for (IJstType depType : this.getDependencyVerifier(cacheType).getDirectDependenciesFilteredByGroup(cacheType)) {
            if (!typeName.equals(depType.getName())) continue;
            return this.getTypeSpaceType(depType);
        }
        if (cacheType == null) {
            cacheType = JstCache.getInstance().getType(typeName);
            if (cacheType != null) {
                return cacheType;
            }
        } else {
            return cacheType;
        }
        return null;
    }

    public void addProblem(IJstNode node, VjoSemanticProblem problem) {
        if (this.m_node2Problems == null) {
            this.m_node2Problems = new HashMap<IJstNode, List<VjoSemanticProblem>>();
        } else {
            if (problem == null) {
                return;
            }
            if (problem.getSourceLineNumber() < 0) {
                return;
            }
        }
        List<VjoSemanticProblem> problems4Node = this.m_node2Problems.get(node);
        if (problems4Node == null) {
            problems4Node = new ArrayList<VjoSemanticProblem>();
            if (node != null) {
                this.m_node2Problems.put(node, problems4Node);
            }
        }
        problems4Node.add(problem);
    }

    public void addProblems(IJstNode node, List<VjoSemanticProblem> problems) {
        List<VjoSemanticProblem> problems4Validator;
        if (this.m_node2Problems == null) {
            this.m_node2Problems = new HashMap<IJstNode, List<VjoSemanticProblem>>();
        }
        if ((problems4Validator = this.m_node2Problems.get(node)) == null) {
            problems4Validator = new ArrayList<VjoSemanticProblem>();
            if (node != null) {
                this.m_node2Problems.put(node, problems4Validator);
            }
        }
        problems4Validator.addAll(problems);
    }

    public List<VjoSemanticProblem> getProblems(IJstNode node) {
        return this.getProblems(node, false);
    }

    public List<VjoSemanticProblem> getProblems(IJstNode node, boolean recursive) {
        return this.getProblems(node, recursive, null);
    }

    public List<VjoSemanticProblem> getProblems(IJstNode node, boolean recursive, List<IJstNode> stopSigns) {
        if (this.m_node2Problems == null || node == null) {
            return Collections.emptyList();
        }
        List<VjoSemanticProblem> problems4Validator = this.m_node2Problems.get(node);
        if (problems4Validator == null) {
            problems4Validator = new ArrayList<VjoSemanticProblem>();
        }
        if (recursive) {
            for (IJstNode child : node.getChildren()) {
                if (stopSigns != null && stopSigns.contains(child)) continue;
                problems4Validator.addAll(this.getProblems(child, true, stopSigns));
            }
            if (node instanceof JstMethod) {
                problems4Validator.addAll(this.getProblems((IJstNode)((JstMethod)node).getName(), true, stopSigns));
            }
        }
        return Collections.unmodifiableList(problems4Validator);
    }

    public boolean removeProblem(IJstNode node, VjoSemanticProblem problem) {
        return this.removeProblem(node, problem, false);
    }

    public void removeProblems(IJstNode node) {
        this.removeProblems(node, false);
    }

    public boolean removeProblem(IJstNode node, VjoSemanticProblem problem, boolean recursive) {
        return this.removeProblem(node, problem, recursive, null);
    }

    public void removeProblems(IJstNode node, boolean recursive) {
        this.removeProblems(node, recursive, new ArrayList<IJstNode>());
    }

    public boolean removeProblem(IJstNode node, VjoSemanticProblem problem, boolean recursive, List<IJstNode> stopSigns) {
        return this.removeProblem(node, problem, recursive, stopSigns, new HashSet<IJstNode>());
    }

    public void removeProblems(IJstNode node, boolean recursive, List<IJstNode> stopSigns) {
        this.removeProblems(node, recursive, stopSigns, new HashSet<IJstNode>());
    }

    public boolean removeProblem(IJstNode node, VjoSemanticProblem problem, boolean recursive, List<IJstNode> stopSigns, Set<IJstNode> visited) {
        if (this.m_node2Problems == null || node == null) {
            return false;
        }
        if (visited.contains(node)) {
            return false;
        }
        visited.add(node);
        List<VjoSemanticProblem> node2Problems = this.m_node2Problems.get(node);
        if ((node2Problems == null || !node2Problems.remove(problem)) && recursive) {
            for (IJstNode child : node.getChildren()) {
                if (stopSigns != null && stopSigns.contains(child) || !this.removeProblem(child, problem, true, stopSigns, visited)) continue;
                return true;
            }
            if (node instanceof IJstMethod) {
                for (IJstNode child : ((IJstMethod)node).getOverloaded()) {
                    if (stopSigns != null && stopSigns.contains(child) || !this.removeProblem(child, problem, true, stopSigns, visited)) continue;
                    return true;
                }
                if (this.removeProblem((IJstNode)((IJstMethod)node).getName(), problem, true, stopSigns, visited)) {
                    return true;
                }
            }
        }
        return false;
    }

    public void removeProblems(IJstNode node, boolean recursive, List<IJstNode> stopSigns, Set<IJstNode> visited) {
        if (this.m_node2Problems == null || node == null) {
            return;
        }
        if (visited.contains(node)) {
            return;
        }
        visited.add(node);
        List<VjoSemanticProblem> node2Problems = this.m_node2Problems.get(node);
        if (node2Problems != null) {
            node2Problems.clear();
        }
        if (recursive) {
            for (IJstNode child : node.getChildren()) {
                if (stopSigns != null && stopSigns.contains(child)) continue;
                this.removeProblems(child, true, stopSigns, visited);
            }
            if (node instanceof IJstMethod) {
                for (IJstNode child : ((IJstMethod)node).getOverloaded()) {
                    if (stopSigns != null && stopSigns.contains(child)) continue;
                    this.removeProblems(child, true, stopSigns, visited);
                }
                this.removeProblems((IJstNode)((IJstMethod)node).getName(), true, stopSigns, visited);
            }
        }
    }

    public List<VjoSemanticProblem> getAllProblems() {
        if (this.m_node2Problems == null) {
            return Collections.emptyList();
        }
        ArrayList<VjoSemanticProblem> problems = new ArrayList<VjoSemanticProblem>();
        for (List<VjoSemanticProblem> problems4Validator : this.m_node2Problems.values()) {
            problems.addAll(problems4Validator);
        }
        return problems;
    }

    public void resetProblems() {
        if (this.m_node2Problems != null) {
            this.m_node2Problems.clear();
        }
    }

    public Set<IJstRefType> getKnownActivelyNeededTypes(IJstType jstType) {
        if (this.m_knownActivelyNeededTypes == null) {
            return Collections.emptySet();
        }
        Set<IJstRefType> exprs = this.m_knownActivelyNeededTypes.get(jstType);
        if (exprs == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(exprs);
    }

    public void addKnownActivelyNeededTypes(IJstType jstType, IJstRefType neededType) {
        Set<IJstRefType> exprs;
        if (this.m_knownActivelyNeededTypes == null) {
            this.m_knownActivelyNeededTypes = new HashMap<IJstType, Set<IJstRefType>>();
        }
        if ((exprs = this.m_knownActivelyNeededTypes.get(jstType)) == null) {
            exprs = new HashSet<IJstRefType>();
            this.m_knownActivelyNeededTypes.put(jstType, exprs);
        }
        exprs.add(neededType);
    }

    public void resetKnownActilveyNeededTypes(IJstType jstType) {
        if (this.m_knownActivelyNeededTypes != null) {
            this.m_knownActivelyNeededTypes.clear();
        }
    }

    public Set<IJstRefType> getMustActivelyNeededTypes(IJstType jstType) {
        if (this.m_mustActivelyNeededTypes == null) {
            return Collections.emptySet();
        }
        Set<IJstRefType> exprs = this.m_mustActivelyNeededTypes.get(jstType);
        if (exprs == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(exprs);
    }

    public void addMustActivelyNeededTypes(IJstType jstType, IJstRefType neededType) {
        Set<IJstRefType> exprs;
        if (this.m_mustActivelyNeededTypes == null) {
            this.m_mustActivelyNeededTypes = new HashMap<IJstType, Set<IJstRefType>>();
        }
        if ((exprs = this.m_mustActivelyNeededTypes.get(jstType)) == null) {
            exprs = new HashSet<IJstRefType>();
            this.m_mustActivelyNeededTypes.put(jstType, exprs);
        }
        exprs.add(neededType);
    }

    public void resetMustActilveyNeededTypes(IJstType jstType) {
        if (this.m_mustActivelyNeededTypes != null) {
            this.m_mustActivelyNeededTypes.clear();
        }
    }

    public VjoSymbolTable getSymbolTable() {
        return this.m_symbolTable;
    }

    public VjoMethodControlFlowTable getMethodControlFlowTable() {
        return this.m_methodFlowTable;
    }

    public VjoMethodReferencesTable getMethodInvocationTable() {
        return this.m_methodInvocationTable;
    }

    public VjoPropertyStatesTable getPropertyStatesTable() {
        return this.m_propertyStatesTable;
    }

    public VjoScope getScope() {
        if (this.m_scope == null) {
            this.m_scope = new VjoScope();
        }
        return this.m_scope;
    }

    public IJstNode getClosestScope() {
        return this.getScope().getClosestScopeNode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFinalProperty(IJstProperty pty, IJstMethod mtd) {
        List<IJstMethod> methods = this.m_finalPropertyInitMap.get(pty);
        if (methods == null) {
            methods = new ArrayList<IJstMethod>();
            Map<IJstProperty, List<IJstMethod>> map = this.m_finalPropertyInitMap;
            synchronized (map) {
                this.m_finalPropertyInitMap.put(pty, methods);
            }
        }
        methods.add(mtd);
    }

    public List<IJstMethod> getFinalPropertyInitConstructors(IJstProperty pty) {
        return this.m_finalPropertyInitMap.get(pty);
    }

    public void setValidationMode(VjoValidationDriver.VjoValidationMode m_validationMode) {
        this.m_validationMode = m_validationMode;
    }

    public VjoValidationDriver.VjoValidationMode getValidationMode() {
        return this.m_validationMode;
    }
}

