/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jsgen.shared.validation.vjo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.IVjoDependencyVerifiable;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.VjoValidationCtx;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.VjoValidationResult;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.VjoValidationRuntimeException;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.validator.VjoSemanticValidatorRepo;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.util.JstGlobalScopeUtil;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.visitor.VjoValidationVisitor;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.IJstTypeReference;
import org.eclipse.vjet.dsf.jst.IScriptProblem;
import org.eclipse.vjet.dsf.jst.declaration.JstPackage;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.dsf.jst.traversal.IJstNodeVisitor;
import org.eclipse.vjet.dsf.jst.ts.JstTypeSpaceMgr;
import org.eclipse.vjet.dsf.logger.Logger;
import org.eclipse.vjet.dsf.ts.ITypeSpace;
import org.eclipse.vjet.dsf.ts.group.Group;
import org.eclipse.vjet.dsf.ts.group.IGroup;
import org.eclipse.vjet.dsf.ts.type.TypeName;

public class VjoValidationDriver {
    private static Logger s_logger = null;
    private JstTypeSpaceMgr m_jstTypeSpaceMgr;
    private boolean m_hasInternalErrors;

    public void setTypeSpaceMgr(JstTypeSpaceMgr typeSpaceMgr) {
        this.m_jstTypeSpaceMgr = typeSpaceMgr;
    }

    public JstTypeSpaceMgr getJstTypeSpaceMgr() {
        return this.m_jstTypeSpaceMgr;
    }

    public boolean hasInternalErrors() {
        return this.m_hasInternalErrors;
    }

    private Logger getLogger() {
        if (s_logger == null) {
            s_logger = Logger.getInstance(VjoValidationDriver.class);
        }
        return s_logger;
    }

    public VjoValidationResult validate(List<IJstType> entryJstTypes, String groupId) {
        VjoValidationResult result = new VjoValidationResult();
        VjoValidationCtx ctx = new VjoValidationCtx();
        this.initValidationCtx(ctx, groupId, VjoValidationMode.validateTypeSpace);
        for (IJstType jstType : entryJstTypes) {
            try {
                this.walkThrough(jstType, null, null, ctx, groupId, null, VjoValidationMode.validateTypeSpace);
            }
            catch (VjoValidationRuntimeException ex) {
                ex.printStackTrace();
                this.getLogger().log((Throwable)ex);
                result.addResult(jstType, ctx.getAllProblems());
                break;
            }
            catch (Throwable th) {
                try {
                    th.printStackTrace();
                    this.getLogger().log(th);
                    this.m_hasInternalErrors = true;
                    continue;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    result.addResult(jstType, ctx.getAllProblems());
                }
            }
            result.addResult(jstType, ctx.getAllProblems());
        }
        return result;
    }

    public VjoValidationResult validateComplete(Map<String, IJstType> entryJstTypes, String groupId) {
        return this.validateComplete(entryJstTypes, groupId, VjoValidationMode.validateTypeSpace);
    }

    public VjoValidationResult validateComplete(Map<String, IJstType> entryJstTypes, String groupId, VjoValidationMode mode) {
        LinkedHashMap<String, IJstType> toValidate = new LinkedHashMap<String, IJstType>();
        for (Map.Entry<String, IJstType> entry : entryJstTypes.entrySet()) {
            toValidate.put(entry.getKey(), entry.getValue());
        }
        VjoValidationResult result = new VjoValidationResult();
        VjoValidationCtx ctx = new VjoValidationCtx();
        this.initValidationCtx(ctx, groupId, mode);
        for (Map.Entry typeEntry : toValidate.entrySet()) {
            String uniquePath = (String)typeEntry.getKey();
            IJstType jsttype = entryJstTypes.get(uniquePath);
            IJstType jstType2Validate = (IJstType)typeEntry.getValue();
            try {
                this.walkThrough(jstType2Validate, jsttype.getJstBlockList(), jsttype.getProblems(), ctx, groupId, uniquePath, mode);
            }
            catch (VjoValidationRuntimeException ex) {
                ex.printStackTrace();
                this.getLogger().log((Throwable)ex);
                result.addResult(jstType2Validate, ctx.getAllProblems());
                ctx.resetProblems();
                break;
            }
            catch (Throwable th) {
                try {
                    th.printStackTrace();
                    this.getLogger().log(th);
                    this.m_hasInternalErrors = true;
                    continue;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    result.addResult(jstType2Validate, ctx.getAllProblems());
                    ctx.resetProblems();
                }
            }
            result.addResult(jstType2Validate, ctx.getAllProblems());
            ctx.resetProblems();
        }
        return result;
    }

    public VjoValidationResult validateComplete(List<IJstType> entryJstTypes, String groupId) {
        return this.validateComplete(entryJstTypes, groupId, VjoValidationMode.validateTypeSpace);
    }

    public VjoValidationResult validateComplete(List<IJstType> entryJstTypes, String groupId, VjoValidationMode mode) {
        ArrayList<IJstType> toValidate = new ArrayList<IJstType>();
        for (IJstType unit : entryJstTypes) {
            toValidate.add(unit);
        }
        VjoValidationResult result = new VjoValidationResult();
        VjoValidationCtx ctx = new VjoValidationCtx();
        this.initValidationCtx(ctx, groupId, mode);
        for (IJstType jstType : toValidate) {
            try {
                this.walkThrough(jstType, jstType.getJstBlockList(), jstType.getProblems(), ctx, groupId, null, mode);
            }
            catch (VjoValidationRuntimeException ex) {
                this.getLogger().log((Throwable)ex);
                result.addResult(jstType, ctx.getAllProblems());
                ctx.resetProblems();
                break;
            }
            catch (Throwable th) {
                try {
                    th.printStackTrace();
                    this.getLogger().log(th);
                    this.m_hasInternalErrors = true;
                    continue;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    result.addResult(jstType, ctx.getAllProblems());
                    ctx.resetProblems();
                }
            }
            result.addResult(jstType, ctx.getAllProblems());
            ctx.resetProblems();
        }
        return result;
    }

    public VjoValidationResult validate(List<IJstType> entryJstTypes) {
        if (entryJstTypes.size() > 0) {
            IJstType candidateType = entryJstTypes.iterator().next();
            String groupName = "";
            if (candidateType != null && candidateType.getPackage() != null && candidateType.getPackage().getGroupName() != null) {
                groupName = candidateType.getPackage().getGroupName();
            }
            return this.validate(entryJstTypes, groupName);
        }
        return new VjoValidationResult();
    }

    private void walkThrough(IJstType jstType, List<? extends IJstNode> syntaxRoots, List<IScriptProblem> problems, VjoValidationCtx ctx, String groupId, String uniquePath, VjoValidationMode mode) {
        Set<IJstType> dependencies = this.calculateDependencies(ctx, jstType, groupId, mode);
        VjoValidationVisitor visitor = new VjoValidationVisitor();
        visitor.setCtx(ctx);
        if (problems != null && problems.size() > 0) {
            this.updateValidationCtx(ctx, uniquePath, jstType, new HashSet<IJstType>(), problems);
            jstType.accept((IJstNodeVisitor)visitor);
            return;
        }
        jstType = ctx.getTypeSpaceType(jstType);
        this.updateValidationCtx(ctx, uniquePath, jstType, dependencies, problems);
        VjoSemanticValidatorRepo.getInstance().deactivateListener(JstIdentifier.class);
        if (syntaxRoots != null) {
            ctx.getJstTypeNames().clear();
            ctx.getScope().addTypeNode(jstType);
            for (IJstNode iJstNode : syntaxRoots) {
                iJstNode.accept((IJstNodeVisitor)visitor);
            }
            ctx.getScope().removeTypeNode(jstType);
        }
        VjoSemanticValidatorRepo.getInstance().activateListener(JstIdentifier.class);
        jstType.accept((IJstNodeVisitor)visitor);
    }

    private void initValidationCtx(VjoValidationCtx ctx, String groupId, VjoValidationMode mode) {
        ctx.setValidationMode(mode);
        ctx.setGroupId(groupId);
        IJstType global = JstGlobalScopeUtil.getGlobal(ctx, this.getJstTypeSpaceMgr());
        ctx.getScope().addScopeNode((IJstNode)global);
    }

    private void updateValidationCtx(VjoValidationCtx ctx, String uniquePath, IJstType entryType, Set<IJstType> dependencies, List<IScriptProblem> syntaxProblems) {
        ctx.addSyntaxProblems(entryType, syntaxProblems);
        ctx.setPath(uniquePath);
    }

    private Set<IJstType> getDirectDependencies(IJstType type) {
        LinkedHashSet<IJstType> dependencies = new LinkedHashSet<IJstType>();
        dependencies.addAll(type.getImports());
        dependencies.addAll(type.getInactiveImports());
        dependencies.addAll(type.getSatisfies());
        dependencies.addAll(type.getExpects());
        dependencies.addAll(type.getExtends());
        for (IJstTypeReference typeRef : type.getMixinsRef()) {
            dependencies.add(typeRef.getReferencedType());
        }
        return dependencies;
    }

    private IJstType lookUpTypeSpace(VjoValidationCtx ctx, IJstType contract, String defaultGroupName) {
        String typeName = contract.getName();
        JstTypeSpaceMgr mgr = this.getJstTypeSpaceMgr();
        if (typeName != null && mgr != null) {
            IJstType typeInSpace;
            String typeGroupName;
            String string = typeGroupName = contract.getPackage() != null ? contract.getPackage().getGroupName() : null;
            if (typeGroupName == null || typeGroupName.length() == 0) {
                typeGroupName = defaultGroupName;
            }
            if ((typeInSpace = mgr.getQueryExecutor().findType(new TypeName(typeGroupName, typeName))) != null) {
                return typeInSpace;
            }
        }
        return null;
    }

    private void getAllDependencies(VjoValidationCtx ctx, IJstType type, Set<IJstType> dependencies, Set<String> circularProof, String defaultGroupName, VjoValidationMode mode) {
        if (circularProof.contains(type.getName())) {
            return;
        }
        circularProof.add(type.getName());
        boolean depFound = false;
        IJstType typeInSpace = null;
        if (VjoValidationMode.validateTypeSpace.equals((Object)mode) && (typeInSpace = this.lookUpTypeSpace(ctx, type, defaultGroupName)) != null) {
            depFound = true;
            ctx.addTypeSpaceType(type, typeInSpace);
        }
        if (typeInSpace == null) {
            typeInSpace = type;
        }
        Set<IJstType> directDependencies = this.getDirectDependencies(typeInSpace);
        Iterator<IJstType> it = directDependencies.iterator();
        while (it.hasNext()) {
            this.getAllDependencies(ctx, it.next(), dependencies, circularProof, defaultGroupName, VjoValidationMode.validateTypeSpace);
        }
        if (VjoValidationMode.validateTypeSpace.equals((Object)mode) && depFound && typeInSpace != null || !VjoValidationMode.validateTypeSpace.equals((Object)mode) && typeInSpace != null) {
            dependencies.add(typeInSpace);
            for (IJstType innerType : typeInSpace.getEmbededTypes()) {
                dependencies.add(innerType);
            }
            ctx.setDependencyVerifier(typeInSpace, new VjoDependencyVerifier(Collections.unmodifiableSet(dependencies), this.m_jstTypeSpaceMgr));
        }
    }

    private Set<IJstType> calculateDependencies(VjoValidationCtx ctx, IJstType entryType, String defaultGroupName, VjoValidationMode mode) {
        if (entryType != null) {
            LinkedHashSet<IJstType> calculated = new LinkedHashSet<IJstType>();
            this.getAllDependencies(ctx, entryType, calculated, new HashSet<String>(), defaultGroupName, mode);
            if (calculated.size() <= 0) {
                calculated.add(entryType);
            }
            return calculated;
        }
        return Collections.emptySet();
    }

    public static class VjoDependencyVerifier
    implements IVjoDependencyVerifiable {
        private final Set<IJstType> _directDependencies;
        private final JstTypeSpaceMgr _tsMgr;

        public VjoDependencyVerifier(Set<IJstType> directDependencies, JstTypeSpaceMgr tsMgr) {
            if (directDependencies == null) {
                throw new IllegalArgumentException("direct dependencies set should never be null");
            }
            this._directDependencies = new HashSet<IJstType>(directDependencies);
            this._tsMgr = tsMgr;
        }

        @Override
        public boolean verify(IJstType currentType, String name) {
            if (name == null) {
                return false;
            }
            for (IJstType dd : this._directDependencies) {
                if (!name.equals(dd.getName()) && !name.equals(dd.getSimpleName())) continue;
                return VjoGroupDependencyHelper.isGroupDependencySatisfied(currentType, dd, this._tsMgr);
            }
            JstPackage pkg = currentType.getRootType().getPackage();
            if (pkg != null) {
                IGroup selfGroup;
                String groupName = pkg.getGroupName();
                ITypeSpace ts = this._tsMgr.getTypeSpace();
                List visibleTypesByName = ts.getVisibleType(name, selfGroup = ts.getGroup(groupName));
                if (visibleTypesByName != null && visibleTypesByName.size() == 1) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public void addDependency(IJstType dep) {
            this._directDependencies.add(dep);
        }

        @Override
        public Set<IJstType> getDirectDependenciesFilteredByGroup(IJstType thisType) {
            HashSet<IJstType> filtered = new HashSet<IJstType>();
            for (IJstType it : this._directDependencies) {
                if (!VjoGroupDependencyHelper.isGroupDependencySatisfied(thisType, it, this._tsMgr)) continue;
                filtered.add(it);
            }
            return filtered;
        }

        @Override
        public Set<IJstType> getDirectDependencies() {
            return Collections.unmodifiableSet(this._directDependencies);
        }

        @Override
        public JstTypeSpaceMgr getTypeSpaceMgr() {
            return this._tsMgr;
        }
    }

    public static class VjoDependencyVerifierDecorator
    implements IVjoDependencyVerifiable {
        private final IVjoDependencyVerifiable _verifiable;
        private final Set<IJstType> _directDependencies;

        public VjoDependencyVerifierDecorator(IVjoDependencyVerifiable verifiable) {
            if (verifiable == null) {
                throw new IllegalArgumentException("null verifiable not allowed in this constructor");
            }
            this._verifiable = verifiable;
            this._directDependencies = new HashSet<IJstType>(verifiable.getDirectDependencies());
        }

        @Override
        public void addDependency(IJstType dep) {
            this._directDependencies.add(dep);
        }

        @Override
        public Set<IJstType> getDirectDependenciesFilteredByGroup(IJstType thisType) {
            HashSet<IJstType> dds = new HashSet<IJstType>();
            for (IJstType it : this._directDependencies) {
                if (!VjoGroupDependencyHelper.isGroupDependencySatisfied(thisType, it, this._verifiable.getTypeSpaceMgr())) continue;
                dds.add(it);
            }
            dds.addAll(this._verifiable.getDirectDependenciesFilteredByGroup(thisType));
            return dds;
        }

        @Override
        public Set<IJstType> getDirectDependencies() {
            return Collections.unmodifiableSet(this._directDependencies);
        }

        @Override
        public boolean verify(IJstType thisType, String name) {
            if (name == null) {
                return false;
            }
            for (IJstType dd : this._directDependencies) {
                if (!name.equals(dd.getName()) && !name.equals(dd.getSimpleName())) continue;
                return VjoGroupDependencyHelper.isGroupDependencySatisfied(thisType, dd, this.getTypeSpaceMgr());
            }
            return this._verifiable.verify(thisType, name);
        }

        @Override
        public JstTypeSpaceMgr getTypeSpaceMgr() {
            return this._verifiable.getTypeSpaceMgr();
        }
    }

    public static class VjoGroupDependencyHelper {
        public static boolean isGroupDependencySatisfied(IJstType curr, IJstType dep, JstTypeSpaceMgr tsMgr) {
            if (curr == null || dep == null || tsMgr == null) {
                throw new IllegalArgumentException("{current type, dependency type, or type space} none should be null!");
            }
            JstPackage package1 = curr.getPackage();
            if (package1 == null) {
                return false;
            }
            String groupName = package1.getGroupName();
            if (groupName == null) {
                return false;
            }
            IGroup currGroup = tsMgr.getTypeSpace().getGroup(groupName);
            Group depGroup = tsMgr.getTypeSpace().getGroup((Object)dep);
            if (currGroup == null || depGroup == null) {
                return false;
            }
            return currGroup.isDependOn((IGroup)depGroup);
        }
    }

    public static enum VjoValidationMode {
        validateTypeSpace,
        validateType;

    }
}

