/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.declaration.JstBlock;
import org.eclipse.vjet.dsf.jst.stmt.RtnStmt;
import org.eclipse.vjet.dsf.jst.stmt.ThrowStmt;
import org.eclipse.vjet.dsf.jst.token.IStmt;

public class VjoMethodControlFlowTable {
    private Map<IJstMethod, CtrlFlowNode> m_mtd2CtrlFlowMap;
    private Map<JstBlock, Boolean> blockUnreachableValidatedMap;

    public List<IStmt> lookUpStmt(IJstMethod method) {
        return this.lookUpStmt(method, true);
    }

    public List<IStmt> lookUpStmt(IJstMethod method, boolean fromRoot) {
        if (this.m_mtd2CtrlFlowMap == null) {
            return Collections.emptyList();
        }
        CtrlFlowNode flowTree = this.m_mtd2CtrlFlowMap.get(method);
        if (flowTree == null) {
            return Collections.emptyList();
        }
        CtrlFlowNode rootNode = flowTree;
        if (fromRoot) {
            while (rootNode.getParent() != null) {
                rootNode = rootNode.getParent();
            }
        }
        ArrayList<IStmt> rtnStmts = new ArrayList<IStmt>();
        this.flatten(rootNode, rtnStmts);
        return rtnStmts;
    }

    public List<IJstNode> lookUpScopedVars(IJstMethod method) {
        if (this.m_mtd2CtrlFlowMap == null) {
            return Collections.emptyList();
        }
        CtrlFlowNode flowTree = this.m_mtd2CtrlFlowMap.get(method);
        if (flowTree == null) {
            return Collections.emptyList();
        }
        ArrayList<IJstNode> scopedVars = new ArrayList<IJstNode>();
        CtrlFlowNode rootNode = flowTree;
        while (rootNode != null) {
            scopedVars.addAll(rootNode.getScopedVars());
            rootNode = rootNode.getParent();
        }
        return scopedVars;
    }

    private boolean flatten(CtrlFlowNode node, List<IStmt> stmts) {
        if (node.getRtnStmt() != null) {
            stmts.add((IStmt)node.getRtnStmt());
            return true;
        }
        if (node.getThrowStmt() != null) {
            stmts.add((IStmt)node.getThrowStmt());
            return true;
        }
        boolean allReturned = false;
        Iterator<CtrlFlowNode> it = node.getChildren().iterator();
        while (it.hasNext()) {
            allReturned = this.flatten(it.next(), stmts);
            if (!allReturned) break;
        }
        if (!allReturned) {
            stmts.add(null);
        }
        return allReturned;
    }

    public void addStmt(IJstMethod method, RtnStmt stmt) {
        CtrlFlowNode flowTree = this.getRtnFlow(method);
        flowTree.setRtnStmt(stmt);
    }

    public void addStmt(IJstMethod method, ThrowStmt stmt) {
        CtrlFlowNode flowTree = this.getRtnFlow(method);
        flowTree.setThrowStmt(stmt);
    }

    public void addScopedVar(IJstMethod method, IJstNode symbol) {
        CtrlFlowNode flowTree = this.getRtnFlow(method);
        flowTree.addScopedVar(symbol);
    }

    private CtrlFlowNode getRtnFlow(IJstMethod method) {
        CtrlFlowNode flowTree;
        if (this.m_mtd2CtrlFlowMap == null) {
            this.m_mtd2CtrlFlowMap = new HashMap<IJstMethod, CtrlFlowNode>();
        }
        if ((flowTree = this.m_mtd2CtrlFlowMap.get(method)) == null) {
            flowTree = new CtrlFlowNode();
            this.m_mtd2CtrlFlowMap.put(method, flowTree);
        }
        return flowTree;
    }

    public void addBranch(IJstMethod method, IJstNode block) {
        IJstNode ifBranchNode;
        CtrlFlowNode flowTree = this.getRtnFlow(method);
        CtrlFlowNode branchNode = new CtrlFlowNode();
        IJstNode iJstNode = ifBranchNode = block != null ? block.getParentNode() : null;
        if (ifBranchNode != null && ifBranchNode.getParentNode() == method.getBlock()) {
            flowTree.removeAllChildren();
        }
        flowTree.appendChild(branchNode);
        branchNode.setParent(flowTree);
        this.m_mtd2CtrlFlowMap.put(method, branchNode);
    }

    public void endBranch(IJstMethod method, IJstNode block) {
        CtrlFlowNode branchNode = this.getRtnFlow(method);
        if (branchNode.getParent() != null) {
            CtrlFlowNode flowTree = branchNode.getParent();
            this.m_mtd2CtrlFlowMap.put(method, flowTree);
        }
    }

    public void setBlockUnreachableValidated(JstBlock block, boolean validated) {
        if (this.blockUnreachableValidatedMap == null) {
            this.blockUnreachableValidatedMap = new HashMap<JstBlock, Boolean>();
        }
        this.blockUnreachableValidatedMap.put(block, validated);
    }

    public boolean hasBlockUnreachableValidated(JstBlock block) {
        if (this.blockUnreachableValidatedMap == null) {
            return false;
        }
        Boolean validated = this.blockUnreachableValidatedMap.get(block);
        return validated == null ? false : validated;
    }

    private static class CtrlFlowNode {
        public static final CtrlFlowNode DEAD = new CtrlFlowNode();
        private CtrlFlowNode m_parent;
        private List<CtrlFlowNode> m_children;
        private RtnStmt m_rtnStmt;
        private ThrowStmt m_throwStmt;
        private List<IJstNode> m_scopedVars;

        private CtrlFlowNode() {
        }

        public CtrlFlowNode getParent() {
            return this.m_parent;
        }

        public List<CtrlFlowNode> getChildren() {
            if (this.m_children == null) {
                return Collections.emptyList();
            }
            return this.m_children;
        }

        public RtnStmt getRtnStmt() {
            return this.m_rtnStmt;
        }

        public ThrowStmt getThrowStmt() {
            return this.m_throwStmt;
        }

        public List<IJstNode> getScopedVars() {
            if (this.m_scopedVars == null) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableList(this.m_scopedVars);
        }

        public void setParent(CtrlFlowNode parent) {
            this.m_parent = parent;
        }

        public void appendChild(CtrlFlowNode child) {
            if (this.m_children == null) {
                this.m_children = new ArrayList<CtrlFlowNode>();
            }
            this.m_children.add(child);
        }

        public void removeChild(CtrlFlowNode child) {
            if (this.m_children != null) {
                this.m_children.remove(child);
            }
        }

        public void removeAllChildren() {
            if (this.m_children != null) {
                this.m_children.clear();
            }
        }

        public void setRtnStmt(RtnStmt stmt) {
            this.m_rtnStmt = stmt;
        }

        public void setThrowStmt(ThrowStmt stmt) {
            this.m_throwStmt = stmt;
        }

        public void addScopedVar(IJstNode scopedVar) {
            if (this.m_scopedVars == null) {
                this.m_scopedVars = new ArrayList<IJstNode>();
            }
            this.m_scopedVars.add(scopedVar);
        }
    }
}

